/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class DistanceRidge {
    public float[][] data;
    public int w;
    public int h;
    public int d;
    public float scale;
    public float scaleInv;
    public float scaleSq;
    public float scaleInvSq;

    public ImagePlus run(ImagePlus imp, float scaleXY, float scaleZ, int nbCPUs) {
        int i;
        float[] sk;
        ImageStack stack = imp.getStack();
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.d = imp.getStackSize();
        this.scale = scaleXY / scaleZ;
        this.scaleInv = scaleZ / scaleXY;
        this.scaleSq = this.scale * this.scale;
        this.scaleInvSq = this.scaleInv * this.scaleInv;
        ImageStack newStack = new ImageStack(this.w, this.h);
        float[][] sNew = new float[this.d][];
        for (int k = 0; k < this.d; ++k) {
            FloatProcessor ipk = new FloatProcessor(this.w, this.h);
            newStack.addSlice(null, (ImageProcessor)ipk);
            sNew[k] = (float[])ipk.getPixels();
        }
        float[][] s = new float[this.d][];
        for (int k = 0; k < this.d; ++k) {
            s[k] = (float[])stack.getPixels(k + 1);
        }
        IJ.showStatus((String)"Distance Ridge: scanning the data");
        float distMax = 0.0f;
        for (int k = 0; k < this.d; ++k) {
            sk = s[k];
            for (int j = 0; j < this.h; ++j) {
                for (i = 0; i < this.w; ++i) {
                    int ind = i + this.w * j;
                    if (!(sk[ind] > distMax)) continue;
                    distMax = sk[ind];
                }
            }
        }
        int rSqMax = (int)(distMax * distMax + 0.5f) + 1;
        boolean[] occurs = new boolean[rSqMax];
        for (i = 0; i < rSqMax; ++i) {
            occurs[i] = false;
        }
        for (int k = 0; k < this.d; ++k) {
            sk = s[k];
            for (int j = 0; j < this.h; ++j) {
                for (int i2 = 0; i2 < this.w; ++i2) {
                    int ind = i2 + this.w * j;
                    occurs[(int)(sk[ind] * sk[ind] + 0.5f)] = true;
                }
            }
        }
        int numRadii = 0;
        for (int i3 = 0; i3 < rSqMax; ++i3) {
            if (!occurs[i3]) continue;
            ++numRadii;
        }
        int[] distSqIndex = new int[rSqMax];
        int[] distSqValues = new int[numRadii];
        int indDS = 0;
        for (int i4 = 0; i4 < rSqMax; ++i4) {
            if (!occurs[i4]) continue;
            distSqIndex[i4] = indDS;
            distSqValues[indDS++] = i4;
        }
        float[][] rSqTemplate = this.createTemplate(distSqValues);
        for (int k = 0; k < this.d; ++k) {
            sk = s[k];
            float[] skNew = sNew[k];
            for (int j = 0; j < this.h; ++j) {
                for (int i5 = 0; i5 < this.w; ++i5) {
                    int ind = i5 + this.w * j;
                    if (!(sk[ind] > 0.0f)) continue;
                    boolean notRidgePoint = false;
                    int sk0Sq = (int)(sk[ind] * sk[ind] + 0.5f);
                    int sk0SqInd = distSqIndex[sk0Sq];
                    for (int dz = -1; dz <= 1; ++dz) {
                        int k1 = k + dz;
                        if (k1 >= 0 && k1 < this.d) {
                            float[] sk1 = s[k1];
                            int numCompZ = dz == 0 ? 0 : 1;
                            for (int dy = -1; dy <= 1; ++dy) {
                                int j1 = j + dy;
                                if (j1 >= 0 && j1 < this.h) {
                                    int numCompY = dy == 0 ? 0 : 1;
                                    for (int dx = -1; dx <= 1; ++dx) {
                                        float sk1Sq;
                                        int numCompX;
                                        int numComp;
                                        int i1 = i5 + dx;
                                        if (i1 >= 0 && i1 < this.w && (numComp = (numCompX = dx == 0 ? 0 : 1) + numCompY + numCompZ) > 0 && (sk1Sq = sk1[i1 + this.w * j1] * sk1[i1 + this.w * j1]) >= rSqTemplate[numComp - 1][sk0SqInd]) {
                                            notRidgePoint = true;
                                        }
                                        if (notRidgePoint) break;
                                    }
                                }
                                if (notRidgePoint) break;
                            }
                        }
                        if (notRidgePoint) break;
                    }
                    if (notRidgePoint) continue;
                    skNew[ind] = sk[ind];
                }
            }
        }
        String title = this.stripExtension(imp.getTitle());
        ImagePlus impOut = new ImagePlus(title + "_DR", newStack);
        return impOut;
    }

    float[][] createTemplate(int[] distSqValues) {
        float[][] t = new float[][]{this.scanCube(1, 0, 0, distSqValues), this.scanCube(1, 1, 0, distSqValues), this.scanCube(1, 1, 1, distSqValues)};
        return t;
    }

    float[] scanCube(int dx, int dy, int dz, int[] distSqValues) {
        int numRadii = distSqValues.length;
        float[] r1Sq = new float[numRadii];
        if (dx == 0 && dy == 0 && dz == 0) {
            for (int rSq = 0; rSq < numRadii; ++rSq) {
                r1Sq[rSq] = 2.1474836E9f;
            }
        } else {
            float dxAbs = -((float)Math.abs(dx));
            float dyAbs = -((float)Math.abs(dy));
            float dzAbs = -((float)Math.abs(dz));
            for (int rSqInd = 0; rSqInd < numRadii; ++rSqInd) {
                int rSq = distSqValues[rSqInd];
                float max = 0.0f;
                int r = 1 + (int)Math.sqrt(rSq);
                int rz = (int)((double)((float)(r - 1) * this.scale) + 0.5) + 1;
                for (int k = 0; k <= rz; ++k) {
                    float scank = (float)(k * k) * this.scaleInvSq;
                    float dk = ((float)k - dzAbs) * ((float)k - dzAbs) * this.scaleInvSq;
                    for (int j = 0; j <= r; ++j) {
                        float iPlus;
                        float dkji;
                        float scankj = scank * (float)j * (float)j;
                        if (!(scankj <= (float)rSq) || !((dkji = dk + ((float)j - dyAbs) * ((float)j - dyAbs) + (iPlus = (float)((int)Math.sqrt((float)rSq - scankj)) - dxAbs) * iPlus) > max)) continue;
                        max = dkji;
                    }
                }
                r1Sq[rSqInd] = max;
            }
        }
        return r1Sq;
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }
}

