/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble3D;
import mitiv.deconv.WeightedConvolutionDouble;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;

class WeightedConvolutionDouble3D
extends WeightedConvolutionDouble {
    private final int dim1;
    private final int off1;
    private final int end1;
    private final int dim2;
    private final int off2;
    private final int end2;
    private final int dim3;
    private final int off3;
    private final int end3;
    private final ConvolutionDouble3D cnvl;

    public WeightedConvolutionDouble3D(ConvolutionDouble3D convolutionDouble3D) {
        super(convolutionDouble3D.getInputSpace(), convolutionDouble3D.getOutputSpace());
        this.cnvl = convolutionDouble3D;
        Shape shape = convolutionDouble3D.workShape;
        Shape shape2 = convolutionDouble3D.getOutputSpace().getShape();
        int[] nArray = convolutionDouble3D.outputOffsets;
        this.dim1 = shape.dimension(0);
        this.off1 = nArray[0];
        this.end1 = this.off1 + shape2.dimension(0);
        this.dim2 = shape.dimension(1);
        this.off2 = nArray[1];
        this.end2 = this.off2 + shape2.dimension(1);
        this.dim3 = shape.dimension(2);
        this.off3 = nArray[2];
        this.end3 = this.off3 + shape2.dimension(2);
    }

    @Override
    protected double _cost(double d, Vector vector) {
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        double d2 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n = 0;
        if (this.wgt == null) {
            for (int i = this.off3; i < this.end3; ++i) {
                for (int j = this.off2; j < this.end2; ++j) {
                    int n2 = 2 * (this.off1 + this.dim1 * (j + this.dim2 * i));
                    for (int k = this.off1; k < this.end1; ++k) {
                        double d3 = dArray[n2] - this.dat[n];
                        d2 += d3 * d3;
                        ++n;
                        n2 += 2;
                    }
                }
            }
        } else {
            for (int i = this.off3; i < this.end3; ++i) {
                for (int j = this.off2; j < this.end2; ++j) {
                    int n3 = 2 * (this.off1 + this.dim1 * (j + this.dim2 * i));
                    for (int k = this.off1; k < this.end1; ++k) {
                        double d4 = this.wgt[n];
                        double d5 = dArray[n3] - this.dat[n];
                        d2 += d4 * d5 * d5;
                        ++n;
                        n3 += 2;
                    }
                }
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    protected double _cost(double d, Vector vector, Vector vector2, boolean bl) {
        int n;
        int n2;
        int n3;
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        boolean bl2 = this.wgt != null;
        double d2 = d;
        double d3 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.off3; ++n3) {
            for (n2 = 0; n2 < this.dim2; ++n2) {
                for (n = 0; n < this.dim1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
            }
        }
        for (n3 = this.off3; n3 < this.end3; ++n3) {
            for (n2 = 0; n2 < this.off2; ++n2) {
                for (n = 0; n < this.dim1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
            }
            for (n2 = this.off2; n2 < this.end2; ++n2) {
                double d4;
                for (n = 0; n < this.off1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
                if (bl2) {
                    for (n = this.off1; n < this.end1; ++n) {
                        d4 = this.wgt[n4];
                        double d5 = dArray[n5] - this.dat[n4];
                        double d6 = d4 * d5;
                        d3 += d5 * d6;
                        dArray[n5] = d2 * d6;
                        dArray[n5 + 1] = 0.0;
                        ++n4;
                        n5 += 2;
                    }
                } else {
                    for (n = this.off1; n < this.end1; ++n) {
                        d4 = dArray[n5] - this.dat[n4];
                        d3 += d4 * d4;
                        dArray[n5] = d2 * d4;
                        dArray[n5 + 1] = 0.0;
                        ++n4;
                        n5 += 2;
                    }
                }
                for (n = this.end1; n < this.dim1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
            }
            for (n2 = this.end2; n2 < this.dim2; ++n2) {
                for (n = 0; n < this.dim1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
            }
        }
        for (n3 = this.end3; n3 < this.dim3; ++n3) {
            for (n2 = 0; n2 < this.dim2; ++n2) {
                for (n = 0; n < this.dim1; ++n) {
                    dArray[n5] = 0.0;
                    dArray[n5 + 1] = 0.0;
                    n5 += 2;
                }
            }
        }
        double[] dArray2 = ((DoubleShapedVector)vector2).getData();
        this.cnvl.convolve(true);
        if (bl) {
            n4 = 0;
            n5 = 0;
            while (n4 < dArray2.length) {
                dArray2[n4] = dArray[n5];
                ++n4;
                n5 += 2;
            }
        } else {
            n4 = 0;
            n5 = 0;
            while (n4 < dArray2.length) {
                int n6 = n4++;
                dArray2[n6] = dArray2[n6] + dArray[n5];
                n5 += 2;
            }
        }
        return d * d3 / 2.0;
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        this.cnvl.setPSF(shapedArray, nArray, bl);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        this.cnvl.setPSF(shapedVector);
    }
}

