/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array2D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;

    protected Array2D(int n, int n2) {
        this.shape = new Shape(n, n2);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
    }

    protected Array2D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array2D(Shape shape) {
        if (shape.rank() != 2) {
            throw new IllegalArgumentException("Bad number of dimensions for 2-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
    }

    @Override
    public final int getRank() {
        return 2;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array2D copy();

    public abstract Array1D slice(int var1);

    public abstract Array1D slice(int var1, int var2);

    public abstract Array2D view(Range var1, Range var2);

    public abstract Array2D view(int[] var1, int[] var2);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10 = (n5 - 1) * n3;
        if (n10 >= 0) {
            n9 = n2;
            n8 = n2 + n10;
        } else {
            n9 = n2 + n10;
            n8 = n2;
        }
        n10 = (n6 - 1) * n4;
        if (n10 >= 0) {
            n8 += n10;
        } else {
            n9 += n10;
        }
        if (n9 < 0 || n8 >= n) {
            throw new IndexOutOfBoundsException("2D view is not within available space");
        }
        int n11 = Math.abs(n3);
        if (n11 <= (n7 = Math.abs(n4))) {
            return 1;
        }
        if (n11 >= n7) {
            return 2;
        }
        return 0;
    }
}

