/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.ima4;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.ima4.IMA4;
import com.ibm.media.codec.audio.ima4.IMA4State;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder_ms
extends AudioCodec {
    private IMA4State ima4state;

    public JavaDecoder_ms() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ima4/ms")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "IMA4 MS Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        int channels;
        AudioFormat af = (AudioFormat)in;
        int fs = af.getFrameSizeInBits();
        if (fs % (32 * (channels = af.getChannels())) != 0) {
            return new Format[0];
        }
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 1, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.ima4state = new IMA4State();
    }

    public void close() {
        this.ima4state = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int channels = this.outputFormat.getChannels();
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, inData.length * 4);
        int blockSize = this.inputFormat.getFrameSizeInBits() >> 3;
        int outLength = this.decodeJavaMSIMA4(inData, outData, inputBuffer.getLength(), outData.length, channels, blockSize);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    private int decodeJavaMSIMA4(byte[] inBuffer, byte[] outBuffer, int lenIn, int lenOut, int nChannels, int blockSize) {
        switch (nChannels) {
            case 1: {
                return this.decodeMSIMA4mono(inBuffer, outBuffer, lenIn, lenOut, blockSize);
            }
            case 2: {
                return this.decodeMSIMA4stereo(inBuffer, outBuffer, lenIn, lenOut, blockSize);
            }
        }
        throw new RuntimeException("MSIMA4: Can only handle 1 or 2 channels\n");
    }

    private int decodeMSIMA4mono(byte[] inBuffer, byte[] outBuffer, int lenIn, int lenOut, int blockSize) {
        int inCount = 0;
        int outCount = 0;
        lenIn = lenIn / blockSize * blockSize;
        while (inCount < lenIn) {
            int index;
            int prevVal = inBuffer[inCount++] & 0xFF;
            prevVal |= inBuffer[inCount++] << 8;
            if ((index = inBuffer[inCount++] & 0xFF) > 88) {
                index = 88;
            }
            outBuffer[outCount++] = (byte)(prevVal >> 8);
            outBuffer[outCount++] = (byte)prevVal;
            this.ima4state.valprev = prevVal;
            this.ima4state.index = index;
            IMA4.decode(inBuffer, ++inCount, outBuffer, outCount, blockSize - 4 << 1, this.ima4state, 0);
            inCount += blockSize - 4;
            outCount += blockSize - 4 << 2;
        }
        return outCount;
    }

    private int decodeMSIMA4stereo(byte[] inBuffer, byte[] outBuffer, int lenIn, int lenOut, int blockSize) {
        int inCount = 0;
        int outCount = 0;
        lenIn = lenIn / blockSize * blockSize;
        int i2 = 0;
        while (i2 < outBuffer.length) {
            outBuffer[i2] = 0;
            ++i2;
        }
        while (inCount < lenIn) {
            int indexR;
            int indexL;
            int storedinCount = inCount;
            int storedoutCount = outCount;
            int prevValL = inBuffer[inCount++] & 0xFF;
            prevValL |= inBuffer[inCount++] << 8;
            if ((indexL = inBuffer[inCount++] & 0xFF) > 88) {
                indexL = 88;
            }
            ++inCount;
            outBuffer[outCount++] = (byte)(prevValL >> 8);
            outBuffer[outCount++] = (byte)prevValL;
            outCount += 2;
            inCount += 4;
            this.ima4state.valprev = prevValL;
            this.ima4state.index = indexL;
            int i3 = blockSize - 8;
            while (i3 > 0) {
                IMA4.decode(inBuffer, inCount, outBuffer, outCount, 8, this.ima4state, 2);
                inCount += 8;
                outCount += 32;
                i3 -= 8;
            }
            inCount = storedinCount + 4;
            outCount = storedoutCount + 2;
            int prevValR = inBuffer[inCount++] & 0xFF;
            prevValR |= inBuffer[inCount++] << 8;
            if ((indexR = inBuffer[inCount++] & 0xFF) > 88) {
                indexR = 88;
            }
            ++inCount;
            outBuffer[outCount++] = (byte)(prevValR >> 8);
            outBuffer[outCount++] = (byte)prevValR;
            this.ima4state.valprev = prevValR;
            this.ima4state.index = indexR;
            outCount += 2;
            inCount += 4;
            int i4 = blockSize - 8;
            while (i4 > 0) {
                IMA4.decode(inBuffer, inCount, outBuffer, outCount, 8, this.ima4state, 2);
                inCount += 8;
                outCount += 32;
                i4 -= 8;
            }
            inCount = storedinCount + blockSize;
            outCount = storedoutCount + (blockSize - 8 << 2) + 4;
        }
        return outCount;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

