/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

class SelectedSparseIntMatrix1D
extends IntMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseIntMatrix1D(AbstractLongIntMap elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedSparseIntMatrix1D(int size, AbstractLongIntMap elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    public AbstractLongIntMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public int getQuick(int index) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + index * this.stride]);
    }

    @Override
    public long index(int rank) {
        return (long)this.offset + (long)this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public IntMatrix1D like(int size) {
        return new SparseIntMatrix1D(size);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new SparseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public IntMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public void setQuick(int index, int value) {
        long i = (long)this.offset + (long)this.offsets[this.zero + index * this.stride];
        if (value == 0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix1D other) {
        if (other instanceof SelectedSparseIntMatrix1D) {
            SelectedSparseIntMatrix1D otherMatrix = (SelectedSparseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseIntMatrix1D) {
            SparseIntMatrix1D otherMatrix = (SparseIntMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected IntMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseIntMatrix1D(this.elements, offsets);
    }
}

