/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble3D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class StriddenDouble3D
extends Double3D {
    final int order;
    final double[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final boolean flat;

    public StriddenDouble3D(double[] dArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 3) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = dArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.order = Double3D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2;
    }

    public StriddenDouble3D(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n5, n6, n7);
        this.data = dArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.order = Double3D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7);
        this.flat = n == 0 && n2 == 1 && n3 == n5 && n4 == n6 * n3;
    }

    @Override
    public void checkSanity() {
        Double3D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    final int index(int n, int n2, int n3) {
        return this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final double get(int n, int n2, int n3) {
        return this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, double d) {
        this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = d;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = d;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = d;
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = doubleGenerator.nextDouble();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = doubleGenerator.nextDouble();
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] + d;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] + d;
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] - d;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] - d;
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] * d;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] * d;
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = doubleFunction.apply(this.data[n3]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = doubleFunction.apply(this.data[n5]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        if (bl) {
                            doubleScanner.update(this.data[n3]);
                            continue;
                        }
                        doubleScanner.initialize(this.data[n3]);
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        if (bl) {
                            doubleScanner.update(this.data[n5]);
                            continue;
                        }
                        doubleScanner.initialize(this.data[n5]);
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        double[] dArray = new double[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, dArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                int n2 = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n4 = this.stride1 * k + n3;
                        dArray[++n] = this.data[n4];
                    }
                }
            }
        }
        return dArray;
    }

    @Override
    public double[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Double2D slice(int n) {
        return new StriddenDouble2D(this.data, this.offset + this.stride3 * n, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    @Override
    public Double2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 0) {
            n2 += 3;
        }
        if (n2 == 0) {
            n7 = this.offset + this.stride1 * n;
            n6 = this.stride2;
            n5 = this.stride3;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.offset + this.stride2 * n;
            n6 = this.stride1;
            n5 = this.stride3;
            n4 = this.dim1;
            n3 = this.dim3;
        } else if (n2 == 2) {
            n7 = this.offset + this.stride3 * n;
            n6 = this.stride1;
            n5 = this.stride2;
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenDouble2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Double3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenDouble3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Double3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.stride3, this.dim3, nArray3);
        return new SelectedDouble3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.flatten(), this.number);
    }
}

