/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort2D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short2D
extends Array2D
implements ShortArray {
    protected Short2D(int n, int n2) {
        super(n, n2);
    }

    protected Short2D(int[] nArray) {
        super(nArray);
    }

    protected Short2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2);

    public abstract void set(int var1, int var2, short var3);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, s);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, s);
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (short)(this.get(i, j) + s));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (short)(this.get(j, i) + s));
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (short)(this.get(i, j) - s));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (short)(this.get(j, i) - s));
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (short)(this.get(i, j) * s));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (short)(this.get(j, i) * s));
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, shortFunction.apply(this.get(i, j)));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, shortFunction.apply(this.get(j, i)));
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, shortGenerator.nextShort());
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, shortGenerator.nextShort());
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        shortScanner.update(this.get(i, j));
                        continue;
                    }
                    shortScanner.initialize(this.get(i, j));
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        shortScanner.update(this.get(j, i));
                        continue;
                    }
                    shortScanner.initialize(this.get(j, i));
                    bl = true;
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s2 = this.get(i, j);
                    if (s2 >= s) continue;
                    s = s2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s3 = this.get(j, i);
                    if (s3 >= s) continue;
                    s = s3;
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s2 = this.get(i, j);
                    if (s2 <= s) continue;
                    s = s2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s3 = this.get(j, i);
                    if (s3 <= s) continue;
                    s = s3;
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s3 = this.get(i, j);
                    if (s3 < s) {
                        s = s3;
                    }
                    if (s3 <= s2) continue;
                    s2 = s3;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    short s4 = this.get(j, i);
                    if (s4 < s) {
                        s = s4;
                    }
                    if (s4 <= s2) continue;
                    s2 = s4;
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    n += this.get(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    n += this.get(j, i);
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    byArray[++n] = (byte)this.get(j, i);
                }
            }
        }
        return Byte2D.wrap(byArray, this.getShape());
    }

    @Override
    public Short2D toShort() {
        return this;
    }

    @Override
    public Int2D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    nArray[++n] = this.get(j, i);
                }
            }
        }
        return Int2D.wrap(nArray, this.getShape());
    }

    @Override
    public Long2D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    lArray[++n] = this.get(j, i);
                }
            }
        }
        return Long2D.wrap(lArray, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    fArray[++n] = this.get(j, i);
                }
            }
        }
        return Float2D.wrap(fArray, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    dArray[++n] = this.get(j, i);
                }
            }
        }
        return Double2D.wrap(dArray, this.getShape());
    }

    @Override
    public Short2D copy() {
        return new FlatShort2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short2D short2D = shapedArray.getType() == 1 ? (Short2D)shapedArray : (Short2D)shapedArray.toShort();
        if (this.getOrder() == 2 && short2D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, short2D.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, short2D.get(j, i));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (short)doubleShapedVector.get(++n));
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (short)floatShapedVector.get(++n));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short2D create() {
        return new FlatShort2D(this.getShape());
    }

    public static Short2D create(int n, int n2) {
        return new FlatShort2D(n, n2);
    }

    public static Short2D create(int[] nArray) {
        return new FlatShort2D(nArray);
    }

    public static Short2D create(Shape shape) {
        return new FlatShort2D(shape);
    }

    public static Short2D wrap(short[] sArray, int n, int n2) {
        return new FlatShort2D(sArray, n, n2);
    }

    public static Short2D wrap(short[] sArray, int[] nArray) {
        return new FlatShort2D(sArray, nArray);
    }

    public static Short2D wrap(short[] sArray, Shape shape) {
        return new FlatShort2D(sArray, shape);
    }

    public static Short2D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        return new StriddenShort2D(sArray, n, n2, n3, n4, n5);
    }

    @Override
    public abstract Short1D slice(int var1);

    @Override
    public abstract Short1D slice(int var1, int var2);

    @Override
    public abstract Short2D view(Range var1, Range var2);

    @Override
    public abstract Short2D view(int[] var1, int[] var2);

    @Override
    public abstract Short1D as1D();
}

