/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;

public class ArmijoLineSearch
extends LineSearch {
    private double bestStep = 0.0;
    private double bestFunc = 0.0;
    private boolean bypass = false;
    protected double sigma = 0.05;
    protected double rho = 0.5;

    public void setGain(double d) {
        if (Double.isNaN(d) || d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.rho = d;
    }

    public double getGain() {
        return this.rho;
    }

    public void setTolerance(double d) {
        if (Double.isNaN(d) || d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.sigma = d;
    }

    public double getTolerance() {
        return this.sigma;
    }

    public static void main(String[] stringArray) {
        ArmijoLineSearch armijoLineSearch = new ArmijoLineSearch(0.5, 0.001);
        double d = 12.0;
        double d2 = 0.0;
        double d3 = -1.0;
        double d4 = 5.0;
        LineSearchTask lineSearchTask = armijoLineSearch.start(d2, d3, d, 0.0, 1.0E20 * d);
        System.out.println("state = " + (Object)((Object)lineSearchTask));
        System.out.println("finished = " + armijoLineSearch.finished());
        for (int i = 1; i <= 6; ++i) {
            d = armijoLineSearch.getStep();
            double d5 = d2 + d * (d3 + 0.5 * d4 * d);
            double d6 = d3 + d4 * d;
            lineSearchTask = armijoLineSearch.iterate(d5, d6);
            System.out.println("alpha[" + i + "] = " + d + ";" + " f[" + i + "] = " + d5 + ";" + " g[" + i + "] = " + d6 + ";" + " state[" + i + "] = " + (Object)((Object)lineSearchTask) + ";" + " finished[" + i + "] = " + armijoLineSearch.finished() + ";");
        }
    }

    public ArmijoLineSearch() {
    }

    public ArmijoLineSearch(double d, double d2) {
        this.setGain(d);
        this.setTolerance(d2);
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    @Override
    protected void startHook() {
        this.bestFunc = this.finit;
        this.bestStep = 0.0;
        this.bypass = false;
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    public void iterateHook(double d, double d2) {
        if (this.bypass || d - this.finit <= this.stp * this.sigma * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
        } else {
            if (d < this.bestFunc) {
                this.bestStep = this.stp;
                this.bestFunc = d;
                this.stp = this.rho * this.stp;
            } else if (this.bestStep > this.stp) {
                this.bypass = true;
                this.stp = this.bestStep;
            } else {
                this.stp = this.rho * this.stp;
            }
            this.success(LineSearchTask.SEARCH);
        }
    }
}

