/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.time;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.ZeroIsMaxDateTimeField;
import uk.ac.rdg.resc.edal.time.OneBasedPreciseDateTimeField;

abstract class FixedYearLengthChronology
extends BaseChronology {
    private static final DurationField millisecondDuration = MillisDurationField.INSTANCE;
    private static final DurationField secondDuration = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
    private static final DurationField minuteDuration = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
    private static final DurationField hourDuration = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
    private static final DurationField halfdayDuration = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
    private static final DurationField dayDuration = new PreciseDurationField(DurationFieldType.days(), 2L * halfdayDuration.getUnitMillis());
    private static final DurationField weekDuration = new PreciseDurationField(DurationFieldType.weeks(), 7L * dayDuration.getUnitMillis());
    private final DurationField yearDuration;
    private final DurationField centuryDuration;
    private static final DateTimeField millisOfSecond = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), millisecondDuration, secondDuration);
    private static final DateTimeField millisOfDay = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), millisecondDuration, dayDuration);
    private static final DateTimeField secondOfMinute = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), secondDuration, minuteDuration);
    private static final DateTimeField secondOfDay = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), secondDuration, dayDuration);
    private static final DateTimeField minuteOfHour = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), minuteDuration, hourDuration);
    private static final DateTimeField minuteOfDay = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), minuteDuration, dayDuration);
    private static final DateTimeField hourOfDay = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), hourDuration, dayDuration);
    private static final DateTimeField hourOfHalfday = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), hourDuration, halfdayDuration);
    private static final DateTimeField halfdayOfDay = new PreciseDateTimeField(DateTimeFieldType.halfdayOfDay(), halfdayDuration, dayDuration);
    private static final DateTimeField clockhourOfDay = new ZeroIsMaxDateTimeField(hourOfDay, DateTimeFieldType.clockhourOfDay());
    private static final DateTimeField clockhourOfHalfday = new ZeroIsMaxDateTimeField(hourOfHalfday, DateTimeFieldType.clockhourOfHalfday());
    private static final DateTimeField dayOfWeek = new PreciseDateTimeField(DateTimeFieldType.dayOfWeek(), dayDuration, weekDuration);
    private final DateTimeField dayOfYear;
    private final DateTimeField yearOfCentury;
    private final DateTimeField year;
    private final int daysInYear;

    protected FixedYearLengthChronology(int daysInYear) {
        this.daysInYear = daysInYear;
        this.yearDuration = new PreciseDurationField(DurationFieldType.years(), (long)daysInYear * dayDuration.getUnitMillis());
        this.centuryDuration = new PreciseDurationField(DurationFieldType.centuries(), 100L * this.yearDuration.getUnitMillis());
        this.dayOfYear = new OneBasedPreciseDateTimeField(DateTimeFieldType.dayOfYear(), dayDuration, this.yearDuration);
        this.yearOfCentury = new PreciseDateTimeField(DateTimeFieldType.yearOfCentury(), this.yearDuration, this.centuryDuration);
        this.year = new YearField(this.yearDuration);
    }

    @Override
    public final DurationField millis() {
        return millisecondDuration;
    }

    @Override
    public final DurationField seconds() {
        return secondDuration;
    }

    @Override
    public final DurationField minutes() {
        return minuteDuration;
    }

    @Override
    public final DurationField hours() {
        return hourDuration;
    }

    @Override
    public final DurationField halfdays() {
        return halfdayDuration;
    }

    @Override
    public final DurationField days() {
        return dayDuration;
    }

    @Override
    public final DurationField weeks() {
        return weekDuration;
    }

    @Override
    public abstract DurationField months();

    @Override
    public final DurationField years() {
        return this.yearDuration;
    }

    @Override
    public final DurationField centuries() {
        return this.centuryDuration;
    }

    @Override
    public final DateTimeField millisOfSecond() {
        return millisOfSecond;
    }

    @Override
    public final DateTimeField millisOfDay() {
        return millisOfDay;
    }

    @Override
    public final DateTimeField secondOfMinute() {
        return secondOfMinute;
    }

    @Override
    public final DateTimeField secondOfDay() {
        return secondOfDay;
    }

    @Override
    public final DateTimeField minuteOfHour() {
        return minuteOfHour;
    }

    @Override
    public final DateTimeField minuteOfDay() {
        return minuteOfDay;
    }

    @Override
    public final DateTimeField hourOfDay() {
        return hourOfDay;
    }

    @Override
    public final DateTimeField hourOfHalfday() {
        return hourOfHalfday;
    }

    @Override
    public final DateTimeField halfdayOfDay() {
        return halfdayOfDay;
    }

    @Override
    public final DateTimeField clockhourOfDay() {
        return clockhourOfDay;
    }

    @Override
    public final DateTimeField clockhourOfHalfday() {
        return clockhourOfHalfday;
    }

    @Override
    public final DateTimeField dayOfWeek() {
        return dayOfWeek;
    }

    @Override
    public abstract DateTimeField dayOfMonth();

    @Override
    public final DateTimeField dayOfYear() {
        return this.dayOfYear;
    }

    @Override
    public abstract DateTimeField monthOfYear();

    @Override
    public final DateTimeField year() {
        return this.year;
    }

    @Override
    public final DateTimeField yearOfCentury() {
        return this.yearOfCentury;
    }

    final int getDaysInYear() {
        return this.daysInYear;
    }

    @Override
    public final DateTimeZone getZone() {
        return DateTimeZone.UTC;
    }

    @Override
    public final Chronology withZone(DateTimeZone zone) {
        if (zone.equals(DateTimeZone.UTC)) {
            return this.withUTC();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final Chronology withUTC() {
        return this;
    }

    private static final class YearField
    extends PreciseDurationDateTimeField {
        public YearField(DurationField yearDuration) {
            super(DateTimeFieldType.year(), yearDuration);
        }

        @Override
        public int get(long instant) {
            return (int)Math.floor((double)instant * 1.0 / (double)this.getDurationField().getUnitMillis()) + 1970;
        }

        @Override
        public DurationField getRangeDurationField() {
            return null;
        }

        @Override
        public int getMinimumValue() {
            return this.get(Long.MIN_VALUE);
        }

        @Override
        public int getMaximumValue() {
            return this.get(Long.MAX_VALUE) - 1;
        }
    }
}

