/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import loci.common.CaseInsensitiveLocation;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseZeissReader;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.ZeissTIFFHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import org.xml.sax.helpers.DefaultHandler;

public class ZeissTIFFReader
extends BaseZeissReader {
    public static final String[] TIFF_SUFFIXES = new String[]{"tif", "xml"};
    public static final String XML_NAME = "_meta.xml";
    TIFFInfo tiffInfo;
    ArrayList<Plane> planes;
    private MinimalTiffReader tiffReader;
    HashMap<Integer, Channel> channels = new HashMap();
    HashMap<Integer, Slice> slices = new HashMap();
    HashMap<Integer, Timepoint> timepoints = new HashMap();

    public ZeissTIFFReader() {
        super("Zeiss AxioVision TIFF", TIFF_SUFFIXES);
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    protected String getPrefix(String name) {
        String ret = name;
        if (name.endsWith(".tif") || name.endsWith(".zvi")) {
            ret = name.substring(0, name.length() - 4);
        }
        return ret;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!ZeissTIFFReader.checkSuffix(name, TIFF_SUFFIXES)) {
            return false;
        }
        try {
            CaseInsensitiveLocation.invalidateCache();
            TIFFInfo tIFFInfo = this.evalFile(name);
        }
        catch (Exception e) {
            return false;
        }
        return open;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (new CaseInsensitiveLocation(this.imageFiles[no]).exists()) {
            Plane p = this.planes.get(no);
            this.tiffReader.setId(p.filename);
            this.tiffReader.openBytes(0, buf, x, y, w, h);
            this.tiffReader.close();
        } else {
            LOGGER.warn("File for image #{} ({}) is missing.", (Object)no, (Object)this.imageFiles[no]);
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        try {
            CaseInsensitiveLocation xml = new CaseInsensitiveLocation(this.tiffInfo.xmlname);
            if (xml.exists()) {
                files.add(xml.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error checking existence of " + this.tiffInfo.xmlname, e);
        }
        try {
            CaseInsensitiveLocation origname = new CaseInsensitiveLocation(this.tiffInfo.origname);
            if (!noPixels && this.tiffInfo.origname != null && origname.exists()) {
                files.add(origname.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error checking existence of " + this.tiffInfo.origname, e);
        }
        if (!noPixels) {
            for (String tiff : this.imageFiles) {
                try {
                    CaseInsensitiveLocation tiffLocation = new CaseInsensitiveLocation(tiff);
                    if (!tiffLocation.exists()) continue;
                    files.add(tiffLocation.getAbsolutePath());
                }
                catch (IOException e) {
                    LOGGER.debug("Error checking existence of " + tiff, e);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.tiffInfo = null;
            this.tiffReader = null;
            this.planes = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TIFFInfo evalFile(String id) throws FormatException, IOException {
        CaseInsensitiveLocation lb;
        CaseInsensitiveLocation lxml;
        TIFFInfo info = new TIFFInfo();
        CaseInsensitiveLocation l = new CaseInsensitiveLocation(id);
        String name = l.getAbsolutePath();
        if (name.endsWith(".tif")) {
            info.xmlname = name + XML_NAME;
            lxml = new CaseInsensitiveLocation(info.xmlname);
            if (lxml.exists()) {
                info.origname = name;
                info.basedir = null;
                info.multifile = false;
            } else {
                lb = new CaseInsensitiveLocation(name + "_files");
                lxml = new CaseInsensitiveLocation(lb, XML_NAME);
                if (lb.exists() && lxml.exists()) {
                    info.xmlname = lxml.getAbsolutePath();
                    info.origname = name;
                    info.basedir = lb.getAbsolutePath();
                    info.multifile = true;
                } else {
                    lb = new CaseInsensitiveLocation(l.getParent());
                    lxml = new CaseInsensitiveLocation(lb, XML_NAME);
                    if (!lb.exists() || !lxml.exists()) throw new FormatException("XML metadata not found");
                    info.origname = info.xmlname = lxml.getAbsolutePath();
                    info.basedir = lb.getAbsolutePath();
                    info.multifile = true;
                }
            }
        } else {
            if (!name.endsWith(XML_NAME)) throw new FormatException("Invalid AxioVision TIFF XML");
            info.xmlname = name;
            lxml = new CaseInsensitiveLocation(info.xmlname);
            if (!lxml.exists()) {
                throw new FormatException("XML metadata not found");
            }
            if (lxml.getName().equals(XML_NAME)) {
                lb = new CaseInsensitiveLocation(lxml.getParent());
                info.origname = info.xmlname = lxml.getAbsolutePath();
                info.basedir = lb.getAbsolutePath();
                info.multifile = true;
            } else {
                info.xmlname = lxml.getAbsolutePath();
                info.origname = info.xmlname.substring(0, info.xmlname.length() - XML_NAME.length());
                info.basedir = null;
                info.multifile = false;
                l = new CaseInsensitiveLocation(info.origname);
                if (!l.exists()) {
                    throw new FormatException("TIFF image data not found");
                }
                info.origname = l.getAbsolutePath();
            }
        }
        String xml = DataTools.readFile(info.xmlname);
        info.handler = new ZeissTIFFHandler(this);
        XMLTools.parseXML(xml, (DefaultHandler)info.handler);
        boolean found = false;
        for (BaseZeissReader.Tag t : info.handler.main_tagset.tags) {
            if (!t.getKey().equals("Filename")) continue;
            CaseInsensitiveLocation n = new CaseInsensitiveLocation(info.basedir, t.getValue());
            info.origname = n.getName();
            found = true;
            break;
        }
        if (!found && info.origname.endsWith(XML_NAME)) {
            throw new FormatException("Image name not found in XML metadata");
        }
        info.prefix = this.getPrefix(info.origname);
        if (info.basedir != null) {
            CaseInsensitiveLocation b = new CaseInsensitiveLocation(info.basedir);
            info.basedir = b.getAbsolutePath();
            l = b;
        }
        l = new CaseInsensitiveLocation(l.getParent(), info.prefix + ".tif");
        info.origname = l.getAbsolutePath();
        return info;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        CaseInsensitiveLocation.invalidateCache();
        TIFFInfo info = this.evalFile(id);
        if (new CaseInsensitiveLocation(info.origname).getAbsoluteFile().exists()) {
            super.initFile(info.origname);
        } else {
            super.initFile(id);
        }
        this.tiffInfo = info;
        super.initFileMain(info.origname);
    }

    @Override
    protected void initVars(String id) throws FormatException, IOException {
        super.initVars(id);
        this.tiffReader = new MinimalTiffReader();
        this.planes = new ArrayList();
    }

    @Override
    protected void fillMetadataPass1(MetadataStore store) throws FormatException, IOException {
        int timepointid;
        int sliceid;
        int channelid;
        super.fillMetadataPass1(store);
        int nplanes = this.tiffInfo.handler.planes.size();
        if (this.rawCount == 0) {
            this.rawCount = nplanes;
        } else if (this.rawCount != nplanes) {
            LOGGER.warn("Problem determining correct number of image planes.  Document reported {}, while {} were found", (Object)this.rawCount, (Object)nplanes);
        }
        if (this.rawCount == 0) {
            LOGGER.warn("No image planes found");
        }
        for (ZeissTIFFHandler.Plane p : this.tiffInfo.handler.planes) {
            Plane np = new Plane();
            boolean tag_1047_present = false;
            for (BaseZeissReader.Tag t : p.tagset.tags) {
                if (t.getKeyID() != 1047) continue;
                tag_1047_present = true;
            }
            for (BaseZeissReader.Tag t : p.tagset.tags) {
                if (t.getKeyID() == 1025 && tag_1047_present) continue;
                np.tags.put(t.getKey(), t.getValue());
            }
            np.taglist = p.tagset.tags;
            np.filename = nplanes == 1 && !this.tiffInfo.multifile ? this.tiffInfo.origname : new CaseInsensitiveLocation(this.tiffInfo.basedir + "/" + this.tiffInfo.prefix + "_" + p.basename + ".tif").getAbsolutePath();
            int tileid = ZeissTIFFReader.parseInt(np.tags.get("ImageTile Index"));
            channelid = ZeissTIFFReader.parseInt(np.tags.get("Image Channel Index"));
            sliceid = ZeissTIFFReader.parseInt(np.tags.get("Image Index Z"));
            timepointid = ZeissTIFFReader.parseInt(np.tags.get("Image Index T"));
            int xsize = ZeissTIFFReader.parseInt(np.tags.get("Camera Frame Width"));
            int ysize = ZeissTIFFReader.parseInt(np.tags.get("Camera Frame Height"));
            np.site = tileid;
            this.tileIndices.add(tileid);
            this.channelIndices.add(channelid);
            this.zIndices.add(sliceid);
            this.timepointIndices.add(timepointid);
            if (this.getSizeX() == 0) {
                ((CoreMetadata)this.core.get((int)0)).sizeX = xsize;
                ((CoreMetadata)this.core.get((int)0)).sizeY = ysize;
            }
            this.planes.add(np);
            if (this.bpp != 0) continue;
            this.tiffReader.setId(np.filename);
            IFDList ifds = this.tiffReader.getIFDs();
            this.tiffReader.close();
            IFD firstIFD = (IFD)ifds.get(0);
            int bits = firstIFD.getBitsPerSample()[0];
            int samples = firstIFD.getSamplesPerPixel();
            this.bpp = bits / 8 * samples;
        }
        int full = (Integer)Collections.max(this.tileIndices);
        int[] indexCount = new int[full + 1];
        int max = 0;
        for (Plane plane : this.planes) {
            int n = plane.site;
            indexCount[n] = indexCount[n] + 1;
            if (indexCount[plane.site] <= max) continue;
            max = indexCount[plane.site];
        }
        for (int i = 0; i < full + 1; ++i) {
            if (indexCount[i] == max) continue;
            this.tileIndices.remove(i);
        }
        Iterator<Plane> i = this.planes.iterator();
        while (i.hasNext()) {
            Plane plane = i.next();
            if (this.tileIndices.contains(plane.site)) continue;
            i.remove();
        }
        this.countImages();
        for (int i2 = 0; i2 < this.planes.size(); ++i2) {
            Plane plane = this.planes.get(i2);
            channelid = ZeissTIFFReader.parseInt(plane.tags.get("Image Channel Index"));
            sliceid = ZeissTIFFReader.parseInt(plane.tags.get("Image Index Z"));
            timepointid = ZeissTIFFReader.parseInt(plane.tags.get("Image Index T"));
            this.coordinates[i2][0] = sliceid;
            this.coordinates[i2][1] = channelid;
            this.coordinates[i2][2] = timepointid;
            this.imageFiles[i2] = plane.filename;
        }
        int total = this.tileIndices.size() * this.channelIndices.size() * this.zIndices.size() * this.timepointIndices.size();
        if (total != this.planes.size()) {
            LOGGER.warn("Number of image planes not detected correctly: total={} planes.size={}", (Object)total, (Object)this.planes.size());
        }
    }

    @Override
    protected void fillMetadataPass2(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass2(store);
        ((CoreMetadata)this.core.get((int)0)).interleaved = false;
    }

    @Override
    protected void fillMetadataPass5(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass5(store);
        for (int i = 0; i < this.planes.size(); ++i) {
            Plane plane = this.planes.get(i);
            this.parseMainTags(i, store, plane.taglist);
        }
    }

    @Override
    protected void countImages() {
        ((CoreMetadata)this.core.get((int)0)).imageCount = this.planes.size();
        super.countImages();
    }

    Channel getChannel(int id) {
        Channel c = this.channels.get(id);
        if (c == null) {
            c = new Channel(id);
            this.channels.put(id, c);
        }
        return c;
    }

    Slice getslice(int id) {
        Slice s = this.slices.get(id);
        if (s == null) {
            s = new Slice(id);
            this.slices.put(id, s);
        }
        return s;
    }

    Timepoint getTimepoint(int id) {
        Timepoint t = this.timepoints.get(id);
        if (t == null) {
            t = new Timepoint(id);
            this.timepoints.put(id, t);
        }
        return t;
    }

    class TIFFInfo {
        public boolean multifile = false;
        public String origname = null;
        public String xmlname = null;
        public String basedir = null;
        public String prefix = null;
        ZeissTIFFHandler handler = null;

        TIFFInfo() {
        }
    }

    class Plane {
        public String filename;
        public HashMap<String, String> tags = new HashMap();
        public ArrayList<BaseZeissReader.Tag> taglist;
        public int site;
        RandomAccessInputStream in;

        Plane() {
        }

        public String toString() {
            String s = new String("---Plane---\n");
            s = s + "  file=" + this.filename + "\n keys=\n";
            for (String k : this.tags.keySet()) {
                s = s + "    " + k + "=" + this.tags.get(k) + "\n";
            }
            return s;
        }
    }

    class Timepoint {
        int id;

        Timepoint(int id) {
            this.id = id;
        }
    }

    class Slice {
        public int id;

        Slice(int id) {
            this.id = id;
        }
    }

    class Channel {
        int id;

        Channel(int id) {
            this.id = id;
        }
    }
}

