/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ArrayFactory;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.random.DoubleGenerator;

public class DoubleShapedVector
extends ShapedVector {
    protected double[] data;

    public DoubleShapedVector(DoubleShapedVectorSpace doubleShapedVectorSpace) {
        super(doubleShapedVectorSpace);
        this.data = new double[doubleShapedVectorSpace.getNumber()];
    }

    public DoubleShapedVector(DoubleShapedVectorSpace doubleShapedVectorSpace, double[] dArray) {
        super(doubleShapedVectorSpace);
        if (dArray == null || dArray.length != doubleShapedVectorSpace.getNumber()) {
            throw new IllegalArgumentException("Array size not compatible with vector space.");
        }
        this.data = dArray;
    }

    @Override
    public DoubleShapedVectorSpace getOwner() {
        return (DoubleShapedVectorSpace)this.space;
    }

    @Override
    public DoubleShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final double get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, double d) {
        this.data[n] = d;
    }

    public void set(double[] dArray) {
        ArrayOps.copy(this.data, dArray);
    }

    public double[] getData() {
        return this.data;
    }

    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public DoubleShapedVector create() {
        return this.getOwner().create();
    }

    @Override
    public DoubleShapedVector clone() {
        return this.getOwner()._clone(this);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        ((ShapedVectorSpace)this.space).checkShape(shapedArray);
        double[] dArray = shapedArray.toDouble().flatten();
        if (dArray != this.data) {
            System.arraycopy(dArray, 0, this.data, 0, this.getNumber());
        }
    }

    @Override
    public DoubleArray asShapedArray() {
        return ArrayFactory.wrap(this.data, this.getShape());
    }
}

