/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinData;
import ome.xml.model.External;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryFile
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryFile.class);
    private String mimeType;
    private NonNegativeLong size;
    private String fileName;
    private External external;
    private BinData binData;

    public BinaryFile() {
    }

    public BinaryFile(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public BinaryFile(BinaryFile orig) {
        this.mimeType = orig.mimeType;
        this.size = orig.size;
        this.fileName = orig.fileName;
        this.external = orig.external;
        this.binData = orig.binData;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> BinData_nodeList;
        List<Element> External_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("MIMEType")) {
            this.setMIMEType(String.valueOf(element.getAttribute("MIMEType")));
        }
        if (element.hasAttribute("Size")) {
            this.setSize(NonNegativeLong.valueOf(element.getAttribute("Size")));
        }
        if (element.hasAttribute("FileName")) {
            this.setFileName(String.valueOf(element.getAttribute("FileName")));
        }
        if ((External_nodeList = BinaryFile.getChildrenByTagName(element, "External")).size() > 1) {
            throw new RuntimeException(String.format("External node list size %d != 1", External_nodeList.size()));
        }
        if (External_nodeList.size() != 0) {
            this.setExternal(new External(External_nodeList.get(0), model));
        }
        if ((BinData_nodeList = BinaryFile.getChildrenByTagName(element, "BinData")).size() > 1) {
            throw new RuntimeException(String.format("BinData node list size %d != 1", BinData_nodeList.size()));
        }
        if (BinData_nodeList.size() != 0) {
            this.setBinData(new BinData(BinData_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
    }

    public NonNegativeLong getSize() {
        return this.size;
    }

    public void setSize(NonNegativeLong size) {
        this.size = size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public External getExternal() {
        return this.external;
    }

    public void setExternal(External external) {
        this.external = external;
    }

    public BinData getBinData() {
        return this.binData;
    }

    public void setBinData(BinData binData) {
        this.binData = binData;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element BinaryFile_element) {
        Element child;
        if (BinaryFile_element == null) {
            BinaryFile_element = document.createElementNS(NAMESPACE, "BinaryFile");
        }
        super.asXMLElement(document, BinaryFile_element);
        if (this.mimeType != null) {
            BinaryFile_element.setAttribute("MIMEType", this.mimeType.toString());
        }
        if (this.size != null) {
            BinaryFile_element.setAttribute("Size", this.size.toString());
        }
        if (this.fileName != null) {
            BinaryFile_element.setAttribute("FileName", this.fileName.toString());
        }
        if (this.external != null) {
            child = document.createElementNS(NAMESPACE, "External");
            this.external.asXMLElement(document, child);
            BinaryFile_element.appendChild(child);
        }
        if (this.binData != null) {
            child = document.createElementNS(NAMESPACE, "BinData");
            this.binData.asXMLElement(document, child);
            BinaryFile_element.appendChild(child);
        }
        return BinaryFile_element;
    }
}

