/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import java.io.PrintStream;
import mitiv.exception.NonConformableArrayException;

public class ArrayOps {
    protected ArrayOps() {
    }

    public static void main(String[] stringArray) {
        int n = 200;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 3.0 * (double)i - 10.0;
            dArray2[i] = 50.0 - 7.0 * (double)i;
            dArray3[i] = 4.0 * (double)i - 110.0;
        }
        try {
            System.out.println("dot(a,b) = " + ArrayOps.dot(dArray, dArray2));
            System.out.println("dot(a,b,c) = " + ArrayOps.dot(dArray, dArray2, dArray3));
        }
        catch (Exception exception) {
            System.err.println("error: " + exception);
        }
    }

    public static final int getLength(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static final int getLength(short[] sArray) {
        return sArray == null ? 0 : sArray.length;
    }

    public static final int getLength(int[] nArray) {
        return nArray == null ? 0 : nArray.length;
    }

    public static final int getLength(long[] lArray) {
        return lArray == null ? 0 : lArray.length;
    }

    public static final int getLength(float[] fArray) {
        return fArray == null ? 0 : fArray.length;
    }

    public static final int getLength(double[] dArray) {
        return dArray == null ? 0 : dArray.length;
    }

    public static final int getNonZeroLength(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = fArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getNonZeroLength(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = dArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[] fArray, float[] fArray2) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] dArray, double[] dArray2) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] fArray, float[] fArray2, float[] fArray3) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n || ArrayOps.getLength(fArray3) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n || ArrayOps.getLength(dArray3) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n || ArrayOps.getLength(dArray3) != n || ArrayOps.getLength(dArray4) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n || ArrayOps.getLength(fArray3) != n || ArrayOps.getLength(fArray4) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = fArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = dArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] dArray, double[][] dArray2) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n || ArrayOps.getLength(dArray3) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] fArray, float[][] fArray2) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] fArray, float[][] fArray2, float[][] fArray3) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n || ArrayOps.getLength(fArray3) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = dArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[][][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = fArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][][] dArray, double[][][] dArray2) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] fArray, float[][][] fArray2) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(double[][][] dArray, double[][][] dArray2, double[][][] dArray3) {
        int n = ArrayOps.getLength(dArray);
        if (ArrayOps.getLength(dArray2) != n || ArrayOps.getLength(dArray3) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] fArray, float[][][] fArray2, float[][][] fArray3) {
        int n = ArrayOps.getLength(fArray);
        if (ArrayOps.getLength(fArray2) != n || ArrayOps.getLength(fArray3) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final float getMin(float[] fArray) {
        int n = ArrayOps.getNonZeroLength(fArray);
        float f = fArray[0];
        for (int i = 1; i < n; ++i) {
            float f2 = fArray[i];
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public static final float getMax(float[] fArray) {
        int n = ArrayOps.getNonZeroLength(fArray);
        float f = fArray[0];
        for (int i = 1; i < n; ++i) {
            float f2 = fArray[i];
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static final float[] getMinMax(float[] fArray) {
        return ArrayOps.getMinMax(fArray, new float[2]);
    }

    public static final float[] getMinMax(float[] fArray, float[] fArray2) {
        if (fArray2 == null || fArray2.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(fArray);
        float f = fArray[0];
        float f2 = fArray[0];
        for (int i = 1; i < n; ++i) {
            float f3 = fArray[i];
            if (f3 < f) {
                f = f3;
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        fArray2[0] = f;
        fArray2[1] = f2;
        return fArray2;
    }

    public static final double getMin(double[] dArray) {
        int n = ArrayOps.getNonZeroLength(dArray);
        double d = dArray[0];
        for (int i = 1; i < n; ++i) {
            double d2 = dArray[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static final double getMax(double[] dArray) {
        int n = ArrayOps.getNonZeroLength(dArray);
        double d = dArray[0];
        for (int i = 1; i < n; ++i) {
            double d2 = dArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static final double[] getMinMax(double[] dArray) {
        return ArrayOps.getMinMax(dArray, new double[2]);
    }

    public static final double[] getMinMax(double[] dArray, double[] dArray2) {
        if (dArray2 == null || dArray2.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(dArray);
        double d = dArray[0];
        double d2 = dArray[0];
        for (int i = 1; i < n; ++i) {
            double d3 = dArray[i];
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        return dArray2;
    }

    public static final float sum(float[] fArray) {
        float f = 0.0f;
        int n = ArrayOps.getLength(fArray);
        for (int i = 1; i < n; ++i) {
            f += fArray[i];
        }
        return f;
    }

    public static final float sum(float[][] fArray) {
        float f = 0.0f;
        int n = ArrayOps.getLength(fArray);
        for (int i = 1; i < n; ++i) {
            f += ArrayOps.sum(fArray[i]);
        }
        return f;
    }

    public static final float sum(float[][][] fArray) {
        float f = 0.0f;
        int n = ArrayOps.getLength(fArray);
        for (int i = 1; i < n; ++i) {
            f += ArrayOps.sum(fArray[i]);
        }
        return f;
    }

    public static final double sum(double[] dArray) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray);
        for (int i = 1; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static final double sum(double[][] dArray) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray);
        for (int i = 1; i < n; ++i) {
            d += ArrayOps.sum(dArray[i]);
        }
        return d;
    }

    public static final double sum(double[][][] dArray) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray);
        for (int i = 1; i < n; ++i) {
            d += ArrayOps.sum(dArray[i]);
        }
        return d;
    }

    public static final double dot(int n, double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static final double dot(int n, float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray2[i];
        }
        return f;
    }

    public static final double dot(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i] * dArray3[i];
        }
        return d;
    }

    public static final double dot(int n, float[] fArray, float[] fArray2, float[] fArray3) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray2[i] * fArray3[i];
        }
        return f;
    }

    public static final double dot(double[] dArray, double[] dArray2) {
        return ArrayOps.dot(ArrayOps.getLength(dArray, dArray2), dArray, dArray2);
    }

    public static final double dot(float[] fArray, float[] fArray2) {
        return ArrayOps.dot(ArrayOps.getLength(fArray, fArray2), fArray, fArray2);
    }

    public static final double dot(double[] dArray, double[] dArray2, double[] dArray3) {
        return ArrayOps.dot(ArrayOps.getLength(dArray, dArray2, dArray3), dArray, dArray2, dArray3);
    }

    public static final double dot(float[] fArray, float[] fArray2, float[] fArray3) {
        return ArrayOps.dot(ArrayOps.getLength(fArray, fArray2, fArray3), fArray, fArray2, fArray3);
    }

    public static final double dot(double[][] dArray, double[][] dArray2) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray, dArray2);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(dArray[i], dArray2[i]);
        }
        return d;
    }

    public static final double dot(float[][] fArray, float[][] fArray2) {
        double d = 0.0;
        int n = ArrayOps.getLength(fArray, fArray2);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(fArray[i], fArray2[i]);
        }
        return d;
    }

    public static final double dot(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray, dArray2, dArray3);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(dArray[i], dArray2[i], dArray3[i]);
        }
        return d;
    }

    public static final double dot(float[][] fArray, float[][] fArray2, float[][] fArray3) {
        double d = 0.0;
        int n = ArrayOps.getLength(fArray, fArray2, fArray3);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(fArray[i], fArray2[i], fArray3[i]);
        }
        return d;
    }

    public static final double dot(double[][][] dArray, double[][][] dArray2) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray, dArray2);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(dArray[i], dArray2[i]);
        }
        return d;
    }

    public static final double dot(float[][][] fArray, float[][][] fArray2) {
        double d = 0.0;
        int n = ArrayOps.getLength(fArray, fArray2);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(fArray[i], fArray2[i]);
        }
        return d;
    }

    public static final double dot(double[][][] dArray, double[][][] dArray2, double[][][] dArray3) {
        double d = 0.0;
        int n = ArrayOps.getLength(dArray, dArray2, dArray3);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(dArray[i], dArray2[i], dArray3[i]);
        }
        return d;
    }

    public static final double dot(float[][][] fArray, float[][][] fArray2, float[][][] fArray3) {
        double d = 0.0;
        int n = ArrayOps.getLength(fArray, fArray2, fArray3);
        for (int i = 0; i < n; ++i) {
            d += ArrayOps.dot(fArray[i], fArray2[i], fArray3[i]);
        }
        return d;
    }

    public static double norm2(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public static double norm1(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += Math.abs(dArray[i]);
        }
        return d;
    }

    public static double normInf(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(dArray[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static float norm2(float[] fArray) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray[i];
        }
        return (float)Math.sqrt(f);
    }

    public static double norm1(float[] fArray) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f += Math.abs(fArray[i]);
        }
        return f;
    }

    public static float normInf(float[] fArray) {
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f2 = Math.abs(fArray[i]);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public static void zero(double[] dArray, int n) {
        ArrayOps.fill(dArray, n, 0.0);
    }

    public static void zero(float[] fArray, int n) {
        ArrayOps.fill(fArray, n, 0.0);
    }

    public static void zero(double[] dArray) {
        ArrayOps.zero(dArray, dArray.length);
    }

    public static void zero(float[] fArray) {
        ArrayOps.zero(fArray, fArray.length);
    }

    public static void zero(double[][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(dArray[i]);
        }
    }

    public static void zero(float[][] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(fArray[i]);
        }
    }

    public static void zero(double[][][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(dArray[i]);
        }
    }

    public static void zero(float[][][] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(fArray[i]);
        }
    }

    public static void copy(double[] dArray, int n, double[] dArray2) {
        System.arraycopy(dArray2, 0, dArray, 0, n);
    }

    public static void copy(float[] fArray, int n, float[] fArray2) {
        System.arraycopy(fArray2, 0, fArray, 0, n);
    }

    public static void copy(double[] dArray, double[] dArray2) {
        ArrayOps.copy(dArray, ArrayOps.getLength(dArray2, dArray), dArray2);
    }

    public static void copy(float[] fArray, float[] fArray2) {
        ArrayOps.copy(fArray, ArrayOps.getLength(fArray2, fArray), fArray2);
    }

    public static void copy(double[][] dArray, double[][] dArray2) {
        int n = ArrayOps.getLength(dArray2, dArray);
        for (int i = 0; i < n; ++i) {
            ArrayOps.copy(dArray[i], dArray2[i]);
        }
    }

    public static void copy(float[][] fArray, float[][] fArray2) {
        int n = ArrayOps.getLength(fArray2, fArray);
        for (int i = 0; i < n; ++i) {
            ArrayOps.copy(fArray[i], fArray2[i]);
        }
    }

    public static void fill(double[] dArray, int n, double d) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(float[] fArray, int n, double d) {
        float f = (float)d;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f;
        }
    }

    public static void combine(int n, double d, double[] dArray, double d2, double[] dArray2) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (d2 != 1.0) break block35;
                        if (d != 1.0) break block36;
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            dArray2[n2] = dArray2[n2] + dArray[i];
                        }
                        break block37;
                    }
                    if (d != -1.0) break block38;
                    for (int i = 0; i < n; ++i) {
                        int n3 = i;
                        dArray2[n3] = dArray2[n3] - dArray[i];
                    }
                    break block37;
                }
                if (d == 0.0) break block37;
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] + d * dArray[i];
                }
                break block37;
            }
            if (d2 == 0.0) {
                if (d == 1.0) {
                    ArrayOps.copy(dArray2, n, dArray);
                } else if (d == 0.0) {
                    ArrayOps.zero(dArray2, n);
                } else if (d == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = -dArray[i];
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = d * dArray[i];
                    }
                }
            } else if (d2 == -1.0) {
                if (d == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = dArray[i] - dArray2[i];
                    }
                } else if (d == 0.0) {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = -dArray2[i];
                    }
                } else if (d == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = -dArray[i] - dArray2[i];
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dArray2[i] = d * dArray[i] - dArray2[i];
                    }
                }
            } else if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = dArray[i] + d2 * dArray2[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = d2 * dArray2[i] - dArray[i];
                }
            } else if (d == 0.0) {
                int n5 = 0;
                while (n5 < n) {
                    int n6 = n5++;
                    dArray2[n6] = dArray2[n6] * d2;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = d * dArray[i] + d2 * dArray2[i];
                }
            }
        }
    }

    public static void combine(double[] dArray, int n, double d, double[] dArray2, double d2, double[] dArray3) {
        if (d2 == 1.0) {
            if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = dArray3[i] + dArray2[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = dArray3[i] - dArray2[i];
                }
            } else if (d == 0.0) {
                for (int i = 0; i < n; ++i) {
                    ArrayOps.copy(dArray, n, dArray3);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = d * dArray2[i] + dArray3[i];
                }
            }
        } else if (d2 == -1.0) {
            if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = dArray2[i] - dArray3[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = -dArray2[i] - dArray3[i];
                }
            } else if (d == 0.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = -dArray3[i];
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = d * dArray2[i] - dArray3[i];
                }
            }
        } else if (d2 == 0.0) {
            if (d == 1.0) {
                ArrayOps.copy(dArray, n, dArray2);
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = -dArray2[i];
                }
            } else if (d == 0.0) {
                ArrayOps.zero(dArray, n);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = d * dArray2[i];
                }
            }
        } else if (d == 1.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] + d2 * dArray3[i];
            }
        } else if (d == -1.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d2 * dArray3[i] - dArray2[i];
            }
        } else if (d == 0.0) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d2 * dArray3[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d * dArray2[i] + d2 * dArray3[i];
            }
        }
    }

    public static void combine(double d, double[] dArray, double d2, double[] dArray2) {
        ArrayOps.combine(ArrayOps.getLength(dArray, dArray2), d, dArray, d2, dArray2);
    }

    public static void combine(double[] dArray, double d, double[] dArray2, double d2, double[] dArray3) {
        ArrayOps.combine(dArray, ArrayOps.getLength(dArray, dArray2, dArray3), d, dArray2, d2, dArray3);
    }

    public static void combine(int n, double d, float[] fArray, double d2, float[] fArray2) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (d2 != 1.0) break block35;
                        if (d != 1.0) break block36;
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            fArray2[n2] = fArray2[n2] + fArray[i];
                        }
                        break block37;
                    }
                    if (d != -1.0) break block38;
                    for (int i = 0; i < n; ++i) {
                        int n3 = i;
                        fArray2[n3] = fArray2[n3] - fArray[i];
                    }
                    break block37;
                }
                if (d == 0.0) break block37;
                float f = (float)d;
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    fArray2[n4] = fArray2[n4] + f * fArray[i];
                }
                break block37;
            }
            if (d2 == 0.0) {
                if (d == 1.0) {
                    ArrayOps.copy(fArray2, n, fArray);
                } else if (d == 0.0) {
                    ArrayOps.zero(fArray2, n);
                } else if (d == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = -fArray[i];
                    }
                } else {
                    float f = (float)d;
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = f * fArray[i];
                    }
                }
            } else if (d2 == -1.0) {
                if (d == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = fArray[i] - fArray2[i];
                    }
                } else if (d == 0.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = -fArray2[i];
                    }
                } else if (d == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = -fArray[i] - fArray2[i];
                    }
                } else {
                    float f = (float)d;
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = f * fArray[i] - fArray2[i];
                    }
                }
            } else {
                float f = (float)d2;
                if (d == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = fArray[i] + f * fArray2[i];
                    }
                } else if (d == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = f * fArray2[i] - fArray[i];
                    }
                } else if (d == 0.0) {
                    int n5 = 0;
                    while (n5 < n) {
                        int n6 = n5++;
                        fArray2[n6] = fArray2[n6] * f;
                    }
                } else {
                    float f2 = (float)d;
                    for (int i = 0; i < n; ++i) {
                        fArray2[i] = f2 * fArray[i] + f * fArray2[i];
                    }
                }
            }
        }
    }

    public static void combine(float[] fArray, int n, double d, float[] fArray2, double d2, float[] fArray3) {
        if (d2 == 1.0) {
            if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = fArray3[i] + fArray2[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = fArray3[i] - fArray2[i];
                }
            } else if (d == 0.0) {
                for (int i = 0; i < n; ++i) {
                    ArrayOps.copy(fArray, n, fArray3);
                }
            } else {
                float f = (float)d;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f * fArray2[i] + fArray3[i];
                }
            }
        } else if (d2 == -1.0) {
            if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = fArray2[i] - fArray3[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = -fArray2[i] - fArray3[i];
                }
            } else if (d == 0.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = -fArray3[i];
                }
            } else {
                float f = (float)d;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f * fArray2[i] - fArray3[i];
                }
            }
        } else if (d2 == 0.0) {
            if (d == 1.0) {
                ArrayOps.copy(fArray, n, fArray2);
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = -fArray2[i];
                }
            } else if (d == 0.0) {
                ArrayOps.zero(fArray, n);
            } else {
                float f = (float)d;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f * fArray2[i];
                }
            }
        } else {
            float f = (float)d2;
            if (d == 1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = fArray2[i] + f * fArray3[i];
                }
            } else if (d == -1.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f * fArray3[i] - fArray2[i];
                }
            } else if (d == 0.0) {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f * fArray3[i];
                }
            } else {
                float f2 = (float)d;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = f2 * fArray2[i] + f * fArray3[i];
                }
            }
        }
    }

    public static void combine(double d, float[] fArray, double d2, float[] fArray2) {
        ArrayOps.combine(ArrayOps.getLength(fArray, fArray2), d, fArray, d2, fArray2);
    }

    public static void combine(float[] fArray, double d, float[] fArray2, double d2, float[] fArray3) {
        ArrayOps.combine(fArray, ArrayOps.getLength(fArray, fArray2, fArray3), d, fArray2, d2, fArray3);
    }

    public static void combine(double[] dArray, int n, double d, double[] dArray2, double d2, double[] dArray3, double d3, double[] dArray4) {
        if (d == 0.0) {
            ArrayOps.combine(dArray, d2, dArray3, d3, dArray4);
        } else if (d2 == 0.0) {
            ArrayOps.combine(dArray, d, dArray2, d3, dArray4);
        } else if (d3 == 0.0) {
            ArrayOps.combine(dArray, d, dArray2, d2, dArray3);
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = d * dArray2[i] + d2 * dArray3[i] + d3 * dArray4[i];
            }
        }
    }

    public static void combine(double[] dArray, double d, double[] dArray2, double d2, double[] dArray3, double d3, double[] dArray4) {
        ArrayOps.combine(dArray, ArrayOps.getLength(dArray, dArray2, dArray3, dArray4), d, dArray2, d2, dArray3, d3, dArray4);
    }

    public static void combine(float[] fArray, int n, double d, float[] fArray2, double d2, float[] fArray3, double d3, float[] fArray4) {
        if (d == 0.0) {
            ArrayOps.combine(fArray, d2, fArray3, d3, fArray4);
        } else if (d2 == 0.0) {
            ArrayOps.combine(fArray, d, fArray2, d3, fArray4);
        } else if (d3 == 0.0) {
            ArrayOps.combine(fArray, d, fArray2, d2, fArray3);
        } else {
            float f = (float)d;
            float f2 = (float)d2;
            float f3 = (float)d3;
            for (int i = 0; i < n; ++i) {
                fArray[i] = f * fArray2[i] + f2 * fArray3[i] + f3 * fArray4[i];
            }
        }
    }

    public static void combine(float[] fArray, float f, float[] fArray2, float f2, float[] fArray3, float f3, float[] fArray4) {
        ArrayOps.combine(fArray, ArrayOps.getLength(fArray, fArray2, fArray3, fArray4), (double)f, fArray2, (double)f2, fArray3, (double)f3, fArray4);
    }

    public static double dot(Object object, Object object2) {
        return 0.0;
    }

    public static double dot(Object object, Object object2, Object object3) {
        return 0.0;
    }

    public static void printArray(Object object) {
        ArrayOps.printArray(object, System.out, true);
    }

    public static void printArray(Object object, boolean bl) {
        ArrayOps.printArray(object, System.out, bl);
    }

    public static void printArray(Object object, PrintStream printStream) {
        ArrayOps.printArray(object, printStream, true);
    }

    public static void printArray(Object object, PrintStream printStream, boolean bl) {
        if (object == null) {
            printStream.print("null");
        } else {
            String string = object.getClass().getName();
            char c = string.charAt(0);
            if (c == '[') {
                char c2 = string.charAt(1);
                if (c2 == 'B') {
                    byte[] byArray = (byte[])object;
                    for (int i = 0; i < byArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + byArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'S') {
                    short[] sArray = (short[])object;
                    for (int i = 0; i < sArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + sArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'I') {
                    int[] nArray = (int[])object;
                    for (int i = 0; i < nArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + nArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'J') {
                    long[] lArray = (long[])object;
                    for (int i = 0; i < lArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + lArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'F') {
                    float[] fArray = (float[])object;
                    for (int i = 0; i < fArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + fArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'D') {
                    double[] dArray = (double[])object;
                    for (int i = 0; i < dArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + dArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'C') {
                    char[] cArray = (char[])object;
                    for (int i = 0; i < cArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + cArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'Z') {
                    boolean[] blArray = (boolean[])object;
                    for (int i = 0; i < blArray.length; ++i) {
                        printStream.print((i == 0 ? "{" : ", ") + blArray[i]);
                    }
                    printStream.print("}");
                } else if (c2 == 'L') {
                    printStream.print(string.substring(2));
                } else if (c2 == '[') {
                    Object[] objectArray = (Object[])object;
                    printStream.print("{");
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (i > 0) {
                            printStream.print(", ");
                        }
                        ArrayOps.printArray(objectArray[i], printStream, false);
                    }
                    printStream.print("}");
                } else {
                    printStream.print("{*unknown*}");
                }
            }
        }
        if (bl) {
            printStream.println();
        }
    }
}

