/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class GenericURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static GenericURLStreamHandlerFactory factory = null;
    private final Map<String, URLStreamHandler> protocolHandlers = new HashMap<String, URLStreamHandler>();

    private GenericURLStreamHandlerFactory() {
    }

    public final synchronized URLStreamHandler setHandler(String string, URLStreamHandler uRLStreamHandler) {
        return this.protocolHandlers.put(string, uRLStreamHandler);
    }

    public final synchronized URLStreamHandler getHandler(String string) {
        return this.protocolHandlers.get(string);
    }

    @Override
    public final synchronized URLStreamHandler createURLStreamHandler(String string) {
        return this.getHandler(string);
    }

    public static synchronized GenericURLStreamHandlerFactory register() {
        if (null == factory) {
            factory = AccessController.doPrivileged(new PrivilegedAction<GenericURLStreamHandlerFactory>(){

                @Override
                public GenericURLStreamHandlerFactory run() {
                    boolean bl = false;
                    GenericURLStreamHandlerFactory genericURLStreamHandlerFactory = new GenericURLStreamHandlerFactory();
                    try {
                        URL.setURLStreamHandlerFactory(genericURLStreamHandlerFactory);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        System.err.println("GenericURLStreamHandlerFactory: Setting URLStreamHandlerFactory failed: " + throwable.getMessage());
                    }
                    return bl ? genericURLStreamHandlerFactory : null;
                }
            });
        }
        return factory;
    }
}

