/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.random.tfloat.engine.FRand;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinderFactory;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.bin.AbstractFloatBin1D;
import hep.aida.tfloat.bin.MightyStaticFloatBin1D;
import hep.aida.tfloat.ref.FloatConverter;
import java.util.Date;

public class QuantileFloatBin1D
extends MightyStaticFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected FloatQuantileFinder finder = null;

    protected QuantileFloatBin1D() {
        super(false, false, 2);
    }

    public QuantileFloatBin1D(float epsilon) {
        this(false, Long.MAX_VALUE, epsilon, 0.001f, 10000, new FRand(new Date()));
    }

    public QuantileFloatBin1D(boolean known_N, long N, float epsilon, float delta, int quantiles, FloatRandomEngine randomGenerator) {
        this(known_N, N, epsilon, delta, quantiles, randomGenerator, false, false, 2);
    }

    public QuantileFloatBin1D(boolean known_N, long N, float epsilon, float delta, int quantiles, FloatRandomEngine randomGenerator, boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        super(hasSumOfLogarithms, hasSumOfInversions, maxOrderForSumOfPowers);
        this.finder = FloatQuantileFinderFactory.newFloatQuantileFinder(known_N, N, epsilon, delta, quantiles, randomGenerator);
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(FloatArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(list, from, to);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    @Override
    public synchronized Object clone() {
        QuantileFloatBin1D clone = (QuantileFloatBin1D)super.clone();
        if (this.finder != null) {
            clone.finder = (FloatQuantileFinder)clone.finder.clone();
        }
        return clone;
    }

    @Override
    public String compareWith(AbstractFloatBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof QuantileFloatBin1D) {
            QuantileFloatBin1D q = (QuantileFloatBin1D)other;
            buf.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25f), q.quantile(0.25f)) + ", " + this.relError(this.quantile(0.5f), q.quantile(0.5f)) + ", " + this.relError(this.quantile(0.75f), q.quantile(0.75f)));
            buf.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), q.quantileInverse(q.mean())) + " %");
            buf.append("\n");
        }
        return buf.toString();
    }

    public float median() {
        return this.quantile(0.5f);
    }

    public synchronized float quantile(float phi) {
        return this.quantiles(new FloatArrayList(new float[]{phi})).get(0);
    }

    public synchronized float quantileInverse(float element) {
        return this.finder.phi(element);
    }

    public synchronized FloatArrayList quantiles(FloatArrayList phis) {
        return this.finder.quantileElements(phis);
    }

    public int sizeOfRange(float minElement, float maxElement) {
        return Math.round((float)this.size() * (this.quantileInverse(maxElement) - this.quantileInverse(minElement)));
    }

    public synchronized MightyStaticFloatBin1D[] splitApproximately(FloatArrayList percentages, int k) {
        int percentSize = percentages.size();
        if (k < 1 || percentSize < 2) {
            throw new IllegalArgumentException();
        }
        float[] percent = percentages.elements();
        int noOfBins = percentSize - 1;
        float[] subBins = new float[1 + k * (percentSize - 1)];
        subBins[0] = percent[0];
        int c = 1;
        int i = 0;
        while (i < noOfBins) {
            float step = (percent[i + 1] - percent[i]) / (float)k;
            int j = 1;
            while (j <= k) {
                subBins[c++] = percent[i] + (float)j * step;
                ++j;
            }
            ++i;
        }
        float[] quantiles = this.quantiles(new FloatArrayList(subBins)).elements();
        MightyStaticFloatBin1D[] splitBins = new MightyStaticFloatBin1D[noOfBins];
        int maxOrderForSumOfPowers = this.getMaxOrderForSumOfPowers();
        maxOrderForSumOfPowers = Math.min(10, maxOrderForSumOfPowers);
        int dataSize = this.size();
        c = 0;
        int i2 = 0;
        while (i2 < noOfBins) {
            float binMax;
            float binMin;
            float step = (percent[i2 + 1] - percent[i2]) / (float)k;
            float binSum = 0.0f;
            float binSumOfSquares = 0.0f;
            float binSumOfLogarithms = 0.0f;
            float binSumOfInversions = 0.0f;
            float[] binSumOfPowers = null;
            if (maxOrderForSumOfPowers > 2) {
                binSumOfPowers = new float[maxOrderForSumOfPowers - 2];
            }
            float safe_min = binMin = quantiles[c++];
            float subIntervalSize = (float)dataSize * step;
            int j = 1;
            while (j <= k) {
                binMax = quantiles[c++];
                float binMean = (binMin + binMax) / 2.0f;
                binSum += binMean * subIntervalSize;
                binSumOfSquares += binMean * binMean * subIntervalSize;
                if (this.hasSumOfLogarithms) {
                    binSumOfLogarithms = (float)((double)binSumOfLogarithms + Math.log(binMean) * (double)subIntervalSize);
                }
                if (this.hasSumOfInversions) {
                    binSumOfInversions += 1.0f / binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 3) {
                    binSumOfPowers[0] = binSumOfPowers[0] + binMean * binMean * binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 4) {
                    binSumOfPowers[1] = binSumOfPowers[1] + binMean * binMean * binMean * binMean * subIntervalSize;
                }
                int p = 5;
                while (p <= maxOrderForSumOfPowers) {
                    int n = p - 3;
                    binSumOfPowers[n] = (float)((double)binSumOfPowers[n] + Math.pow(binMean, p) * (double)subIntervalSize);
                    ++p;
                }
                binMin = binMax;
                ++j;
            }
            --c;
            int binSize = Math.round((percent[i2 + 1] - percent[i2]) * (float)dataSize);
            binMax = binMin;
            binMin = safe_min;
            splitBins[i2] = new MightyStaticFloatBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, maxOrderForSumOfPowers);
            if (binSize > 0) {
                splitBins[i2].size = binSize;
                splitBins[i2].min = binMin;
                splitBins[i2].max = binMax;
                splitBins[i2].sum = binSum;
                splitBins[i2].sum_xx = binSumOfSquares;
                splitBins[i2].sumOfLogarithms = binSumOfLogarithms;
                splitBins[i2].sumOfInversions = binSumOfInversions;
                splitBins[i2].sumOfPowers = binSumOfPowers;
            }
            ++i2;
        }
        return splitBins;
    }

    public synchronized MightyStaticFloatBin1D[] splitApproximately(FloatIAxis axis, int k) {
        FloatArrayList percentages = new FloatArrayList(new FloatConverter().edges(axis));
        percentages.beforeInsert(0, Float.NEGATIVE_INFINITY);
        percentages.add(Float.POSITIVE_INFINITY);
        int i = percentages.size();
        while (--i >= 0) {
            percentages.set(i, this.quantileInverse(percentages.get(i)));
        }
        return this.splitApproximately(percentages, k);
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25f) + ", " + this.quantile(0.5f) + ", " + this.quantile(0.75f));
        buf.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        buf.append("\n");
        return buf.toString();
    }
}

