/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.algo;

import cern.colt.Partitioning;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;

public class ObjectPartitioning {
    protected ObjectPartitioning() {
    }

    public static void partition(ObjectMatrix2D matrix, int[] rowIndexes, int rowFrom, int rowTo, int column, final Object[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        if (rowFrom < 0 || rowTo >= matrix.rows() || rowTo >= rowIndexes.length) {
            throw new IllegalArgumentException();
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IllegalArgumentException();
        }
        if (splitFrom < 0 || splitTo >= splitters.length) {
            throw new IllegalArgumentException();
        }
        if (splitIndexes.length < splitters.length) {
            throw new IllegalArgumentException();
        }
        final int[] g = rowIndexes;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int b, int c) {
                int tmp = g[b];
                g[b] = g[c];
                g[c] = tmp;
            }
        };
        final ObjectMatrix1D columnView = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                Comparable av = (Comparable)splitters[a];
                Comparable bv = (Comparable)columnView.getQuick(g[b]);
                int r = av.compareTo(bv);
                return r < 0 ? -1 : (r == 0 ? 0 : 1);
            }
        };
        IntComparator comp2 = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                Comparable bv;
                Comparable av = (Comparable)columnView.getQuick(g[a]);
                int r = av.compareTo(bv = (Comparable)columnView.getQuick(g[b]));
                return r < 0 ? -1 : (r == 0 ? 0 : 1);
            }
        };
        IntComparator comp3 = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                Comparable av = (Comparable)splitters[a];
                Comparable bv = (Comparable)splitters[b];
                int r = av.compareTo(bv);
                return r < 0 ? -1 : (r == 0 ? 0 : 1);
            }
        };
        Partitioning.genericPartition(rowFrom, rowTo, splitFrom, splitTo, splitIndexes, comp, comp2, comp3, swapper);
    }

    public static ObjectMatrix2D partition(ObjectMatrix2D matrix, int column, Object[] splitters, int[] splitIndexes) {
        int rowFrom = 0;
        int rowTo = matrix.rows() - 1;
        int splitFrom = 0;
        int splitTo = splitters.length - 1;
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        ObjectPartitioning.partition(matrix, rowIndexes, rowFrom, rowTo, column, splitters, splitFrom, splitTo, splitIndexes);
        int[] columnIndexes = new int[matrix.columns()];
        int i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnIndexes[i2] = i2;
        }
        return matrix.viewSelection(rowIndexes, columnIndexes);
    }

    private static void xPartitionOld(ObjectMatrix2D matrix, ObjectMatrix1D column, int from, int to, Object[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
    }

    private static int xPartitionOld(ObjectMatrix2D matrix, ObjectMatrix1D column, int from, int to, Object splitter) {
        return 0;
    }
}

