package plugins.tprovoost.sequenceblocks.importer;

import java.io.File;

import icy.file.Loader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Block to open a file with a given SequenceFileImporter.
 * 
 * @author Stephane
 */
public class SequenceFileImporterOpen extends Plugin implements IOBlock, PluginLibrary, PluginBundled
{
    final protected Var<PositionedSequenceFileImporter> importer;
    final protected VarMutable file;
    final protected VarInteger flag;
    final protected VarBoolean ok;

    public SequenceFileImporterOpen()
    {
        super();

        importer = new Var<PositionedSequenceFileImporter>("Importer", PositionedSequenceFileImporter.class);
        file = new VarMutable("File", null)
        {
            @SuppressWarnings("rawtypes")
            @Override
            public boolean isAssignableFrom(Var source)
            {
                return (String.class == source.getType()) || (File.class == source.getType());
            }
        };
        flag = new VarInteger("Flag", 0);
        ok = new VarBoolean("ok", Boolean.FALSE);
    }

    @Override
    public void run()
    {
        final String path;
        final Object obj = file.getValue();

        if (obj != null)
        {
            if (obj instanceof String)
                path = (String) obj;
            else
                path = ((File) obj).getAbsolutePath();
        }
        else
            throw new VarException(file, "File is null !");

        PositionedSequenceFileImporter pi = importer.getValue();

        // no importer defined ?
        if (pi == null)
            // try to get it automatically
            pi = new PositionedSequenceFileImporter(Loader.getSequenceFileImporter(path, true));

        // cannot get importer ?
        if (pi.importer == null)
            throw new VarException(importer, "Cannot find an importer for file: '" + path + "' !");

        // store value back in variable
        importer.setValue(pi);

        ok.setValue(Boolean.FALSE);

        try
        {
            pi.importer.open(path, flag.getValue().intValue());
            ok.setValue(Boolean.TRUE);
        }
        catch (Exception e)
        {
            throw new VarException(importer, e.getMessage());
        }
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("importer", importer);
        inputMap.add("file", file);
        inputMap.add("flag", flag);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("ok", ok);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
