/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLEventList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MultiQueueBarrier {
    private CountDownLatch latch;
    private final Set<CLCommandQueue> queues;
    private final int count;

    public MultiQueueBarrier(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("queueCount was 0");
        }
        this.latch = new CountDownLatch(n);
        this.queues = null;
        this.count = n;
    }

    public MultiQueueBarrier(CLCommandQueue ... cLCommandQueueArray) {
        if (cLCommandQueueArray.length == 0) {
            throw new IllegalArgumentException("allowedQueues was empty");
        }
        this.latch = new CountDownLatch(cLCommandQueueArray.length);
        this.count = cLCommandQueueArray.length;
        HashSet<CLCommandQueue> hashSet = new HashSet<CLCommandQueue>(cLCommandQueueArray.length);
        for (CLCommandQueue cLCommandQueue : cLCommandQueueArray) {
            hashSet.add(cLCommandQueue);
        }
        this.queues = Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiQueueBarrier waitFor(CLCommandQueue cLCommandQueue) {
        this.checkQueue(cLCommandQueue);
        cLCommandQueue.putBarrier();
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            this.latch.countDown();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiQueueBarrier waitFor(CLCommandQueue cLCommandQueue, CLEventList cLEventList) {
        this.checkQueue(cLCommandQueue);
        cLCommandQueue.putWaitForEvents(cLEventList, true);
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            this.latch.countDown();
        }
        return this;
    }

    public MultiQueueBarrier await() throws InterruptedException {
        this.latch.await();
        this.rebuildBarrierIfBroken();
        return this;
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl = this.latch.await(l, timeUnit);
        this.rebuildBarrierIfBroken();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBarrier() {
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            while (this.latch.getCount() > 0L) {
                this.latch.countDown();
            }
            this.latch = new CountDownLatch(this.count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildBarrierIfBroken() {
        MultiQueueBarrier multiQueueBarrier = this;
        synchronized (multiQueueBarrier) {
            if (this.latch.getCount() == 0L) {
                this.latch = new CountDownLatch(this.count);
            }
        }
    }

    public long getCount() {
        return this.latch.getCount();
    }

    private void checkQueue(CLCommandQueue cLCommandQueue) throws IllegalArgumentException {
        if (this.queues != null && !this.queues.contains(cLCommandQueue)) {
            throw new IllegalArgumentException(cLCommandQueue + " is not in the allowedQueues Set: " + this.queues);
        }
    }
}

