/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;

public class MereoObject3D {
    public static final String DC = "DC";
    public static final String EC = "EC";
    public static final String PO = "PO";
    public static final String EQ = "EQ";
    public static final String TPP = "TPP";
    public static final String NTPP = "NTPP";
    public static final String TPPi = "TPPi";
    public static final String NTPPi = "NTPPi";
    public static final String EMPTY = "EMPTY";
    public static final String UNKNOWN = "UNKNOWN";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SMALL = 0.001;
    public double distBB = Double.NaN;
    private Object3D A;
    private Object3D Adilated = null;
    private Object3D B;
    private Object3D Bdilated = null;
    private Object3DVoxels inter = null;
    private float RadX;
    private float RadY;
    private float RadZ;
    private boolean disjoint = true;
    private boolean canonicRadii = false;

    public MereoObject3D(Object3D A, Object3D B) {
        this.A = A;
        this.B = B;
        this.RadX = 1.0f;
        this.RadY = 1.0f;
        this.RadZ = 1.0f;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D A, Object3D B, float radX, float radY, float radZ) {
        this.A = A;
        this.B = B;
        this.RadX = radX;
        this.RadY = radY;
        this.RadZ = radZ;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D A, Object3D B, float radXY, float radZ) {
        this.A = A;
        this.B = B;
        this.RadX = radXY;
        this.RadY = radXY;
        this.RadZ = radZ;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public MereoObject3D(Object3D A, Object3D B, float rad) {
        this.A = A;
        this.B = B;
        this.RadX = rad;
        this.RadY = rad;
        this.RadZ = rad;
        this.checkCanonicRadii();
        this.buildInterObject(false);
    }

    public Object3D getA() {
        return this.A;
    }

    public void setA(Object3D A) {
        this.A = A;
        this.Adilated = null;
        this.buildInterObject(false);
    }

    public Object3D getB() {
        return this.B;
    }

    public void setB(Object3D B) {
        this.B = B;
        this.Bdilated = null;
        this.buildInterObject(false);
    }

    public float getRadX() {
        return this.RadX;
    }

    public void setRadX(float RadX) {
        this.RadX = RadX;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    public float getRadY() {
        return this.RadY;
    }

    public void setRadY(float RadY) {
        this.RadY = RadY;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    public float getRadZ() {
        return this.RadZ;
    }

    public void setRadZ(float RadZ) {
        this.RadZ = RadZ;
        this.Adilated = null;
        this.Bdilated = null;
        this.checkCanonicRadii();
    }

    private void checkCanonicRadii() {
        if (this.RadX == 1.0f && this.RadY == 1.0f && this.RadZ == 1.0f) {
            this.canonicRadii = true;
        }
    }

    private void buildInterObject(boolean contourtest) {
        this.inter = this.A.getIntersectionObject(this.B);
        if (contourtest && this.inter != null) {
            for (Voxel3D vox : this.inter.getVoxels()) {
                boolean conta = this.A.isContour(vox);
                boolean contb = this.B.isContour(vox);
                int cc = 0;
                if (conta) {
                    cc = 1;
                }
                if (contb) {
                    cc += 2;
                }
                vox.setValue(cc);
            }
        }
        if (this.inter != null) {
            this.disjoint = this.inter.getVolumePixels() == 0;
        }
        this.distBB = !this.A.isEmpty() && !this.B.isEmpty() ? this.A.distBorderPixel(this.B) : Double.NaN;
    }

    private boolean Overlap() {
        return !this.disjoint;
    }

    private boolean Parthood() {
        if (this.disjoint) {
            return false;
        }
        boolean Anotnull = this.A.getVolumePixels() > 0;
        boolean AinB = this.B.includes(this.A);
        return Anotnull && AinB;
    }

    private boolean ParthoodInverse() {
        if (this.disjoint) {
            return false;
        }
        boolean Bnotnull = this.B.getVolumePixels() > 0;
        boolean BinA = this.A.includes(this.B);
        return Bnotnull && BinA;
    }

    public boolean Equality() {
        if (this.disjoint) {
            return false;
        }
        return this.Parthood() && this.ParthoodInverse();
    }

    public boolean ProperParthood() {
        if (this.disjoint) {
            return false;
        }
        return this.Parthood() && !this.Equality();
    }

    public boolean ProperParthoodInverse() {
        if (this.disjoint) {
            return false;
        }
        return this.ParthoodInverse() && !this.Equality();
    }

    public boolean Discrete() {
        return this.disjoint;
    }

    public boolean PartialOverlap() {
        if (this.disjoint) {
            return false;
        }
        return this.Overlap() && !this.Parthood() && !this.ParthoodInverse();
    }

    public boolean Disconnection() {
        if (this.canonicRadii) {
            return this.Disconnection1();
        }
        return this.DisconnectionRad();
    }

    public boolean ExternalConnection() {
        if (this.canonicRadii) {
            return this.ExternalConnection1();
        }
        return this.ExternalConnectionRad();
    }

    public boolean TangentialProperParthood() {
        if (this.canonicRadii) {
            return this.TangentialProperParthood1();
        }
        return this.TangentialProperParthoodRad();
    }

    public boolean NonTangentialProperParthood() {
        if (this.canonicRadii) {
            return this.NonTangentialProperParthood1();
        }
        return this.NonTangentialProperParthoodRad();
    }

    public boolean TangentialProperParthoodInverse() {
        if (this.canonicRadii) {
            return this.TangentialProperParthoodInverse1();
        }
        return this.TangentialProperParthoodInverseRad();
    }

    public boolean NonTangentialProperParthoodInverse() {
        if (this.canonicRadii) {
            return this.NonTangentialProperParthoodInverse1();
        }
        return this.NonTangentialProperParthoodInverseRad();
    }

    public String getRCC8Relationship() {
        if (this.A.isEmpty() || this.B.isEmpty()) {
            return EMPTY;
        }
        if (this.Disconnection()) {
            return DC;
        }
        if (this.ExternalConnection()) {
            return EC;
        }
        if (this.PartialOverlap()) {
            return PO;
        }
        if (this.Equality()) {
            return EQ;
        }
        if (this.TangentialProperParthood()) {
            return TPP;
        }
        if (this.NonTangentialProperParthood()) {
            return NTPP;
        }
        if (this.TangentialProperParthoodInverse()) {
            return TPPi;
        }
        if (this.NonTangentialProperParthoodInverse()) {
            return NTPPi;
        }
        return UNKNOWN;
    }

    private boolean Disconnection1() {
        return this.Discrete() && this.distBB > SQRT3;
    }

    private boolean ExternalConnection1() {
        return this.Discrete() && this.distBB <= SQRT3;
    }

    private boolean TangentialProperParthood1() {
        return this.ProperParthood() && this.distBB <= 0.001;
    }

    private boolean NonTangentialProperParthood1() {
        return this.ProperParthood() && this.distBB > 0.001;
    }

    private boolean TangentialProperParthoodInverse1() {
        return this.ProperParthoodInverse() && this.distBB <= 0.001;
    }

    private boolean NonTangentialProperParthoodInverse1() {
        return this.ProperParthoodInverse() && this.distBB > 0.001;
    }

    private Object3D getDilatedA() {
        if (this.Adilated == null) {
            this.Adilated = this.A.getDilatedObject(this.RadX, this.RadY, this.RadZ);
        }
        return this.Adilated;
    }

    private Object3D getDilatedB() {
        if (this.Bdilated == null) {
            this.Bdilated = this.B.getDilatedObject(this.RadX, this.RadY, this.RadZ);
        }
        return this.Bdilated;
    }

    private boolean DisconnectionRad() {
        if (!this.Discrete()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.getDilatedA(), this.B);
        return !mereo.Overlap();
    }

    private boolean ExternalConnectionRad() {
        if (!this.Discrete()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.getDilatedA(), this.B);
        return mereo.Overlap();
    }

    private boolean TangentialProperParthoodRad() {
        if (!this.ProperParthood()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.getDilatedA(), this.B);
        return !mereo.ProperParthood();
    }

    private boolean NonTangentialProperParthoodRad() {
        if (!this.ProperParthood()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.getDilatedA(), this.B);
        return mereo.ProperParthood();
    }

    private boolean TangentialProperParthoodInverseRad() {
        if (!this.ProperParthoodInverse()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.A, this.getDilatedB());
        return !mereo.ProperParthoodInverse();
    }

    private boolean NonTangentialProperParthoodInverseRad() {
        if (!this.ProperParthoodInverse()) {
            return false;
        }
        MereoObject3D mereo = new MereoObject3D(this.A, this.getDilatedB());
        return mereo.ProperParthoodInverse();
    }

    public Object3DVoxels getInterObject() {
        return this.inter;
    }

    public double pcColocA() {
        if (this.Discrete()) {
            return 0.0;
        }
        return 100.0 * ((double)this.inter.getVolumePixels() / (double)this.A.getVolumePixels());
    }

    public double pcColocB() {
        if (this.Discrete()) {
            return 0.0;
        }
        return 100.0 * ((double)this.inter.getVolumePixels() / (double)this.B.getVolumePixels());
    }

    public int nbVoxContourOverlap(boolean ba, boolean bb) {
        if (this.Discrete()) {
            return 0;
        }
        int c = 0;
        int val1 = 0;
        int val2 = 0;
        if (ba) {
            val1 = 1;
        }
        if (bb) {
            val1 = 2;
        }
        if (ba && bb) {
            val1 = 3;
        }
        if (ba || bb) {
            val2 = 3;
        }
        ArrayList<Voxel3D> list = this.inter.getVoxels();
        for (Voxel3D vox : list) {
            if (vox.getValue() != (double)val1 && vox.getValue() != (double)val2) continue;
            ++c;
        }
        return c;
    }
}

