/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.ByteScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte1D;
import mitiv.array.impl.StriddenByte1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte1D
extends Byte1D {
    static final int order = 1;
    final byte[] data;

    public FlatByte1D(int n) {
        super(n);
        this.data = new byte[this.number];
    }

    public FlatByte1D(int[] nArray) {
        super(nArray);
        this.data = new byte[this.number];
    }

    public FlatByte1D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
    }

    public FlatByte1D(byte[] byArray, int n) {
        super(n);
        this.checkSize(byArray);
        this.data = byArray;
    }

    public FlatByte1D(byte[] byArray, int[] nArray) {
        super(nArray);
        this.checkSize(byArray);
        this.data = byArray;
    }

    public FlatByte1D(byte[] byArray, Shape shape) {
        super(shape);
        this.checkSize(byArray);
        this.data = byArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(byte[] byArray) {
        if (byArray == null || byArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final byte get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, byte by) {
        this.data[n] = by;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = by;
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteGenerator.nextByte();
        }
    }

    @Override
    public void increment(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] + by);
        }
    }

    @Override
    public void decrement(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] - by);
        }
    }

    @Override
    public void scale(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] * by);
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        byteScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            byteScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (bl) {
            byte[] byArray = new byte[this.number];
            System.arraycopy(this.data, 0, byArray, 0, this.number);
            return byArray;
        }
        return this.data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ByteScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new ByteScalar(this.data, n);
    }

    @Override
    public ByteScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new ByteScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Byte1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenByte1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Byte1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedByte1D(this.data, nArray2);
    }

    @Override
    public Byte1D as1D() {
        return this;
    }
}

