/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class RealFFTUtils_2D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final int rows;
    private final long columnsl;
    private final long rowsl;

    public RealFFTUtils_2D(long l, long l2) {
        this.columns = (int)l2;
        this.rows = (int)l;
        this.columnsl = l2;
        this.rowsl = l;
    }

    public int getIndex(int n, int n2) {
        int n3 = n2 & 1;
        int n4 = n << 1;
        if (n != 0) {
            if (n2 <= 1) {
                if (n4 == this.rows) {
                    if (n3 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return this.rows * this.columns >> 1;
                }
                if (n4 < this.rows) {
                    return this.columns * n + n3;
                }
                if (n3 == 0) {
                    return this.columns * (this.rows - n);
                }
                return -(this.columns * (this.rows - n) + 1);
            }
            if (n2 == this.columns || n2 == this.columns + 1) {
                if (n4 == this.rows) {
                    if (n3 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return (this.rows * this.columns >> 1) + 1;
                }
                if (n4 < this.rows) {
                    if (n3 == 0) {
                        return this.columns * (this.rows - n) + 1;
                    }
                    return -(this.columns * (this.rows - n));
                }
                return this.columns * n + 1 - n3;
            }
            if (n2 < this.columns) {
                return this.columns * n + n2;
            }
            if (n3 == 0) {
                return this.columns * (this.rows + 2 - n) - n2;
            }
            return -(this.columns * (this.rows + 2 - n) - n2 + 2);
        }
        if (n2 == 1 || n2 == this.columns + 1) {
            return Integer.MIN_VALUE;
        }
        if (n2 == this.columns) {
            return 1;
        }
        if (n2 < this.columns) {
            return n2;
        }
        if (n3 == 0) {
            return (this.columns << 1) - n2;
        }
        return -((this.columns << 1) - n2 + 2);
    }

    public long getIndex(long l, long l2) {
        long l3 = l2 & 1L;
        long l4 = l << 1;
        if (l != 0L) {
            if (l2 <= 1L) {
                if (l4 == this.rowsl) {
                    if (l3 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return this.rowsl * this.columnsl >> 1;
                }
                if (l4 < this.rowsl) {
                    return this.columnsl * l + l3;
                }
                if (l3 == 0L) {
                    return this.columnsl * (this.rowsl - l);
                }
                return -(this.columnsl * (this.rowsl - l) + 1L);
            }
            if (l2 == this.columnsl || l2 == this.columnsl + 1L) {
                if (l4 == this.rowsl) {
                    if (l3 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return (this.rowsl * this.columnsl >> 1) + 1L;
                }
                if (l4 < this.rowsl) {
                    if (l3 == 0L) {
                        return this.columnsl * (this.rowsl - l) + 1L;
                    }
                    return -(this.columnsl * (this.rowsl - l));
                }
                return this.columnsl * l + 1L - l3;
            }
            if (l2 < this.columnsl) {
                return this.columnsl * l + l2;
            }
            if (l3 == 0L) {
                return this.columnsl * (this.rowsl + 2L - l) - l2;
            }
            return -(this.columnsl * (this.rowsl + 2L - l) - l2 + 2L);
        }
        if (l2 == 1L || l2 == this.columnsl + 1L) {
            return Long.MIN_VALUE;
        }
        if (l2 == this.columnsl) {
            return 1L;
        }
        if (l2 < this.columnsl) {
            return l2;
        }
        if (l3 == 0L) {
            return (this.columnsl << 1) - l2;
        }
        return -((this.columnsl << 1) - l2 + 2L);
    }

    public void pack(double d, int n, int n2, double[] dArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            dArray[n3 + n4] = d;
        } else if (n4 > Integer.MIN_VALUE) {
            dArray[n3 - n4] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(double d, long l, long l2, DoubleLargeArray doubleLargeArray, long l3) {
        long l4 = this.getIndex(l, l2);
        if (l4 >= 0L) {
            doubleLargeArray.setDouble(l3 + l4, d);
        } else if (l4 > Long.MIN_VALUE) {
            doubleLargeArray.setDouble(l3 - l4, -d);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", l, l2));
        }
    }

    public void pack(double d, int n, int n2, double[][] dArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            dArray[n3 / this.columns][n3 % this.columns] = d;
        } else if (n3 > Integer.MIN_VALUE) {
            dArray[-n3 / this.columns][-n3 % this.columns] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(float f, int n, int n2, float[] fArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            fArray[n3 + n4] = f;
        } else if (n4 > Integer.MIN_VALUE) {
            fArray[n3 - n4] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public void pack(float f, long l, long l2, FloatLargeArray floatLargeArray, long l3) {
        long l4 = this.getIndex(l, l2);
        if (l4 >= 0L) {
            floatLargeArray.setFloat(l3 + l4, f);
        } else if (l4 > Long.MIN_VALUE) {
            floatLargeArray.setFloat(l3 - l4, -f);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", l, l2));
        }
    }

    public void pack(float f, int n, int n2, float[][] fArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            fArray[n3 / this.columns][n3 % this.columns] = f;
        } else if (n3 > Integer.MIN_VALUE) {
            fArray[-n3 / this.columns][-n3 % this.columns] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n, n2));
        }
    }

    public double unpack(int n, int n2, double[] dArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            return dArray[n3 + n4];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -dArray[n3 - n4];
        }
        return 0.0;
    }

    public double unpack(long l, long l2, DoubleLargeArray doubleLargeArray, long l3) {
        long l4 = this.getIndex(l, l2);
        if (l4 >= 0L) {
            return doubleLargeArray.getDouble(l3 + l4);
        }
        if (l4 > Long.MIN_VALUE) {
            return -doubleLargeArray.getDouble(l3 - l4);
        }
        return 0.0;
    }

    public double unpack(int n, int n2, double[][] dArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            return dArray[n3 / this.columns][n3 % this.columns];
        }
        if (n3 > Integer.MIN_VALUE) {
            return -dArray[-n3 / this.columns][-n3 % this.columns];
        }
        return 0.0;
    }

    public float unpack(int n, int n2, float[] fArray, int n3) {
        int n4 = this.getIndex(n, n2);
        if (n4 >= 0) {
            return fArray[n3 + n4];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -fArray[n3 - n4];
        }
        return 0.0f;
    }

    public float unpack(long l, long l2, FloatLargeArray floatLargeArray, long l3) {
        long l4 = this.getIndex(l, l2);
        if (l4 >= 0L) {
            return floatLargeArray.getFloat(l3 + l4);
        }
        if (l4 > Long.MIN_VALUE) {
            return -floatLargeArray.getFloat(l3 - l4);
        }
        return 0.0f;
    }

    public float unpack(int n, int n2, float[][] fArray) {
        int n3 = this.getIndex(n, n2);
        if (n3 >= 0) {
            return fArray[n3 / this.columns][n3 % this.columns];
        }
        if (n3 > Integer.MIN_VALUE) {
            return -fArray[-n3 / this.columns][-n3 % this.columns];
        }
        return 0.0f;
    }
}

