/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.gj;

import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.alg.dense.linsol.gj.GaussJordan;
import org.ejml.data.DenseMatrix64F;

public class GaussJordanNoPivot
extends LinearSolverAbstract {
    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        this._setA(denseMatrix64F);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        GaussJordan.checkArgumentSquare(denseMatrix64F, "A");
        if (denseMatrix64F != this.A) {
            denseMatrix64F.set(this.A);
        }
        int n = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            double d = denseMatrix64F.get(i, i);
            if (d == 0.0) {
                throw new IllegalArgumentException("This algorithm only works if all the diagonal elements are not zero");
            }
            denseMatrix64F.set(i * n + i, 1.0);
            for (n2 = 0; n2 < n; ++n2) {
                denseMatrix64F.div(i * n + n2, d);
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (i == n2) continue;
                double d2 = denseMatrix64F.get(n2, i);
                denseMatrix64F.set(n2 * n + i, 0.0);
                for (int j = 0; j < n; ++j) {
                    denseMatrix64F.minus(n2 * n + j, d2 * denseMatrix64F.get(i * n + j));
                }
            }
        }
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        GaussJordan.checkArgumentSquare(this.A, "A");
        if (this.A.getNumCols() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Dimensions of A and B are not compatible.");
        }
        denseMatrix64F2.set(denseMatrix64F);
        int n = this.A.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            double d = this.A.get(i, i);
            if (d == 0.0) {
                throw new IllegalArgumentException("This algorithm only works if all the diagonal elements are not zero");
            }
            this.A.set(i * n + i, 1.0);
            for (n2 = 0; n2 < n; ++n2) {
                this.A.div(i * n + n2, d);
            }
            for (n2 = 0; n2 < denseMatrix64F.numCols; ++n2) {
                denseMatrix64F2.div(i * denseMatrix64F2.numCols + n2, d);
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n3;
                if (i == n2) continue;
                double d2 = this.A.get(n2, i);
                this.A.set(n2 * n + i, 0.0);
                for (n3 = 0; n3 < n; ++n3) {
                    this.A.minus(n2 * n + n3, d2 * this.A.unsafe_get(i, n3));
                }
                for (n3 = 0; n3 < denseMatrix64F2.numCols; ++n3) {
                    denseMatrix64F2.minus(n2 * denseMatrix64F2.numCols + n3, d2 * denseMatrix64F2.get(i * denseMatrix64F2.numCols + n3));
                }
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

