/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble2D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.array.impl.StriddenDouble2D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble2D
extends Double2D {
    static final int order = 1;
    final double[] data;

    public FlatDouble2D(int n, int n2) {
        super(n, n2);
        this.data = new double[this.number];
    }

    public FlatDouble2D(int[] nArray) {
        super(nArray);
        this.data = new double[this.number];
    }

    public FlatDouble2D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
    }

    public FlatDouble2D(double[] dArray, int n, int n2) {
        super(n, n2);
        this.checkSize(dArray);
        this.data = dArray;
    }

    public FlatDouble2D(double[] dArray, int[] nArray) {
        super(nArray);
        this.checkSize(dArray);
        this.data = dArray;
    }

    public FlatDouble2D(double[] dArray, Shape shape) {
        super(shape);
        this.checkSize(dArray);
        this.data = dArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] dArray) {
        if (dArray == null || dArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2) {
        return this.dim1 * n2 + n;
    }

    @Override
    public final double get(int n, int n2) {
        return this.data[this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, double d) {
        this.data[this.dim1 * n2 + n] = d;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        doubleScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            doubleScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (bl) {
            double[] dArray = new double[this.number];
            System.arraycopy(this.data, 0, dArray, 0, this.number);
            return dArray;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public Double1D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim2)) == 0) {
            return new FlatDouble1D(this.data, this.dim1);
        }
        return new StriddenDouble1D(this.data, this.dim1 * n, 1, this.dim1);
    }

    @Override
    public Double1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if ((n2 = Helper.fixSliceIndex(n2, 2)) == 0) {
            n5 = Helper.fixIndex(n, this.dim1);
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            n5 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n4 = 1;
            n3 = this.dim1;
        }
        return new StriddenDouble1D(this.data, n5, n4, n3);
    }

    @Override
    public Double2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenDouble2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Double2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.dim1, this.dim2, nArray2);
        return new SelectedDouble2D(this.data, nArray3, nArray4);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.data, this.number);
    }
}

