/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array9D;
import mitiv.array.Byte9D;
import mitiv.array.Double1D;
import mitiv.array.Double8D;
import mitiv.array.DoubleArray;
import mitiv.array.Float9D;
import mitiv.array.Int9D;
import mitiv.array.Long9D;
import mitiv.array.ShapedArray;
import mitiv.array.Short9D;
import mitiv.array.impl.FlatDouble9D;
import mitiv.array.impl.StriddenDouble9D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double9D
extends Array9D
implements DoubleArray {
    protected Double9D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    protected Double9D(int[] nArray) {
        super(nArray);
    }

    protected Double9D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, double var10);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) + d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) + d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) - d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) - d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) * d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) * d);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, doubleFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6, i7)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, doubleFunction.apply(this.get(i13, i12, i11, i10, i9, i8, k, j, i)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, doubleGenerator.nextDouble());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, doubleGenerator.nextDouble());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    doubleScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                    continue;
                                                }
                                                doubleScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    doubleScanner.update(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                    continue;
                                                }
                                                doubleScanner.initialize(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (!(d2 < d)) continue;
                                                d = d2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (!(d3 < d)) continue;
                                                d = d3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (!(d2 > d)) continue;
                                                d = d2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (!(d3 > d)) continue;
                                                d = d3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d3 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (d3 < d) {
                                                    d = d3;
                                                }
                                                if (!(d3 > d2)) continue;
                                                d2 = d3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                double d4 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (d4 < d) {
                                                    d = d4;
                                                }
                                                if (!(d4 > d2)) continue;
                                                d2 = d4;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                d += this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                d += this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte9D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                byArray[++n] = (byte)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte9D.wrap(byArray, this.getShape());
    }

    @Override
    public Short9D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                sArray[++n] = (short)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short9D.wrap(sArray, this.getShape());
    }

    @Override
    public Int9D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                nArray[++n] = (int)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int9D.wrap(nArray, this.getShape());
    }

    @Override
    public Long9D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                lArray[++n] = (long)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long9D.wrap(lArray, this.getShape());
    }

    @Override
    public Float9D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                fArray[++n] = (float)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float9D.wrap(fArray, this.getShape());
    }

    @Override
    public Double9D toDouble() {
        return this;
    }

    @Override
    public Double9D copy() {
        return new FlatDouble9D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double9D double9D = shapedArray.getType() == 5 ? (Double9D)shapedArray : (Double9D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double9D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, double9D.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, double9D.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                this.set(i7, i6, i5, i4, i3, i2, k, j, i, doubleShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, floatShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double9D create() {
        return new FlatDouble9D(this.getShape());
    }

    public static Double9D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatDouble9D(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Double9D create(int[] nArray) {
        return new FlatDouble9D(nArray);
    }

    public static Double9D create(Shape shape) {
        return new FlatDouble9D(shape);
    }

    public static Double9D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatDouble9D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Double9D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble9D(dArray, nArray);
    }

    public static Double9D wrap(double[] dArray, Shape shape) {
        return new FlatDouble9D(dArray, shape);
    }

    public static Double9D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        return new StriddenDouble9D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19);
    }

    @Override
    public abstract Double8D slice(int var1);

    @Override
    public abstract Double8D slice(int var1, int var2);

    @Override
    public abstract Double9D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8, Range var9);

    @Override
    public abstract Double9D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    @Override
    public abstract Double1D as1D();
}

