/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Time;

public class SIFReader
extends FormatReader {
    private static final String MAGIC_STRING = "Andor Technology";
    private static final int FOOTER_SIZE = 8;
    private long pixelOffset;

    public SIFReader() {
        super("Andor SIF", "sif");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).equals(MAGIC_STRING);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        double[] timestamp = null;
        int lineNumber = 1;
        String line = this.in.readLine();
        int endLine = -1;
        while (endLine < 0 || lineNumber < endLine) {
            ++lineNumber;
            if (line.startsWith("Pixel number")) {
                String[] tokens = line.split(" ");
                if (tokens.length > 2) {
                    m.sizeC = Integer.parseInt(tokens[2]);
                    m.sizeX = Integer.parseInt(tokens[3]);
                    m.sizeY = Integer.parseInt(tokens[4]);
                    m.sizeZ = Integer.parseInt(tokens[5]);
                    m.sizeT = Integer.parseInt(tokens[6]);
                    m.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                    timestamp = new double[this.getImageCount()];
                    endLine = lineNumber;
                    this.pixelOffset = this.in.length() - 8L - (long)(this.getImageCount() * this.getSizeX() * this.getSizeY() * 4);
                }
            } else if (lineNumber < endLine) {
                int index = lineNumber - (endLine - this.getImageCount()) - 1;
                if (index >= 0) {
                    try {
                        timestamp[index] = Double.parseDouble(line.trim());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("Could not parse timestamp #" + index, e);
                    }
                }
            } else {
                this.addGlobalMetaList("Line", line.trim());
            }
            line = this.in.readLine();
        }
        m.pixelType = 6;
        m.dimensionOrder = "XYCZT";
        m.littleEndian = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneDeltaT(new Time((double)timestamp[i], UNITS.SECOND), 0, i);
            }
        }
    }
}

