/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.csparsej.tdouble.Dcs_add;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_cumsum;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dropzeros;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dupl;
import edu.emory.mathcs.csparsej.tdouble.Dcs_multiply;
import edu.emory.mathcs.csparsej.tdouble.Dcs_transpose;
import edu.emory.mathcs.csparsej.tdouble.Dcs_util;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Dcs_common.Dcs dcs;
    protected boolean rowIndexesSorted;

    public SparseCCDoubleMatrix2D(double[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCDoubleMatrix2D(Dcs_common.Dcs dcs) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(dcs.m, dcs.n);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.dcs = dcs;
    }

    public SparseCCDoubleMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCDoubleMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.dcs = Dcs_util.cs_spalloc((int)rows, (int)columns, (int)nzmax, (boolean)true, (boolean)false);
    }

    public SparseCCDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double value, boolean removeDuplicates, boolean sortRowIndexes) {
        block10: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block10;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.dcs = Dcs_util.cs_spalloc((int)rows, (int)columns, (int)nz, (boolean)true, (boolean)false);
        int[] w = new int[columns];
        int[] Cp = this.dcs.p;
        int[] Ci = this.dcs.i;
        double[] Cx = this.dcs.x;
        int k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        Dcs_cumsum.cs_cumsum((int[])Cp, (int[])w, (int)columns);
        int k2 = 0;
        while (k2 < nz) {
            int n = columnIndexes[k2];
            w[n] = w[n] + 1;
            Ci[p] = rowIndexes[k2];
            if (Cx != null) {
                Cx[p] = value;
            }
            ++k2;
        }
        if (removeDuplicates && !Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (sortRowIndexes) {
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            if (this.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    public SparseCCDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortRowIndexes) {
        block11: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block11;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.dcs = Dcs_util.cs_spalloc((int)rows, (int)columns, (int)nz, (boolean)true, (boolean)false);
        int[] w = new int[columns];
        int[] Cp = this.dcs.p;
        int[] Ci = this.dcs.i;
        double[] Cx = this.dcs.x;
        int k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        Dcs_cumsum.cs_cumsum((int[])Cp, (int[])w, (int)columns);
        int k2 = 0;
        while (k2 < nz) {
            int n = columnIndexes[k2];
            w[n] = w[n] + 1;
            Ci[p] = rowIndexes[k2];
            if (Cx != null) {
                Cx[p] = values[k2];
            }
            ++k2;
        }
        if (removeZeroes) {
            Dcs_dropzeros.cs_dropzeros((Dcs_common.Dcs)this.dcs);
        }
        if (removeDuplicates && !Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
        if (sortRowIndexes) {
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
            if (this.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_transpose()!");
            }
            this.rowIndexesSorted = true;
        }
    }

    @Override
    public DoubleMatrix2D assign(final DoubleFunction function) {
        if (function instanceof DoubleMult) {
            double alpha = ((DoubleMult)function).multiplicator;
            if (alpha == 1.0) {
                return this;
            }
            if (alpha == 0.0) {
                return this.assign(0.0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            double[] valuesE = this.dcs.x;
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                valuesE[n] = valuesE[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        if (value == 0.0) {
            Arrays.fill(this.dcs.i, 0);
            Arrays.fill(this.dcs.p, 0);
            Arrays.fill(this.dcs.x, 0.0);
        } else {
            int nnz = this.cardinality();
            int i = 0;
            while (i < nnz) {
                this.dcs.x[i] = value;
                ++i;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D other = (SparseCCDoubleMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.dcs.p, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.dcs.nzmax < nzmax) {
                this.dcs.i = new int[nzmax];
                this.dcs.x = new double[nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.dcs.i, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.dcs.x, 0, nzmax);
            this.rowIndexesSorted = other.rowIndexesSorted;
        } else if (source instanceof SparseRCDoubleMatrix2D) {
            SparseRCDoubleMatrix2D other = ((SparseRCDoubleMatrix2D)source).getTranspose();
            this.dcs.p = other.getRowPointers();
            this.dcs.i = other.getColumnIndexes();
            this.dcs.x = other.getValues();
            this.dcs.nzmax = this.dcs.x.length;
            this.rowIndexesSorted = true;
        } else {
            this.assign(0.0);
            source.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    SparseCCDoubleMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.checkShape(y);
        if (y instanceof SparseCCDoubleMatrix2D && function == DoubleFunctions.plus) {
            SparseCCDoubleMatrix2D yy = (SparseCCDoubleMatrix2D)y;
            this.dcs = Dcs_add.cs_add((Dcs_common.Dcs)this.dcs, (Dcs_common.Dcs)yy.dcs, (double)1.0, (double)1.0);
            return this;
        }
        if (function instanceof DoublePlusMultSecond) {
            final double alpha = ((DoublePlusMultSecond)function).multiplicator;
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    SparseCCDoubleMatrix2D.this.setQuick(i, j, SparseCCDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof DoublePlusMultFirst) {
            final double alpha = ((DoublePlusMultFirst)function).multiplicator;
            if (alpha == 0.0) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    SparseCCDoubleMatrix2D.this.setQuick(i, j, alpha * SparseCCDoubleMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == DoubleFunctions.mult) {
            int[] rowIndexesA = this.dcs.i;
            int[] columnPointersA = this.dcs.p;
            double[] valuesA = this.dcs.x;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] * y.getQuick(i, j);
                    if (valuesA[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == DoubleFunctions.div) {
            int[] rowIndexesA = this.dcs.i;
            int[] columnPointersA = this.dcs.p;
            double[] valuesA = this.dcs.x;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] / y.getQuick(i, j);
                    if (valuesA[k] != 0.0) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.dcs.p[this.columns];
    }

    public Dcs_common.Dcs elements() {
        return this.dcs;
    }

    @Override
    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        int[] rowIndexesA = this.dcs.i;
        int[] columnPointersA = this.dcs.p;
        double[] valuesA = this.dcs.x;
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                double r;
                int i = rowIndexesA[k];
                double value = valuesA[k];
                valuesA[k] = r = function.apply(i, j, value);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.dcs.p;
    }

    public DenseDoubleMatrix2D getDense() {
        final DenseDoubleMatrix2D dense = new DenseDoubleMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDoubleFunction(){

            @Override
            public double apply(int i, int j, double value) {
                dense.setQuick(i, j, SparseCCDoubleMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized double getQuick(int row, int column) {
        int k = SparseCCDoubleMatrix2D.searchFromTo(this.dcs.i, row, this.dcs.p[column], this.dcs.p[column + 1] - 1);
        double v = 0.0;
        if (k >= 0) {
            v = this.dcs.x[k];
        }
        return v;
    }

    public SparseRCDoubleMatrix2D getRowCompressed() {
        Dcs_common.Dcs dcst = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        SparseRCDoubleMatrix2D rc = new SparseRCDoubleMatrix2D(this.rows, this.columns);
        rc.columnIndexes = dcst.i;
        rc.rowPointers = dcst.p;
        rc.values = dcst.x;
        rc.columnIndexesSorted = true;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.dcs.i;
    }

    public SparseCCDoubleMatrix2D getTranspose() {
        Dcs_common.Dcs dcst = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        SparseCCDoubleMatrix2D tr = new SparseCCDoubleMatrix2D(this.columns, this.rows);
        tr.dcs = dcst;
        return tr;
    }

    public double[] getValues() {
        return this.dcs.x;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseCCDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, double value) {
        int k = SparseCCDoubleMatrix2D.searchFromTo(this.dcs.i, row, this.dcs.p[column], this.dcs.p[column + 1] - 1);
        if (k >= 0) {
            if (value == 0.0) {
                this.remove(column, k);
            } else {
                this.dcs.x[k] = value;
            }
            return;
        }
        if (value != 0.0) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortRowIndexes() {
        this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        this.dcs = Dcs_transpose.cs_transpose((Dcs_common.Dcs)this.dcs, (boolean)true);
        if (this.dcs == null) {
            throw new IllegalArgumentException("Exception occured in cs_transpose()!");
        }
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        if (!Dcs_dupl.cs_dupl((Dcs_common.Dcs)this.dcs)) {
            throw new IllegalArgumentException("Exception occured in cs_dupl()!");
        }
    }

    public void removeZeroes() {
        Dcs_dropzeros.cs_dropzeros((Dcs_common.Dcs)this.dcs);
    }

    @Override
    public void trimToSize() {
        Dcs_util.cs_sprealloc((Dcs_common.Dcs)this.dcs, (int)0);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int i = 0;
        while (i < this.columns) {
            int high = this.dcs.p[i + 1];
            int j = this.dcs.p[i];
            while (j < high) {
                builder.append('(').append(this.dcs.i[j]).append(',').append(i).append(')').append('\t').append(this.dcs.x[j]).append('\n');
                ++j;
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, final double beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || transposeA;
        if (z == null) {
            z = new DenseDoubleMatrix1D(rowsA);
        }
        if (!(y instanceof DenseDoubleMatrix1D) || !(z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        final double[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)zz.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        final double[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)yy.index(0);
        final int[] rowIndexesA = this.dcs.i;
        final int[] columnPointersA = this.dcs.p;
        final double[] valuesA = this.dcs.x;
        int zidx = zeroZ;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (!transposeA) {
            if (!ignore && beta / alpha != 1.0) {
                z.assign(DoubleFunctions.mult(beta / alpha));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final double[] result = new double[rowsA];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (threadID == 0) {
                                int i = firstColumn;
                                while (i < lastColumn) {
                                    int high = columnPointersA[i + 1];
                                    double yElem = elementsY[zeroY + strideY * i];
                                    int k = columnPointersA[i];
                                    while (k < high) {
                                        int j = rowIndexesA[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + valuesA[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            } else {
                                int i = firstColumn;
                                while (i < lastColumn) {
                                    int high = columnPointersA[i + 1];
                                    double yElem = elementsY[zeroY + strideY * i];
                                    int k = columnPointersA[i];
                                    while (k < high) {
                                        int j;
                                        int n = j = rowIndexesA[k];
                                        result[n] = result[n] + valuesA[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                int j2 = rem = rowsA % 10;
                while (j2 < rowsA) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    int n2 = zeroZ + (j2 + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j2 + 1];
                    int n3 = zeroZ + (j2 + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j2 + 2];
                    int n4 = zeroZ + (j2 + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j2 + 3];
                    int n5 = zeroZ + (j2 + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j2 + 4];
                    int n6 = zeroZ + (j2 + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j2 + 5];
                    int n7 = zeroZ + (j2 + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j2 + 6];
                    int n8 = zeroZ + (j2 + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j2 + 7];
                    int n9 = zeroZ + (j2 + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j2 + 8];
                    int n10 = zeroZ + (j2 + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j2 + 9];
                    j2 += 10;
                }
                j2 = 0;
                while (j2 < rem) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    ++j2;
                }
            } else {
                int i = 0;
                while (i < this.columns) {
                    int high = columnPointersA[i + 1];
                    double yElem = elementsY[zeroY + strideY * i];
                    int k = columnPointersA[i];
                    while (k < high) {
                        int j = rowIndexesA[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + valuesA[k] * yElem;
                        ++k;
                    }
                    ++i;
                }
            }
            if (alpha != 1.0) {
                z.assign(DoubleFunctions.mult(alpha));
            }
        } else if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstColumn * strideZ;
                        int k = SparseCCDoubleMatrix2D.this.dcs.p[firstColumn];
                        int i = firstColumn;
                        while (i < lastColumn) {
                            double sum = 0.0;
                            int high = SparseCCDoubleMatrix2D.this.dcs.p[i + 1];
                            while (k + 10 < high) {
                                int ind = k + 9;
                                sum += valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCDoubleMatrix2D.this.dcs.i[ind--]];
                                k += 10;
                            }
                            while (k < high) {
                                sum += valuesA[k] * elementsY[SparseCCDoubleMatrix2D.this.dcs.i[k]];
                                ++k;
                            }
                            elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                            zidx += strideZ;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int k = this.dcs.p[0];
            int i = 0;
            while (i < this.columns) {
                double sum = 0.0;
                int high = this.dcs.p[i + 1];
                while (k + 10 < high) {
                    int ind = k + 9;
                    sum += valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.dcs.i[ind--]];
                    k += 10;
                }
                while (k < high) {
                    sum += valuesA[k] * elementsY[this.dcs.i[k]];
                    ++k;
                }
                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                zidx += strideZ;
                ++i;
            }
        }
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseCCDoubleMatrix2D ? new SparseCCDoubleMatrix2D(rowsA, p, rowsA * p) : new DenseDoubleMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && beta != 1.0) {
            C.assign(DoubleFunctions.mult(beta));
        }
        if (B instanceof DenseDoubleMatrix2D && C instanceof DenseDoubleMatrix2D) {
            SparseCCDoubleMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseDoubleMatrix2D BB = transposeB ? (DenseDoubleMatrix2D)B.viewDice() : (DenseDoubleMatrix2D)B;
            DenseDoubleMatrix2D CC = (DenseDoubleMatrix2D)C;
            int[] columnPointersA = AA.dcs.p;
            int[] rowIndexesA = AA.dcs.i;
            double[] valuesA = AA.dcs.x;
            int zeroB = (int)BB.index(0, 0);
            int rowStrideB = BB.rowStride();
            int columnStrideB = BB.columnStride();
            double[] elementsB = BB.elements;
            int zeroC = (int)CC.index(0, 0);
            int rowStrideC = CC.rowStride();
            int columnStrideC = CC.columnStride();
            double[] elementsC = CC.elements;
            int jj = 0;
            while (jj < columnsB) {
                int kk = 0;
                while (kk < columnsA) {
                    int high = columnPointersA[kk + 1];
                    double yElem = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB];
                    int ii = columnPointersA[kk];
                    while (ii < high) {
                        int j = rowIndexesA[ii];
                        int n = zeroC + j * rowStrideC + jj * columnStrideC;
                        elementsC[n] = elementsC[n] + valuesA[ii] * yElem;
                        ++ii;
                    }
                    ++kk;
                }
                ++jj;
            }
            if (alpha != 1.0) {
                C.assign(DoubleFunctions.mult(alpha));
            }
        } else if (B instanceof SparseCCDoubleMatrix2D && C instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseCCDoubleMatrix2D BB = (SparseCCDoubleMatrix2D)B;
            if (transposeB) {
                BB = BB.getTranspose();
            }
            SparseCCDoubleMatrix2D CC = (SparseCCDoubleMatrix2D)C;
            CC.dcs = Dcs_multiply.cs_multiply((Dcs_common.Dcs)AA.dcs, (Dcs_common.Dcs)BB.dcs);
            if (CC.dcs == null) {
                throw new IllegalArgumentException("Exception occured in cs_multiply()");
            }
            if (alpha != 1.0) {
                CC.assign(DoubleFunctions.mult(alpha));
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            DoubleMatrix1D[] Brows = new DoubleMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            DoubleMatrix1D[] Crows = new DoubleMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            DoublePlusMultSecond fun = DoublePlusMultSecond.plusMult(0.0);
            int[] rowIndexesA = this.dcs.i;
            int[] columnPointersA = this.dcs.p;
            double[] valuesA = this.dcs.x;
            int i3 = this.columns;
            while (--i3 >= 0) {
                int low = columnPointersA[i3];
                int k = columnPointersA[i3 + 1];
                while (--k >= low) {
                    int j = rowIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[j].assign(Brows[i3], fun);
                        continue;
                    }
                    Crows[i3].assign(Brows[j], fun);
                }
            }
        }
        return C;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, double value) {
        IntArrayList rowIndexes = new IntArrayList(this.dcs.i);
        rowIndexes.setSizeRaw(this.dcs.p[this.columns]);
        DoubleArrayList values = new DoubleArrayList(this.dcs.x);
        values.setSizeRaw(this.dcs.p[this.columns]);
        rowIndexes.beforeInsert(index, row);
        values.beforeInsert(index, value);
        int i = this.dcs.p.length;
        while (--i > column) {
            int n = i;
            this.dcs.p[n] = this.dcs.p[n] + 1;
        }
        this.dcs.i = rowIndexes.elements();
        this.dcs.x = values.elements();
        this.dcs.nzmax = rowIndexes.elements().length;
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexes = new IntArrayList(this.dcs.i);
        DoubleArrayList values = new DoubleArrayList(this.dcs.x);
        rowIndexes.remove(index);
        values.remove(index);
        int i = this.dcs.p.length;
        while (--i > column) {
            int n = i;
            this.dcs.p[n] = this.dcs.p[n] - 1;
        }
        this.dcs.i = rowIndexes.elements();
        this.dcs.x = values.elements();
        this.dcs.nzmax = rowIndexes.elements().length;
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }
}

