/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.jet.math.tdcomplex.DComplex;

public class DComplexPlusMultFirst
implements DComplexDComplexDComplexFunction {
    public double[] multiplicator;

    protected DComplexPlusMultFirst(double[] multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public final double[] apply(double[] a, double[] b) {
        double[] z = new double[]{a[0] * this.multiplicator[0] - a[1] * this.multiplicator[1], a[1] * this.multiplicator[0] + a[0] * this.multiplicator[1]};
        z[0] = z[0] + b[0];
        z[1] = z[1] + b[1];
        return z;
    }

    public static DComplexPlusMultFirst minusDiv(double[] constant) {
        return new DComplexPlusMultFirst(DComplex.neg(DComplex.inv(constant)));
    }

    public static DComplexPlusMultFirst minusMult(double[] constant) {
        return new DComplexPlusMultFirst(DComplex.neg(constant));
    }

    public static DComplexPlusMultFirst plusDiv(double[] constant) {
        return new DComplexPlusMultFirst(DComplex.inv(constant));
    }

    public static DComplexPlusMultFirst plusMult(double[] constant) {
        return new DComplexPlusMultFirst(constant);
    }
}

