/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LBFGSOperator
extends LinearEndomorphism {
    static final int NO_SCALING = 0;
    static final int OREN_SPEDICATO_SCALING = 1;
    static final int BARZILAI_BORWEIN_SCALING = 2;
    static final int CONSTANT_SCALING = 4;
    protected Vector[] s;
    protected Vector[] y;
    protected final int m;
    protected int mp;
    protected int updates;
    protected double[] rho;
    protected double gamma;
    protected double[] alpha;
    protected LinearOperator H0;
    protected int rule = 1;

    public LBFGSOperator(VectorSpace vectorSpace, int n) {
        super(vectorSpace);
        this.m = n;
        this.H0 = null;
        this.allocateWorkspace();
    }

    public LBFGSOperator(LinearEndomorphism linearEndomorphism, int n) {
        super(linearEndomorphism.getSpace());
        this.m = n;
        this.H0 = linearEndomorphism;
        this.allocateWorkspace();
    }

    private void allocateWorkspace() {
        this.s = new Vector[this.m];
        this.y = new Vector[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.s[i] = this.space.create();
            this.y[i] = this.space.create();
        }
        this.alpha = new double[this.m];
        this.rho = new double[this.m];
        this.mp = 0;
        this.updates = 0;
        this.gamma = 1.0;
    }

    public void reset() {
        this.mp = 0;
    }

    public void setScaling(int n) {
        this.rule = n;
    }

    public int getScaling() {
        return this.rule;
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale factor must be strictly positive");
        }
        this.gamma = d;
        this.rule = 4;
    }

    public double getScale() {
        return this.gamma;
    }

    protected int slot(int n) {
        if (n < 0 || n > this.mp) {
            throw new IndexOutOfBoundsException("BFGS slot index is out of bounds");
        }
        return (this.updates - n) % this.m;
    }

    protected Vector s(int n) {
        return this.s[this.slot(n)];
    }

    protected Vector y(int n) {
        return this.y[this.slot(n)];
    }

    private boolean applyInPlace(Vector vector) {
        int n;
        int n2;
        for (n2 = 1; n2 <= this.mp; ++n2) {
            n = this.slot(n2);
            if (!(this.rho[n] > 0.0)) continue;
            this.alpha[n] = this.rho[n] * vector.dot(this.s[n]);
            vector.add(-this.alpha[n], this.y[n]);
        }
        if (this.H0 != null) {
            this.H0.apply(vector, vector);
        } else if (this.gamma != 1.0) {
            vector.scale(this.gamma);
        }
        for (n2 = this.mp; n2 >= 1; --n2) {
            n = this.slot(n2);
            if (!(this.rho[n] > 0.0)) continue;
            double d = this.rho[n] * vector.dot(this.y[n]);
            vector.add(this.alpha[n] - d, this.s[n]);
        }
        return true;
    }

    private boolean applyInPlace(Vector vector, Vector vector2) {
        double d;
        int n;
        int n2;
        boolean bl = this.H0 == null;
        this.gamma = 0.0;
        for (n2 = 1; n2 <= this.mp; ++n2) {
            double d2;
            n = this.slot(n2);
            d = vector.dot(this.y[n], this.s[n]);
            if (d <= 0.0) {
                this.rho[n] = 0.0;
                continue;
            }
            this.rho[n] = 1.0 / d;
            this.alpha[n] = this.rho[n] * vector.dot(vector2, this.s[n]);
            vector2.add(-this.alpha[n], this.y[n]);
            if (!bl || !((d2 = vector.dot(this.y[n], this.y[n])) > 0.0)) continue;
            this.gamma = d / d2;
            bl = false;
        }
        if (bl) {
            return false;
        }
        if (this.H0 != null) {
            this.H0.apply(vector2, vector2);
        } else if (this.gamma != 1.0) {
            vector2.scale(this.gamma);
        }
        for (n2 = this.mp; n2 >= 1; --n2) {
            n = this.slot(n2);
            if (!(this.rho[n] > 0.0)) continue;
            d = this.rho[n] * vector.dot(vector2, this.y[n]);
            vector2.add(this.alpha[n] - d, this.s[n]);
        }
        return true;
    }

    public boolean apply(Vector vector, Vector vector2, Vector vector3) {
        if (vector != null && !vector.belongsTo(this.space) || !vector2.belongsTo(this.space) || !vector3.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        if (this.mp < 1) {
            return false;
        }
        if (vector2 != vector3) {
            vector3.copy(vector2);
        }
        if (vector == null) {
            return this.applyInPlace(vector2);
        }
        return this.applyInPlace(vector, vector2);
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) {
        if (n != DIRECT && n != ADJOINT) {
            throw new IllegalLinearOperationException();
        }
        if (vector != vector2) {
            vector.copy(vector2);
        }
        this.applyInPlace(vector);
    }

    public void update(Vector vector, Vector vector2, Vector vector3, Vector vector4) throws IncorrectSpaceException {
        this.update(vector, vector2, vector3, vector4, false);
    }

    public void update(Vector vector, Vector vector2, Vector vector3, Vector vector4, boolean bl) throws IncorrectSpaceException {
        int n = this.slot(0);
        this.s[n].combine(1.0, vector, -1.0, vector2);
        this.y[n].combine(1.0, vector3, -1.0, vector4);
        if (bl) {
            this.rho[n] = 0.0;
            this.gamma = 0.0;
        } else {
            double d = this.s[n].dot(this.y[n]);
            if (d <= 0.0) {
                this.rho[n] = 0.0;
                return;
            }
            this.rho[n] = 1.0 / d;
            if (this.rule == 1 || this.rule == 5 && this.updates == 0) {
                double d2 = this.y[n].norm2();
                this.gamma = d / d2 / d2;
            } else if (this.rule == 2 || this.rule == 6 && this.updates == 0) {
                double d3 = this.s[n].norm2();
                this.gamma = d3 / d * d3;
            }
        }
        ++this.updates;
        if (this.mp < this.m) {
            ++this.mp;
        }
    }
}

