/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.IntScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class StriddenInt1D
extends Int1D {
    final int order;
    final int[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenInt1D(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        super(nArray3);
        if (nArray2.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = nArray;
        this.offset = n;
        this.stride1 = nArray2[0];
        this.order = Int1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenInt1D(int[] nArray, int n, int n2, int n3) {
        super(n3);
        this.data = nArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Int1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Int1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final int get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2) {
        this.data[this.offset + this.stride1 * n] = n2;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.stride1 * i + this.offset;
            this.data[n2] = n;
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = intGenerator.nextInt();
        }
    }

    @Override
    public void increment(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.stride1 * i + this.offset;
            this.data[n3] = this.data[n3] + n;
        }
    }

    @Override
    public void decrement(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.stride1 * i + this.offset;
            this.data[n3] = this.data[n3] - n;
        }
    }

    @Override
    public void scale(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.stride1 * i + this.offset;
            this.data[n3] = this.data[n3] * n;
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = intFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                intScanner.update(this.data[n]);
                continue;
            }
            intScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        int[] nArray = new int[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, nArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                nArray[++n] = this.data[n2];
            }
        }
        return nArray;
    }

    @Override
    public int[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public IntScalar slice(int n) {
        return new IntScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public IntScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new IntScalar(this.data, n3);
    }

    @Override
    public Int1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenInt1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Int1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedInt1D(this.data, nArray2);
    }

    @Override
    public Int1D as1D() {
        return this;
    }
}

