/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.LongArray;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public class LongScalar
extends Scalar
implements LongArray {
    final long[] data;
    final int offset;
    final boolean flat;

    public LongScalar() {
        this.data = new long[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public LongScalar create() {
        return new LongScalar();
    }

    public LongScalar(long[] lArray, int n) {
        this.data = lArray;
        this.offset = n;
        this.flat = n == 0 && lArray.length == 1;
        this.checkSanity();
    }

    public static LongScalar wrap(long[] lArray, int n) {
        return new LongScalar(lArray, n);
    }

    public LongScalar(long l) {
        this.data = new long[]{l};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 3;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final long get() {
        return this.data[this.offset];
    }

    public final void set(long l) {
        this.data[this.offset] = l;
    }

    @Override
    public final void fill(long l) {
        this.data[this.offset] = l;
    }

    @Override
    public final void fill(LongGenerator longGenerator) {
        this.data[this.offset] = longGenerator.nextLong();
    }

    @Override
    public final void increment(long l) {
        int n = this.offset;
        this.data[n] = this.data[n] + l;
    }

    @Override
    public final void decrement(long l) {
        int n = this.offset;
        this.data[n] = this.data[n] - l;
    }

    @Override
    public final void scale(long l) {
        int n = this.offset;
        this.data[n] = this.data[n] * l;
    }

    @Override
    public final void map(LongFunction longFunction) {
        this.data[this.offset] = longFunction.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(LongScanner longScanner) {
        longScanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final long[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        return new long[]{this.data[this.offset]};
    }

    @Override
    public final long[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public long min() {
        return this.data[this.offset];
    }

    @Override
    public long max() {
        return this.data[this.offset];
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        lArray[0] = l = this.data[this.offset];
        lArray[1] = l;
    }

    @Override
    public long sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar((int)this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return this;
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar(this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Long1D as1D() {
        if (this.offset == 0) {
            return new FlatLong1D(this.data, 1);
        }
        return new StriddenLong1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray shapedArray) {
        if (!shape.equals(shapedArray.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (shapedArray.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)shapedArray).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)shapedArray).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)shapedArray).get();
                break;
            }
            case 3: {
                this.data[this.offset] = ((LongScalar)shapedArray).get();
                break;
            }
            case 4: {
                this.data[this.offset] = (long)((FloatScalar)shapedArray).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (long)((DoubleScalar)shapedArray).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector shapedVector) {
        if (!shape.equals(shapedVector.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (long)shapedVector.get(0);
    }

    @Override
    public final LongScalar copy() {
        return new LongScalar(this.data[this.offset]);
    }
}

