/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin1D;

public class StaticFloatBin1D
extends AbstractFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected int size = 0;
    protected float min = 0.0f;
    protected float max = 0.0f;
    protected float sum = 0.0f;
    protected float sum_xx = 0.0f;
    protected static transient float[] arguments = new float[20];

    public StaticFloatBin1D() {
        this.clear();
    }

    @Override
    public synchronized void add(float element) {
        this.addAllOf(new FloatArrayList(new float[]{element}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addAllOfFromTo(FloatArrayList list, int from, int to) {
        float[] fArray = arguments;
        synchronized (arguments) {
            StaticFloatBin1D.arguments[0] = this.min;
            StaticFloatBin1D.arguments[1] = this.max;
            StaticFloatBin1D.arguments[2] = this.sum;
            StaticFloatBin1D.arguments[3] = this.sum_xx;
            FloatDescriptive.incrementalUpdate(list, from, to, arguments);
            this.min = arguments[0];
            this.max = arguments[1];
            this.sum = arguments[2];
            this.sum_xx = arguments[3];
            this.size += to - from + 1;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void clear() {
        this.clearAllMeasures();
        this.size = 0;
    }

    protected void clearAllMeasures() {
        this.min = Float.POSITIVE_INFINITY;
        this.max = Float.NEGATIVE_INFINITY;
        this.sum = 0.0f;
        this.sum_xx = 0.0f;
    }

    @Override
    public synchronized boolean isRebinnable() {
        return false;
    }

    @Override
    public synchronized float max() {
        return this.max;
    }

    @Override
    public synchronized float min() {
        return this.min;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized float sum() {
        return this.sum;
    }

    @Override
    public synchronized float sumOfSquares() {
        return this.sum_xx;
    }
}

