/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.Transpose;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedDenseColumnFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netlib.blas.BLAS;

public class DenseColumnFloatMatrix2D
extends FloatMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    protected float[] elements;

    public DenseColumnFloatMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseColumnFloatMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 1, rows);
        this.elements = new float[rows * columns];
    }

    public DenseColumnFloatMatrix2D(int rows, int columns, float[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseColumnFloatMatrix2D(MatrixVectorReader reader) throws IOException {
        block9: {
            int i;
            float[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block8: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new float[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new float[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                i = 0;
                while (i < numEntries) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                    ++i;
                }
                if (!info.isSymmetric()) break block8;
                i = 0;
                while (i < numEntries) {
                    if (rowIndexes[i] != columnIndexes[i]) {
                        this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                    }
                    ++i;
                }
                break block9;
            }
            if (!info.isSkewSymmetric()) break block9;
            i = 0;
            while (i < numEntries) {
                if (rowIndexes[i] != columnIndexes[i]) {
                    this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseColumnFloatMatrix2D.this.elements[zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnFloatMatrix2D.this.columnStride;
                            int r = DenseColumnFloatMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnFloatMatrix2D.this.elements[r * DenseColumnFloatMatrix2D.this.rowStride + cidx]));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, final FloatProcedure cond) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float elem = DenseColumnFloatMatrix2D.this.elements[zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        float a = 0.0f;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnFloatMatrix2D.this.columnStride;
                            int r = DenseColumnFloatMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                elem = DenseColumnFloatMatrix2D.this.elements[r * DenseColumnFloatMatrix2D.this.rowStride + cidx];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            float elem = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (cond.apply(elem)) {
                a = f.apply(elem);
            }
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    elem = this.elements[r * this.rowStride + cidx];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseColumnFloatMatrix2D.this.elements[zero + rowElements[firstIdx - 1] * DenseColumnFloatMatrix2D.this.rowStride + columnElements[firstIdx - 1] * DenseColumnFloatMatrix2D.this.columnStride]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseColumnFloatMatrix2D.this.elements[zero + rowElements[i] * DenseColumnFloatMatrix2D.this.rowStride + columnElements[i] * DenseColumnFloatMatrix2D.this.columnStride]));
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[size - 1] * this.rowStride + columnElements[size - 1] * this.columnStride]);
            int i = size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride]));
            }
        }
        return a;
    }

    @Override
    public float aggregate(FloatMatrix2D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        if (!(other instanceof DenseColumnFloatMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final float[] otherElements = (float[])other.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseColumnFloatMatrix2D.this.elements[zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride], otherElements[zeroOther + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnFloatMatrix2D.this.columnStride;
                            int cidxOther = zeroOther + c * columnStrideOther;
                            int r = DenseColumnFloatMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnFloatMatrix2D.this.elements[r * DenseColumnFloatMatrix2D.this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], otherElements[zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther]);
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int cidxOther = zeroOther + c * columnStrideOther;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public FloatMatrix2D assign(final FloatFunction function) {
        if (function instanceof FloatMult) {
            float multiplicator = ((FloatMult)function).multiplicator;
            if (multiplicator == 1.0f) {
                return this;
            }
            if (multiplicator == 0.0f) {
                return this.assign(0.0f);
            }
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        if (function instanceof FloatMult) {
                            float multiplicator = ((FloatMult)function).multiplicator;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] * multiplicator;
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = function.apply(DenseColumnFloatMatrix2D.this.elements[i]);
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof FloatMult) {
                float multiplicator = ((FloatMult)function).multiplicator;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * multiplicator;
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i]);
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final FloatProcedure cond, final FloatFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                float elem = DenseColumnFloatMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    float elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final FloatProcedure cond, final float value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                float elem = DenseColumnFloatMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = value;
                                }
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    float elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[i] = value;
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = value;
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                            int idxOther = DenseColumnFloatMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.rows;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = values[idxOther--];
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = values.length - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = values[idxOther--];
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "columns()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseColumnFloatMatrix2D.this.rowStride + (DenseColumnFloatMatrix2D.this.columns - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            float[] currentRow = values[r];
                            if (currentRow.length != DenseColumnFloatMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + DenseColumnFloatMatrix2D.this.columns());
                            }
                            int i = idx;
                            int c = DenseColumnFloatMatrix2D.this.columns;
                            while (--c >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[i] = currentRow[c];
                                i -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.rowStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int r = this.rows;
            while (--r >= 0) {
                float[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + this.columns());
                }
                int i = idx;
                int c = this.columns;
                while (--c >= 0) {
                    this.elements[i] = currentRow[c];
                    i -= this.columnStride;
                }
                idx -= this.rowStride;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D source) {
        if (!(source instanceof DenseColumnFloatMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnFloatMatrix2D other = (DenseColumnFloatMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FloatMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnFloatMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnFloatMatrix2D)c;
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final float[] otherElements = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnFloatMatrix2D.this.elements[i] = otherElements[j];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = otherElements[j];
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, final FloatFloatFunction function) {
        float multiplicator;
        if (function instanceof FloatPlusMultSecond && (multiplicator = ((FloatPlusMultSecond)function).multiplicator) == 0.0f) {
            return this;
        }
        if (function instanceof FloatPlusMultFirst && (multiplicator = ((FloatPlusMultFirst)function).multiplicator) == 0.0f) {
            return this.assign(y);
        }
        if (!(y instanceof DenseColumnFloatMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnFloatMatrix2D other = (DenseColumnFloatMatrix2D)y;
        this.checkShape(y);
        final float[] otherElements = other.elements;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        if (function == FloatFunctions.mult) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] * otherElements[j];
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function == FloatFunctions.div) {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    int n = i;
                                    DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] / otherElements[j];
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        } else if (function instanceof FloatPlusMultSecond) {
                            float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1.0f) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1.0f) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] - otherElements[j];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] + multiplicator * otherElements[j];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else if (function instanceof FloatPlusMultFirst) {
                            float multiplicator = ((FloatPlusMultFirst)function).multiplicator;
                            if (multiplicator == 1.0f) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        int n = i;
                                        DenseColumnFloatMatrix2D.this.elements[n] = DenseColumnFloatMatrix2D.this.elements[n] + otherElements[j];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else if (multiplicator == -1.0f) {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnFloatMatrix2D.this.elements[i] = otherElements[j] - DenseColumnFloatMatrix2D.this.elements[i];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            } else {
                                int c = firstColumn;
                                while (--c >= lastColumn) {
                                    int i = idx;
                                    int j = idxOther;
                                    int r = DenseColumnFloatMatrix2D.this.rows;
                                    while (--r >= 0) {
                                        DenseColumnFloatMatrix2D.this.elements[i] = multiplicator * DenseColumnFloatMatrix2D.this.elements[i] + otherElements[j];
                                        i -= DenseColumnFloatMatrix2D.this.rowStride;
                                        j -= rowStrideOther;
                                    }
                                    idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                    idxOther -= columnStrideOther;
                                }
                            }
                        } else {
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = function.apply(DenseColumnFloatMatrix2D.this.elements[i], otherElements[j]);
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                    j -= rowStrideOther;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                                idxOther -= columnStrideOther;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            if (function == FloatFunctions.mult) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] * otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function == FloatFunctions.div) {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        int n = i;
                        this.elements[n] = this.elements[n] / otherElements[j];
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            } else if (function instanceof FloatPlusMultSecond) {
                float multiplicator2 = ((FloatPlusMultSecond)function).multiplicator;
                if (multiplicator2 == 1.0f) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator2 == -1.0f) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] - otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + multiplicator2 * otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else if (function instanceof FloatPlusMultFirst) {
                float multiplicator3 = ((FloatPlusMultFirst)function).multiplicator;
                if (multiplicator3 == 1.0f) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            int n = i;
                            this.elements[n] = this.elements[n] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else if (multiplicator3 == -1.0f) {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = otherElements[j] - this.elements[i];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                } else {
                    int c = this.columns;
                    while (--c >= 0) {
                        int i = idx;
                        int j = idxOther;
                        int r = this.rows;
                        while (--r >= 0) {
                            this.elements[i] = multiplicator3 * this.elements[i] + otherElements[j];
                            i -= this.rowStride;
                            j -= rowStrideOther;
                        }
                        idx -= this.columnStride;
                        idxOther -= columnStrideOther;
                    }
                }
            } else {
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int j = idxOther;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = function.apply(this.elements[i], otherElements[j]);
                        i -= this.rowStride;
                        j -= rowStrideOther;
                    }
                    idx -= this.columnStride;
                    idxOther -= columnStrideOther;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, final FloatFloatFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        if (!(y instanceof DenseColumnFloatMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnFloatMatrix2D other = (DenseColumnFloatMatrix2D)y;
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final float[] otherElements = other.elements();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            int idx = zero + rowElements[i] * DenseColumnFloatMatrix2D.this.rowStride + columnElements[i] * DenseColumnFloatMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseColumnFloatMatrix2D.this.elements[idx] = function.apply(DenseColumnFloatMatrix2D.this.elements[idx], otherElements[idxOther]);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = size;
            while (--i >= 0) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], otherElements[idxOther]);
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                if (DenseColumnFloatMatrix2D.this.elements[i] != 0.0f) {
                                    ++cardinality;
                                }
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    if (this.elements[i] != 0.0f) {
                        ++cardinality;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return cardinality;
    }

    public void dct2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.forward((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).dct(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dct(scale);
            }
        }
    }

    public void dctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).dct(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dct(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2() {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.forward((float[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).dht();
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).dht();
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dht();
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.forward((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).dst(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dst(scale);
            }
        }
    }

    public void dstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).dst(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dst(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft2() {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realForward((float[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                float value = DenseColumnFloatMatrix2D.this.elements[i];
                                if (value != 0.0f) {
                                    DenseColumnFloatMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    float value = this.elements[i];
                    if (value != 0.0f) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public DenseFloatMatrix2D getRowMajor() {
        DenseFloatMatrix2D R = new DenseFloatMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final float[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int idxR = zeroR + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideR + (firstColumn - 1) * columnStrideR;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxR;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsR[j] = DenseColumnFloatMatrix2D.this.elements[i];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                                j -= rowStrideR;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            idxR -= columnStrideR;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxR = zeroR + (this.rows - 1) * rowStrideR + (this.columns - 1) * columnStrideR;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxR;
                int r = this.rows;
                while (--r >= 0) {
                    elementsR[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideR;
                }
                idx -= this.columnStride;
                idxR -= columnStrideR;
            }
        }
        return R;
    }

    public DenseFComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] elementsC = C.elements();
        final int zero = (int)this.index(0, 0);
        final int zeroC = (int)C.index(0, 0);
        final int rowStrideC = C.rowStride() / 2;
        boolean columnStrideC = true;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int idxOther = zeroC + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideC + (firstColumn - 1) * 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsC[j] = DenseColumnFloatMatrix2D.this.elements[i];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                                j -= rowStrideC;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            --idxOther;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroC + (this.rows - 1) * rowStrideC + (this.columns - 1) * 1;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    elementsC[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideC;
                }
                idx -= this.columnStride;
                --idxOther;
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getFftColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            C.viewColumn(c).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).getFft());
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                C.viewColumn(c).assign(((DenseFloatMatrix1D)this.viewColumn(c)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getFftRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            C.viewRow(r).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).getFft());
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = this.rows;
            while (--r >= 0) {
                C.viewRow(r).assign(((DenseFloatMatrix1D)this.viewRow(r)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public FComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] elementsC = C.elements();
        final int zero = (int)this.index(0, 0);
        final int zeroC = (int)C.index(0, 0);
        final int rowStrideC = C.rowStride() / 2;
        boolean columnStrideC = true;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int idxOther = zeroC + (DenseColumnFloatMatrix2D.this.rows - 1) * rowStrideC + (firstColumn - 1) * 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsC[j] = DenseColumnFloatMatrix2D.this.elements[i];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                                j -= rowStrideC;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            --idxOther;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroC + (this.rows - 1) * rowStrideC + (this.columns - 1) * 1;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    elementsC[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideC;
                }
                idx -= this.columnStride;
                --idxOther;
            }
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public FComplexMatrix2D getIfftColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            C.viewColumn(c).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).getIfft(scale));
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                C.viewColumn(c).assign(((DenseFloatMatrix1D)this.viewColumn(c)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public FComplexMatrix2D getIfftRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            C.viewRow(r).assign(((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).getIfft(scale));
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = this.rows;
            while (--r >= 0) {
                C.viewRow(r).assign(((DenseFloatMatrix1D)this.viewRow(r)).getIfft(scale));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                float value = this.elements[i];
                if (value < 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                float value = this.elements[i];
                if (value != 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                float value = this.elements[i];
                if (value > 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public float getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        this.dct2.inverse((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).idct(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idct(scale);
            }
        }
    }

    public void idctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).idct(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idct(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        this.dht2.inverse((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).idht(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idht(scale);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).idht(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idht(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        this.dst2.inverse((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewColumn(c)).idst(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = this.columns;
            while (--c >= 0) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idst(scale);
            }
        }
    }

    public void idstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (--r >= lastRow) {
                            ((DenseFloatMatrix1D)DenseColumnFloatMatrix2D.this.viewRow(r)).idst(scale);
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idst(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft2(boolean scale) {
        FloatMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverse((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new DenseColumnFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix1D like1D(int size) {
        return new DenseFloatMatrix1D(size);
    }

    @Override
    public float[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][3];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float maxValue = DenseColumnFloatMatrix2D.this.elements[zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnFloatMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnFloatMatrix2D.this.columnStride;
                            int r = DenseColumnFloatMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                float elem = DenseColumnFloatMatrix2D.this.elements[r * DenseColumnFloatMatrix2D.this.rowStride + cidx];
                                if (!(maxValue < elem)) continue;
                                maxValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new float[]{maxValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    float elem = this.elements[r * this.rowStride + cidx];
                    if (!(maxValue < elem)) continue;
                    maxValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new float[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public float[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][3];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float minValue = DenseColumnFloatMatrix2D.this.elements[zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride];
                        int rowLocation = DenseColumnFloatMatrix2D.this.rows - 1;
                        int columnLocation = firstColumn - 1;
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnFloatMatrix2D.this.columnStride;
                            int r = DenseColumnFloatMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                float elem = DenseColumnFloatMatrix2D.this.elements[r * DenseColumnFloatMatrix2D.this.rowStride + cidx];
                                if (!(minValue > elem)) continue;
                                minValue = elem;
                                rowLocation = r;
                                columnLocation = c;
                            }
                            d = 0;
                        }
                        return new float[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            rowLocation = this.rows - 1;
            columnLocation = this.columns - 1;
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    float elem = this.elements[r * this.rowStride + cidx];
                    if (!(minValue > elem)) continue;
                    minValue = elem;
                    rowLocation = r;
                    columnLocation = c;
                }
                d = 0;
            }
        }
        return new float[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void setQuick(int row, int column, float value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public float[][] toArray() {
        final float[][] values = new float[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                values[r][c] = DenseColumnFloatMatrix2D.this.elements[i];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    values[r][c] = this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return values;
    }

    @Override
    public FloatMatrix1D vectorize() {
        int size = (int)this.size();
        DenseFloatMatrix1D v = new DenseFloatMatrix1D(size);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((FloatMatrix1D)v).elements(), 0, size);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final float[] elementsOther = (float[])((FloatMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    final int firstIdxOther = size - j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                            int idxOther = zeroOther + (firstIdxOther - 1) * strideOther;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnFloatMatrix2D.this.rows;
                                while (--r >= 0) {
                                    elementsOther[idxOther] = DenseColumnFloatMatrix2D.this.elements[i];
                                    i -= DenseColumnFloatMatrix2D.this.rowStride;
                                    idxOther -= strideOther;
                                }
                                idx -= DenseColumnFloatMatrix2D.this.columnStride;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = zeroOther + size - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        elementsOther[idxOther] = this.elements[i];
                        i -= this.rowStride;
                        --idxOther;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return v;
    }

    @Override
    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z, float alpha, float beta, boolean transposeA) {
        if (z == null) {
            z = new DenseFloatMatrix1D(transposeA ? this.columns : this.rows);
        }
        if ((long)(transposeA ? this.rows : this.columns) != y.size() || (long)(transposeA ? this.columns : this.rows) > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!(y instanceof DenseFloatMatrix1D) || !(z instanceof DenseFloatMatrix1D) || this.isView() || y.isView() || z.isView()) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        float[] yElements = (float[])y.elements();
        float[] zElements = (float[])z.elements();
        Transpose transA = transposeA ? Transpose.Transpose : Transpose.NoTranspose;
        BLAS.getInstance().sgemv(transA.netlib(), this.rows, this.columns, alpha, this.elements, Math.max(this.rows, 1), yElements, 1, beta, zElements, 1);
        return z;
    }

    @Override
    public FloatMatrix2D zMult(FloatMatrix2D B, FloatMatrix2D C, float alpha, float beta, boolean transposeA, boolean transposeB) {
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        int rowsB = transposeB ? B.columns() : B.rows();
        int columnsB = transposeB ? B.rows() : B.columns();
        int rowsC = rowsA;
        int columnsC = columnsB;
        if (columnsA != rowsB) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C == null) {
            C = new DenseColumnFloatMatrix2D(rowsC, columnsC);
        } else if (rowsA != C.rows() || columnsB != C.columns()) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(B instanceof DenseColumnFloatMatrix2D) || !(C instanceof DenseColumnFloatMatrix2D) || this.isView() || B.isView() || C.isView()) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        Transpose transA = transposeA ? Transpose.Transpose : Transpose.NoTranspose;
        Transpose transB = transposeB ? Transpose.Transpose : Transpose.NoTranspose;
        float[] elementsA = this.elements;
        float[] elementsB = (float[])B.elements();
        float[] elementsC = (float[])C.elements();
        int lda = transposeA ? Math.max(1, columnsA) : Math.max(1, rowsA);
        int ldb = transposeB ? Math.max(1, columnsB) : Math.max(1, rowsB);
        int ldc = Math.max(1, rowsA);
        BLAS.getInstance().sgemm(transA.netlib(), transB.netlib(), rowsA, columnsB, columnsA, alpha, elementsA, lda, elementsB, ldb, beta, elementsC, ldc);
        return C;
    }

    @Override
    public float zSum() {
        float sum = 0.0f;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        int idx = zero + (DenseColumnFloatMatrix2D.this.rows - 1) * DenseColumnFloatMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnFloatMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnFloatMatrix2D.this.rows;
                            while (--r >= 0) {
                                sum += DenseColumnFloatMatrix2D.this.elements[i];
                                i -= DenseColumnFloatMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnFloatMatrix2D.this.columnStride;
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Float)futures[j].get()).floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    sum += this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix2D other) {
        if (other instanceof SelectedDenseColumnFloatMatrix2D) {
            SelectedDenseColumnFloatMatrix2D otherMatrix = (SelectedDenseColumnFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnFloatMatrix2D) {
            DenseColumnFloatMatrix2D otherMatrix = (DenseColumnFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix1D like1D(int size, int zero, int stride) {
        return new DenseFloatMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected FloatMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnFloatMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

