/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long3D;
import mitiv.array.Long4D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.FlatLong3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong4D;
import mitiv.array.impl.StriddenLong3D;
import mitiv.array.impl.StriddenLong4D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.LongGenerator;

public class FlatLong4D
extends Long4D {
    static final int order = 1;
    final long[] data;
    final int dim1dim2;
    final int dim1dim2dim3;

    public FlatLong4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.data = new long[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
    }

    public FlatLong4D(int[] nArray) {
        super(nArray);
        this.data = new long[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatLong4D(Shape shape) {
        super(shape);
        this.data = new long[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatLong4D(long[] lArray, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.checkSize(lArray);
        this.data = lArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
    }

    public FlatLong4D(long[] lArray, int[] nArray) {
        super(nArray);
        this.checkSize(lArray);
        this.data = lArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatLong4D(long[] lArray, Shape shape) {
        super(shape);
        this.checkSize(lArray);
        this.data = lArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(long[] lArray) {
        if (lArray == null || lArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4) {
        return this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final long get(int n, int n2, int n3, int n4) {
        return this.data[this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, long l) {
        this.data[this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = l;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = l;
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = longGenerator.nextLong();
        }
    }

    @Override
    public void increment(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + l;
        }
    }

    @Override
    public void decrement(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - l;
        }
    }

    @Override
    public void scale(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * l;
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = longFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        longScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            longScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public long[] flatten(boolean bl) {
        if (bl) {
            long[] lArray = new long[this.number];
            System.arraycopy(this.data, 0, lArray, 0, this.number);
            return lArray;
        }
        return this.data;
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    @Override
    public Long3D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim4)) == 0) {
            return new FlatLong3D(this.data, this.dim1, this.dim2, this.dim3);
        }
        return new StriddenLong3D(this.data, this.dim1dim2dim3 * n, 1, this.dim1, this.dim1dim2, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Long3D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if ((n2 = Helper.fixSliceIndex(n2, 4)) == 0) {
            n9 = Helper.fixIndex(n, this.dim1);
            n8 = this.dim1;
            n7 = this.dim1dim2;
            n6 = this.dim1dim2dim3;
            n5 = this.dim2;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 1) {
            n9 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n8 = 1;
            n7 = this.dim1dim2;
            n6 = this.dim1dim2dim3;
            n5 = this.dim1;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 2) {
            n9 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n8 = 1;
            n7 = this.dim1;
            n6 = this.dim1dim2dim3;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim4;
        } else {
            n9 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n8 = 1;
            n7 = this.dim1;
            n6 = this.dim1dim2;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim3;
        }
        return new StriddenLong3D(this.data, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Long4D view(Range range, Range range2, Range range3, Range range4) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing()) {
            return this;
        }
        return new StriddenLong4D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber());
    }

    @Override
    public Long4D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray6 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray7 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray8 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        return new SelectedLong4D(this.data, nArray5, nArray6, nArray7, nArray8);
    }

    @Override
    public Long1D as1D() {
        return new FlatLong1D(this.data, this.number);
    }
}

