/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

public class GsmDecoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private static final int OutputSize = 160;
    private static final int InputSize = 33;
    private static final int LpcOrder = 8;
    private static final int SubFrameSize = 40;
    private static final int NumOfSubframes = 4;
    private static final int NumOfParameters = 76;
    private static final int NumOfPulses = 13;
    private static final int NumOfLarInterp = 4;
    private static final int QuantResBase = 120;
    private static final int SidFrame = 2;
    private static final int SpeechFrame = 1;
    private static final int NullFrame = 0;
    private static final float[] QLB = new float[]{0.1f, 0.35f, 0.65f, 1.0f};
    private static final int[] larInterpStart = new int[]{0, 13, 27, 40, 160};
    private static final float[][] InterpLarCoef = new float[][]{{0.75f, 0.25f}, {0.5f, 0.5f}, {0.25f, 0.75f}, {0.0f, 1.0f}};
    private static float[] xmaxTable;
    private static float[][] larTable;
    private static final int Parameter_SubFramesBase = 8;
    private static final int Parameter_SubFramesLength = 17;
    private static final int Parameter_LtpLag = 0;
    private static final int Parameter_LtpGain = 1;
    private static final int Parameter_RpeGridPosition = 2;
    private static final int Parameter_BlockAmplitude = 3;
    private static final int Parameter_RpePulsesBase = 4;
    private short[] outsig = new short[160];
    private byte[] inByteStream = new byte[33];
    private float[] prevLARpp = new float[9];
    private float[] rp = new float[9];
    private float[] u = new float[9];
    private int[] lastSID = new int[76];
    private int prevNc;
    private float prevOut;
    private float[] quantRes = new float[280];
    private int seed;
    private int[] parameters = new int[76];
    private float[] LARpp = new float[9];
    private static final int GSM_MAGIC = 13;

    private int GSMrand() {
        this.seed = this.seed * 1103515245 + 12345;
        return this.seed & Short.MAX_VALUE;
    }

    public void decoderInit() {
        this.prevNc = 40;
        this.prevOut = 0.0f;
        int i2 = 0;
        while (i2 < 9) {
            this.prevLARpp[i2] = 0.0f;
            this.rp[i2] = 0.0f;
            this.u[i2] = 0.0f;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.lastSID.length) {
            this.lastSID[i3] = 0;
            ++i3;
        }
        this.lastSID[0] = 2;
        this.lastSID[1] = 28;
        this.lastSID[2] = 18;
        this.lastSID[3] = 12;
        this.lastSID[4] = 7;
        this.lastSID[5] = 5;
        this.lastSID[6] = 3;
        this.lastSID[7] = 2;
        int i4 = 0;
        while (i4 < this.quantRes.length) {
            this.quantRes[i4] = 0.0f;
            ++i4;
        }
        this.seed = 1;
    }

    public boolean decodeFrame(byte[] src, int srcoffset, byte[] dst, int dstoffset) {
        int j2;
        int subFrameNumber;
        int[] parameters = this.parameters;
        int[] lastSID = this.lastSID;
        float[] LARpp = this.LARpp;
        float[] u = this.u;
        float[] rp = this.rp;
        float[] prevLARpp = this.prevLARpp;
        float[] quantRes = this.quantRes;
        System.arraycopy(quantRes, 160, quantRes, 0, 120);
        if (!this.UnpackBitStream(src, srcoffset, parameters)) {
            return false;
        }
        int frameType = 0;
        int i2 = 0;
        while (i2 < 76) {
            if (0 != parameters[i2]) {
                frameType = 2;
                break;
            }
            ++i2;
        }
        if (frameType == 0) {
            System.arraycopy(lastSID, 0, parameters, 0, 76);
            frameType = 2;
        } else {
            subFrameNumber = 0;
            while (subFrameNumber < 4) {
                int subFramePulseBase = subFrameNumber * 17 + 8 + 4;
                j2 = 0;
                while (j2 < 13) {
                    if (parameters[subFramePulseBase + j2] != 0) {
                        frameType = 1;
                        subFrameNumber = 4;
                        break;
                    }
                    ++j2;
                }
                ++subFrameNumber;
            }
            if (frameType == 2) {
                System.arraycopy(parameters, 0, lastSID, 0, 76);
            }
        }
        if (frameType == 2) {
            subFrameNumber = 0;
            while (subFrameNumber < 4) {
                int subFrameParamBase = subFrameNumber * 17 + 8;
                j2 = 0;
                while (j2 < 13) {
                    parameters[subFrameParamBase + 4 + j2] = this.GSMrand() / 5461 + 1;
                    ++j2;
                }
                parameters[subFrameParamBase + 2] = this.GSMrand() / 10923;
                parameters[subFrameParamBase + 1] = 0;
                parameters[subFrameParamBase + 0] = subFrameNumber == 0 | subFrameNumber == 2 ? 40 : 120;
                ++subFrameNumber;
            }
        }
        int subFrameNumber2 = 0;
        while (subFrameNumber2 < 4) {
            int subFrameParamBase = subFrameNumber2 * 17 + 8;
            int tempLtpLag = parameters[subFrameParamBase + 0];
            if (tempLtpLag >= 40 && tempLtpLag <= 120) {
                this.prevNc = tempLtpLag;
            }
            float ltpGain = QLB[parameters[subFrameParamBase + 1]];
            int rpeGridPos = parameters[subFrameParamBase + 2];
            float xmaxp = xmaxTable[parameters[subFrameParamBase + 3]];
            int subFrameResidualBase = subFrameNumber2 * 40 + 120;
            int i3 = 0;
            while (i3 < 40) {
                quantRes[subFrameResidualBase + i3] = ltpGain * quantRes[subFrameResidualBase + i3 - this.prevNc];
                ++i3;
            }
            int i4 = 0;
            while (i4 < 13) {
                int n2 = subFrameResidualBase + rpeGridPos + 3 * i4;
                quantRes[n2] = (float)((double)quantRes[n2] + (0.25 * (double)parameters[subFrameParamBase + 4 + i4] - 0.875) * (double)xmaxp);
                ++i4;
            }
            ++subFrameNumber2;
        }
        int larNum = 0;
        while (larNum < 8) {
            LARpp[larNum + 1] = larTable[larNum][parameters[larNum]];
            ++larNum;
        }
        float prevOut = this.prevOut;
        int larInterpNumber = 0;
        while (larInterpNumber < 4) {
            int i5 = 1;
            while (i5 <= 8) {
                float LARpi = prevLARpp[i5] * InterpLarCoef[larInterpNumber][0] + LARpp[i5] * InterpLarCoef[larInterpNumber][1];
                rp[i5] = (double)Math.abs(LARpi) < 0.675 ? LARpi : ((double)Math.abs(LARpi) < 1.225 ? (LARpi > 0.0f ? 1.0f : -1.0f) * (0.5f * Math.abs(LARpi) + 0.3375f) : (LARpi > 0.0f ? 1.0f : -1.0f) * (0.125f * Math.abs(LARpi) + 0.796875f));
                ++i5;
            }
            int outCount = larInterpStart[larInterpNumber];
            while (outCount < larInterpStart[larInterpNumber + 1]) {
                float temp = quantRes[120 + outCount];
                u[8] = u[7] + rp[8] * (temp -= rp[8] * u[7]);
                u[7] = u[6] + rp[7] * (temp -= rp[7] * u[6]);
                u[6] = u[5] + rp[6] * (temp -= rp[6] * u[5]);
                u[5] = u[4] + rp[5] * (temp -= rp[5] * u[4]);
                u[4] = u[3] + rp[4] * (temp -= rp[4] * u[3]);
                u[3] = u[2] + rp[3] * (temp -= rp[3] * u[2]);
                u[2] = u[1] + rp[2] * (temp -= rp[2] * u[1]);
                u[1] = u[0] + rp[1] * (temp -= rp[1] * u[0]);
                prevOut = temp + prevOut * 0.85998535f;
                u[0] = temp;
                temp = 65532.0f * prevOut;
                if (temp > 32766.0f) {
                    temp = 32766.0f;
                }
                if (temp < -32766.0f) {
                    temp = -32766.0f;
                }
                this.outsig[outCount] = (short)temp;
                ++outCount;
            }
            ++larInterpNumber;
        }
        int i6 = 1;
        while (i6 <= 8) {
            prevLARpp[i6] = LARpp[i6];
            ++i6;
        }
        this.prevOut = prevOut;
        int dstIndex = 0;
        int i7 = 0;
        while (i7 < 160) {
            short TempInt = this.outsig[i7];
            dst[dstoffset + dstIndex++] = (byte)(TempInt & 0xFF);
            dst[dstoffset + dstIndex++] = (byte)(TempInt >> 8);
            ++i7;
        }
        return true;
    }

    protected boolean UnpackBitStream(byte[] inByteStream, int inputIndex, int[] Parameters) {
        int paramIndex = 0;
        if ((inByteStream[inputIndex] >> 4 & 0xF) != 13) {
            return false;
        }
        Parameters[paramIndex++] = (inByteStream[inputIndex] & 0xF) << 2 | inByteStream[++inputIndex] >> 6 & 3;
        Parameters[paramIndex++] = inByteStream[inputIndex] & 0x3F;
        Parameters[paramIndex++] = inByteStream[++inputIndex] >> 3 & 0x1F;
        Parameters[paramIndex++] = (inByteStream[inputIndex] & 7) << 2 | inByteStream[++inputIndex] >> 6 & 3;
        Parameters[paramIndex++] = inByteStream[inputIndex] >> 2 & 0xF;
        Parameters[paramIndex++] = (inByteStream[inputIndex] & 3) << 2 | inByteStream[++inputIndex] >> 6 & 3;
        Parameters[paramIndex++] = inByteStream[inputIndex] >> 3 & 7;
        Parameters[paramIndex++] = inByteStream[inputIndex] & 7;
        ++inputIndex;
        int n2 = 0;
        while (n2 < 4) {
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 1 & 0x7F;
            Parameters[paramIndex++] = (inByteStream[inputIndex] & 1) << 1 | inByteStream[++inputIndex] >> 7 & 1;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 5 & 3;
            Parameters[paramIndex++] = (inByteStream[inputIndex] & 0x1F) << 1 | inByteStream[++inputIndex] >> 7 & 1;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 4 & 7;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 1 & 7;
            Parameters[paramIndex++] = (inByteStream[inputIndex] & 1) << 2 | inByteStream[++inputIndex] >> 6 & 3;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 3 & 7;
            Parameters[paramIndex++] = inByteStream[inputIndex] & 7;
            Parameters[paramIndex++] = inByteStream[++inputIndex] >> 5 & 7;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 2 & 7;
            Parameters[paramIndex++] = (inByteStream[inputIndex] & 3) << 1 | inByteStream[++inputIndex] >> 7 & 1;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 4 & 7;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 1 & 7;
            Parameters[paramIndex++] = (inByteStream[inputIndex] & 1) << 2 | inByteStream[++inputIndex] >> 6 & 3;
            Parameters[paramIndex++] = inByteStream[inputIndex] >> 3 & 7;
            Parameters[paramIndex++] = inByteStream[inputIndex] & 7;
            ++inputIndex;
            ++n2;
        }
        return true;
    }

    static {
        short[] B = new short[]{0, 0, 2048, -2560, 94, -1792, -341, -1144};
        short[] MIC = new short[]{-32, -32, -16, -16, -8, -8, -4, -4};
        short[] INVA = new short[]{13107, 13107, 13107, 13107, 19223, 17476, 31454, 29708};
        xmaxTable = new float[64];
        int xmaxc = 0;
        while (xmaxc < 64) {
            int xmaxp;
            if (xmaxc < 16) {
                xmaxp = 31 + (xmaxc << 5);
            } else {
                int exp = xmaxc - 16 >> 3;
                xmaxp = (576 << exp) - 1 + (xmaxc - 16 - 8 * exp) * (64 << exp);
            }
            GsmDecoder.xmaxTable[xmaxc] = (float)xmaxp / 32768.0f;
            ++xmaxc;
        }
        larTable = new float[8][];
        int larNum = 0;
        while (larNum < 8) {
            GsmDecoder.larTable[larNum] = new float[-MIC[larNum] * 2];
            int larQuant = 0;
            while (larQuant < -MIC[larNum] * 2) {
                short temp = (short)((larQuant + MIC[larNum] << 10) - B[larNum] * 2);
                temp = (short)((long)(temp * INVA[larNum]) + 16384L >> 15);
                GsmDecoder.larTable[larNum][larQuant] = (float)(temp * 2) / 16384.0f;
                ++larQuant;
            }
            ++larNum;
        }
    }
}

