/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected long[] values;
    protected boolean rowIndexesSorted;

    public SparseCCLongMatrix2D(long[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public SparseCCLongMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseCCLongMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.rowIndexes = new int[nzmax];
        this.values = new long[nzmax];
        this.columnPointers = new int[columns + 1];
    }

    public SparseCCLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long value, boolean removeDuplicates, boolean sortRowIndexes) {
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0L) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new long[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        int k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.columnPointers, w, columns);
        k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = value;
            ++k;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    public SparseCCLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortRowIndexes) {
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.rowIndexes = new int[nz];
        this.values = new long[nz];
        this.columnPointers = new int[columns + 1];
        int[] w = new int[columns];
        int k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.columnPointers, w, columns);
        k = 0;
        while (k < nz) {
            int n = columnIndexes[k];
            w[n] = w[n] + 1;
            this.rowIndexes[r] = rowIndexes[k];
            this.values[r] = values[k];
            ++k;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortRowIndexes) {
            this.sortRowIndexes();
        }
    }

    @Override
    public LongMatrix2D assign(final LongFunction function) {
        if (function instanceof LongMult) {
            long alpha = ((LongMult)function).multiplicator;
            if (alpha == 1L) {
                return this;
            }
            if (alpha == 0L) {
                return this.assign(0L);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            long[] valuesE = this.values;
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                valuesE[n] = valuesE[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(long value) {
        if (value == 0L) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0L);
        } else {
            int nnz = this.cardinality();
            int i = 0;
            while (i < nnz) {
                this.values[i] = value;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D other = (SparseCCLongMatrix2D)source;
            System.arraycopy(other.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int nzmax = other.getRowIndexes().length;
            if (this.rowIndexes.length < nzmax) {
                this.rowIndexes = new int[nzmax];
                this.values = new long[nzmax];
            }
            System.arraycopy(other.getRowIndexes(), 0, this.rowIndexes, 0, nzmax);
            System.arraycopy(other.getValues(), 0, this.values, 0, nzmax);
            this.rowIndexesSorted = other.rowIndexesSorted;
        } else if (source instanceof SparseRCLongMatrix2D) {
            SparseRCLongMatrix2D other = ((SparseRCLongMatrix2D)source).getTranspose();
            this.columnPointers = other.getRowPointers();
            this.rowIndexes = other.getColumnIndexes();
            this.values = other.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign(0L);
            source.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseCCLongMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D y, LongLongFunction function) {
        this.checkShape(y);
        if (y instanceof SparseCCLongMatrix2D && function == LongFunctions.plus) {
            SparseCCLongMatrix2D yy = (SparseCCLongMatrix2D)y;
            int nz = 0;
            int m = this.rows;
            int anz = this.columnPointers[this.columns];
            int n = yy.columns;
            int[] Bp = yy.columnPointers;
            int bnz = Bp[n];
            int[] w = new int[m];
            long[] x = new long[m];
            SparseCCLongMatrix2D C = new SparseCCLongMatrix2D(m, n, anz + bnz);
            int[] Cp = C.columnPointers;
            int[] Ci = C.rowIndexes;
            long[] Cx = C.values;
            int j = 0;
            while (j < n) {
                Cp[j] = nz;
                nz = this.scatter(this, j, 1L, w, x, j + 1, C, nz);
                nz = this.scatter(yy, j, 1L, w, x, j + 1, C, nz);
                int p = Cp[j];
                while (p < nz) {
                    Cx[p] = x[Ci[p]];
                    ++p;
                }
                ++j;
            }
            Cp[n] = nz;
            this.rowIndexes = Ci;
            this.columnPointers = Cp;
            this.values = Cx;
            return this;
        }
        if (function instanceof LongPlusMultSecond) {
            final long alpha = ((LongPlusMultSecond)function).multiplicator;
            if (alpha == 0L) {
                return this;
            }
            y.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseCCLongMatrix2D.this.setQuick(i, j, SparseCCLongMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof LongPlusMultFirst) {
            final long alpha = ((LongPlusMultFirst)function).multiplicator;
            if (alpha == 0L) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseCCLongMatrix2D.this.setQuick(i, j, alpha * SparseCCLongMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == LongFunctions.mult) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            long[] valuesA = this.values;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] * y.getQuick(i, j);
                    if (valuesA[k] != 0L) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == LongFunctions.div) {
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            long[] valuesA = this.values;
            int j = this.columns;
            while (--j >= 0) {
                int low = columnPointersA[j];
                int k = columnPointersA[j + 1];
                while (--k >= low) {
                    int i = rowIndexesA[k];
                    int n = k;
                    valuesA[n] = valuesA[n] / y.getQuick(i, j);
                    if (valuesA[k] != 0L) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    @Override
    public LongMatrix2D forEachNonZero(IntIntLongFunction function) {
        int[] rowIndexesA = this.rowIndexes;
        int[] columnPointersA = this.columnPointers;
        long[] valuesA = this.values;
        int j = this.columns;
        while (--j >= 0) {
            int low = columnPointersA[j];
            int k = columnPointersA[j + 1];
            while (--k >= low) {
                long r;
                int i = rowIndexesA[k];
                long value = valuesA[k];
                valuesA[k] = r = function.apply(i, j, value);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseLongMatrix2D getDense() {
        final DenseLongMatrix2D dense = new DenseLongMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntLongFunction(){

            @Override
            public long apply(int i, int j, long value) {
                dense.setQuick(i, j, SparseCCLongMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized long getQuick(int row, int column) {
        int k = SparseCCLongMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        long v = 0L;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public SparseRCLongMatrix2D getRowCompressed() {
        SparseCCLongMatrix2D tr = this.getTranspose();
        SparseRCLongMatrix2D rc = new SparseRCLongMatrix2D(this.rows, this.columns);
        rc.columnIndexes = tr.rowIndexes;
        rc.rowPointers = tr.columnPointers;
        rc.values = tr.values;
        rc.columnIndexesSorted = true;
        return rc;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCLongMatrix2D getTranspose() {
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        long[] Ax = this.values;
        SparseCCLongMatrix2D C = new SparseCCLongMatrix2D(this.columns, this.rows, Ai.length);
        int[] w = new int[m];
        int[] Cp = C.columnPointers;
        int[] Ci = C.rowIndexes;
        long[] Cx = C.values;
        int p = 0;
        while (p < Ap[n]) {
            int n2 = Ai[p];
            w[n2] = w[n2] + 1;
            ++p;
        }
        this.cumsum(Cp, w, m);
        int j = 0;
        while (j < n) {
            p = Ap[j];
            while (p < Ap[j + 1]) {
                int n3 = Ai[p];
                w[n3] = w[n3] + 1;
                Ci[q] = j;
                Cx[q] = Ax[p];
                ++p;
            }
            ++j;
        }
        return C;
    }

    public long[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseCCLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new SparseLongMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, long value) {
        int k = SparseCCLongMatrix2D.searchFromTo(this.rowIndexes, row, this.columnPointers[column], this.columnPointers[column + 1] - 1);
        if (k >= 0) {
            if (value == 0L) {
                this.remove(column, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != 0L) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortRowIndexes() {
        SparseCCLongMatrix2D tr = this.getTranspose();
        tr = tr.getTranspose();
        this.columnPointers = tr.columnPointers;
        this.rowIndexes = tr.rowIndexes;
        this.values = tr.values;
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        int nz = 0;
        int m = this.rows;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        long[] Ax = this.values;
        int[] w = new int[m];
        int i = 0;
        while (i < m) {
            w[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int q = nz;
            int p = Ap[j];
            while (p < Ap[j + 1]) {
                i = Ai[p];
                if (w[i] >= q) {
                    int n2 = w[i];
                    Ax[n2] = Ax[n2] + Ax[p];
                } else {
                    w[i] = nz;
                    Ai[nz] = i;
                    Ax[nz++] = Ax[p];
                }
                ++p;
            }
            Ap[j] = q;
            ++j;
        }
        Ap[n] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        int n = this.columns;
        int[] Ap = this.columnPointers;
        int[] Ai = this.rowIndexes;
        long[] Ax = this.values;
        int j = 0;
        while (j < n) {
            int p = Ap[j];
            Ap[j] = nz;
            while (p < Ap[j + 1]) {
                if (Ax[p] != 0L) {
                    Ax[nz] = Ax[p];
                    Ai[nz++] = Ai[p];
                }
                ++p;
            }
            ++j;
        }
        Ap[n] = nz;
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int i = 0;
        while (i < this.columns) {
            int high = this.columnPointers[i + 1];
            int j = this.columnPointers[i];
            while (j < high) {
                builder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
                ++j;
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z, final long alpha, final long beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || transposeA;
        if (z == null) {
            z = new DenseLongMatrix1D(rowsA);
        }
        if (!(y instanceof DenseLongMatrix1D) || !(z instanceof DenseLongMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseLongMatrix1D zz = (DenseLongMatrix1D)z;
        final long[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)zz.index(0);
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        final long[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)yy.index(0);
        final int[] rowIndexesA = this.rowIndexes;
        final int[] columnPointersA = this.columnPointers;
        final long[] valuesA = this.values;
        int zidx = zeroZ;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (!transposeA) {
            if (!ignore && beta != 1L) {
                z.assign(LongFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final long[] result = new long[rowsA];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (threadID == 0) {
                                int i = firstColumn;
                                while (i < lastColumn) {
                                    int high = columnPointersA[i + 1];
                                    long yElem = elementsY[zeroY + strideY * i];
                                    int k = columnPointersA[i];
                                    while (k < high) {
                                        int j = rowIndexesA[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + alpha * valuesA[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            } else {
                                int i = firstColumn;
                                while (i < lastColumn) {
                                    int high = columnPointersA[i + 1];
                                    long yElem = elementsY[zeroY + strideY * i];
                                    int k = columnPointersA[i];
                                    while (k < high) {
                                        int j;
                                        int n = j = rowIndexesA[k];
                                        result[n] = result[n] + alpha * valuesA[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                int j2 = rem = rowsA % 10;
                while (j2 < rowsA) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    int n2 = zeroZ + (j2 + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j2 + 1];
                    int n3 = zeroZ + (j2 + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j2 + 2];
                    int n4 = zeroZ + (j2 + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j2 + 3];
                    int n5 = zeroZ + (j2 + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j2 + 4];
                    int n6 = zeroZ + (j2 + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j2 + 5];
                    int n7 = zeroZ + (j2 + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j2 + 6];
                    int n8 = zeroZ + (j2 + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j2 + 7];
                    int n9 = zeroZ + (j2 + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j2 + 8];
                    int n10 = zeroZ + (j2 + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j2 + 9];
                    j2 += 10;
                }
                j2 = 0;
                while (j2 < rem) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    ++j2;
                }
            } else {
                int i = 0;
                while (i < this.columns) {
                    int high = columnPointersA[i + 1];
                    long yElem = elementsY[zeroY + strideY * i];
                    int k = columnPointersA[i];
                    while (k < high) {
                        int j = rowIndexesA[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + alpha * valuesA[k] * yElem;
                        ++k;
                    }
                    ++i;
                }
            }
        } else if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstColumn * strideZ;
                        int k = SparseCCLongMatrix2D.this.columnPointers[firstColumn];
                        int i = firstColumn;
                        while (i < lastColumn) {
                            long sum = 0L;
                            int high = SparseCCLongMatrix2D.this.columnPointers[i + 1];
                            while (k + 10 < high) {
                                int ind = k + 9;
                                sum += valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * SparseCCLongMatrix2D.this.rowIndexes[ind--]];
                                k += 10;
                            }
                            while (k < high) {
                                sum += valuesA[k] * elementsY[SparseCCLongMatrix2D.this.rowIndexes[k]];
                                ++k;
                            }
                            elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                            zidx += strideZ;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int k = this.columnPointers[0];
            int i = 0;
            while (i < this.columns) {
                long sum = 0L;
                int high = this.columnPointers[i + 1];
                while (k + 10 < high) {
                    int ind = k + 9;
                    sum += valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]] + valuesA[ind] * elementsY[zeroY + strideY * this.rowIndexes[ind--]];
                    k += 10;
                }
                while (k < high) {
                    sum += valuesA[k] * elementsY[this.rowIndexes[k]];
                    ++k;
                }
                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                zidx += strideZ;
                ++i;
            }
        }
        return z;
    }

    @Override
    public LongMatrix2D zMult(LongMatrix2D B, LongMatrix2D C, long alpha, long beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseCCLongMatrix2D ? new SparseCCLongMatrix2D(rowsA, p, rowsA * p) : new DenseLongMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && (double)beta != 1.0) {
            C.assign(LongFunctions.mult(beta));
        }
        if (B instanceof DenseLongMatrix2D && C instanceof DenseLongMatrix2D) {
            SparseCCLongMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseLongMatrix2D BB = transposeB ? (DenseLongMatrix2D)B.viewDice() : (DenseLongMatrix2D)B;
            DenseLongMatrix2D CC = (DenseLongMatrix2D)C;
            int[] columnPointersA = AA.columnPointers;
            int[] rowIndexesA = AA.rowIndexes;
            long[] valuesA = AA.values;
            int zeroB = (int)BB.index(0, 0);
            int rowStrideB = BB.rowStride();
            int columnStrideB = BB.columnStride();
            long[] elementsB = BB.elements;
            int zeroC = (int)CC.index(0, 0);
            int rowStrideC = CC.rowStride();
            int columnStrideC = CC.columnStride();
            long[] elementsC = CC.elements;
            int jj = 0;
            while (jj < columnsB) {
                int kk = 0;
                while (kk < columnsA) {
                    int high = columnPointersA[kk + 1];
                    long yElem = elementsB[zeroB + kk * rowStrideB + jj * columnStrideB];
                    int ii = columnPointersA[kk];
                    while (ii < high) {
                        int j = rowIndexesA[ii];
                        int n = zeroC + j * rowStrideC + jj * columnStrideC;
                        elementsC[n] = elementsC[n] + valuesA[ii] * yElem;
                        ++ii;
                    }
                    ++kk;
                }
                ++jj;
            }
            if ((double)alpha != 1.0) {
                C.assign(LongFunctions.mult(alpha));
            }
        } else if (B instanceof SparseCCLongMatrix2D && C instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseCCLongMatrix2D BB = (SparseCCLongMatrix2D)B;
            if (transposeB) {
                BB = BB.getTranspose();
            }
            SparseCCLongMatrix2D CC = (SparseCCLongMatrix2D)C;
            int nz = 0;
            int m = rowsA;
            int n = columnsB;
            int[] Bp = BB.columnPointers;
            int[] Bi = BB.rowIndexes;
            long[] Bx = BB.values;
            int[] w = new int[m];
            long[] x = new long[m];
            int[] Cp = CC.columnPointers;
            int[] Ci = CC.rowIndexes;
            long[] Cx = CC.values;
            int j = 0;
            while (j < n) {
                int nzmaxC = CC.rowIndexes.length;
                if (nz + m > nzmaxC) {
                    nzmaxC = 2 * nzmaxC + m;
                    int[] rowIndexesNew = new int[nzmaxC];
                    System.arraycopy(Ci, 0, rowIndexesNew, 0, Ci.length);
                    Ci = rowIndexesNew;
                    long[] valuesNew = new long[nzmaxC];
                    System.arraycopy(Cx, 0, valuesNew, 0, Cx.length);
                    Cx = valuesNew;
                }
                Cp[j] = nz;
                p = Bp[j];
                while (p < Bp[j + 1]) {
                    nz = this.scatter(AA, Bi[p], Bx[p], w, x, j + 1, CC, nz);
                    ++p;
                }
                p = Cp[j];
                while (p < nz) {
                    Cx[p] = x[Ci[p]];
                    ++p;
                }
                ++j;
            }
            Cp[n] = nz;
            if ((double)alpha != 1.0) {
                CC.assign(LongFunctions.mult(alpha));
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            LongMatrix1D[] Brows = new LongMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            LongMatrix1D[] Crows = new LongMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            LongPlusMultSecond fun = LongPlusMultSecond.plusMult(0L);
            int[] rowIndexesA = this.rowIndexes;
            int[] columnPointersA = this.columnPointers;
            long[] valuesA = this.values;
            int i3 = this.columns;
            while (--i3 >= 0) {
                int low = columnPointersA[i3];
                int k = columnPointersA[i3 + 1];
                while (--k >= low) {
                    int j = rowIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[j].assign(Brows[i3], fun);
                        continue;
                    }
                    Crows[i3].assign(Brows[j], fun);
                }
            }
        }
        return C;
    }

    @Override
    protected LongMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, long value) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        rowIndexesList.setSizeRaw(this.columnPointers[this.columns]);
        LongArrayList valuesList = new LongArrayList(this.values);
        valuesList.setSizeRaw(this.columnPointers[this.columns]);
        rowIndexesList.beforeInsert(index, row);
        valuesList.beforeInsert(index, value);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int column, int index) {
        IntArrayList rowIndexesList = new IntArrayList(this.rowIndexes);
        LongArrayList valuesList = new LongArrayList(this.values);
        rowIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.columnPointers.length;
        while (--i > column) {
            int n = i;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
        this.rowIndexes = rowIndexesList.elements();
        this.values = valuesList.elements();
    }

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    private long cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        long nz2 = 0L;
        int k = 0;
        while (k < n) {
            p[k] = nz;
            nz += c[k];
            nz2 += (long)c[k];
            c[k] = p[k];
            ++k;
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.columnPointers[this.columns];
        }
        int[] rowIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, rowIndexesNew, 0, length);
        this.rowIndexes = rowIndexesNew;
        long[] valuesNew = new long[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    private int scatter(SparseCCLongMatrix2D A, int j, long beta, int[] w, long[] x, int mark, SparseCCLongMatrix2D C, int nz) {
        int[] Ap = A.columnPointers;
        int[] Ai = A.rowIndexes;
        long[] Ax = A.values;
        int[] Ci = C.rowIndexes;
        int p = Ap[j];
        while (p < Ap[j + 1]) {
            int i = Ai[p];
            if (w[i] < mark) {
                w[i] = mark;
                Ci[nz++] = i;
                if (x != null) {
                    x[i] = beta * Ax[p];
                }
            } else if (x != null) {
                int n = i;
                x[n] = x[n] + beta * Ax[p];
            }
            ++p;
        }
        return nz;
    }
}

