/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;

public class DoubleSSOR
implements DoublePreconditioner {
    private double omegaF;
    private double omegaR;
    private SparseRCDoubleMatrix2D F;
    private final int[] diagind;
    private final double[] xx;
    private final boolean reverse;
    private final int n;

    public DoubleSSOR(int n, boolean reverse, double omegaF, double omegaR) {
        this.n = n;
        this.reverse = reverse;
        this.setOmega(omegaF, omegaR);
        this.diagind = new int[n];
        this.xx = new double[n];
    }

    public DoubleSSOR(int n) {
        this(n, true, 1.0, 1.0);
    }

    public void setOmega(double omegaF, double omegaR) {
        if (omegaF < 0.0 || omegaF > 2.0) {
            throw new IllegalArgumentException("omegaF must be between 0 and 2");
        }
        if (omegaR < 0.0 || omegaR > 2.0) {
            throw new IllegalArgumentException("omegaR must be between 0 and 2");
        }
        this.omegaF = omegaF;
        this.omegaR = omegaR;
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.F = new SparseRCDoubleMatrix2D(this.n, this.n);
        this.F.assign(A);
        if (!this.F.hasColumnIndexesSorted()) {
            this.F.sortColumnIndexes();
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndexes();
        int k = 0;
        while (k < this.n) {
            this.diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (this.diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal on row " + (k + 1));
            }
            ++k;
        }
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        int j;
        double sigma;
        if (x == null) {
            x = b.like();
        }
        if (!(b instanceof DenseDoubleMatrix1D) || !(x instanceof DenseDoubleMatrix1D)) {
            throw new IllegalArgumentException("b and x must be a DenseDoubleMatrix1D");
        }
        int[] rowptr = this.F.getRowPointers();
        int[] colind = this.F.getColumnIndexes();
        double[] data = this.F.getValues();
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = new double[(int)x.size()];
        int n = this.F.rows();
        System.arraycopy(xd, 0, this.xx, 0, n);
        int i = 0;
        while (i < n) {
            sigma = 0.0;
            j = rowptr[i];
            while (j < this.diagind[i]) {
                sigma += data[j] * this.xx[colind[j]];
                ++j;
            }
            j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sigma += data[j] * xd[colind[j]];
                ++j;
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            this.xx[i] = xd[i] + this.omegaF * (sigma - xd[i]);
            ++i;
        }
        if (!this.reverse) {
            System.arraycopy(this.xx, 0, xd, 0, n);
            x.assign(xd);
            return x;
        }
        i = n - 1;
        while (i >= 0) {
            sigma = 0.0;
            j = rowptr[i];
            while (j < this.diagind[i]) {
                sigma += data[j] * this.xx[colind[j]];
                ++j;
            }
            j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sigma += data[j] * xd[colind[j]];
                ++j;
            }
            sigma = (bd[i] - sigma) / data[this.diagind[i]];
            xd[i] = this.xx[i] + this.omegaR * (sigma - this.xx[i]);
            --i;
        }
        x.assign(xd);
        return x;
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }
}

