/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.lang.reflect.Array;
import java.util.Locale;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Traits;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.shaped.ShapedVector;

public class ArrayReflection {
    public static Class<?> deepComponentType(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static int getDepth(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        return n;
    }

    public static long countElements(Object object) {
        if (object == null) {
            return 0L;
        }
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return 1L;
        }
        int n = Array.getLength(object);
        if (clazz.isArray()) {
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                l += ArrayReflection.countElements(Array.get(object, i));
            }
            return l;
        }
        return n;
    }

    public static int recursiveCopy(Object object, int n, Object object2) {
        if (object2 != null) {
            Class<?> clazz = object2.getClass().getComponentType();
            if (clazz == null) {
                Array.set(object, n++, object2);
            } else {
                int n2 = Array.getLength(object2);
                if (clazz.isArray()) {
                    for (int i = 0; i < n2; ++i) {
                        n = ArrayReflection.recursiveCopy(object, n, Array.get(object2, i));
                    }
                } else {
                    System.arraycopy(object2, 0, object, n, n2);
                    n += n2;
                }
            }
        }
        return n;
    }

    public static Object flatten(Object object) {
        return ArrayReflection.flatten(object, false);
    }

    public static Object flatten(Object object, boolean bl) {
        Object object2;
        if (!bl && ((Class)(object2 = object.getClass())).isArray() && !((Class)object2).getComponentType().isArray()) {
            return object;
        }
        object2 = null;
        long l = ArrayReflection.countElements(object);
        int n = (int)l;
        if ((long)n != l) {
            throw new IndexOutOfBoundsException("Too many components to store in a flat array");
        }
        object2 = Array.newInstance(ArrayReflection.deepComponentType(object), n);
        ArrayReflection.recursiveCopy(object2, 0, object);
        return object2;
    }

    public static Object flatten(boolean bl) {
        return new boolean[]{bl};
    }

    public static Object flatten(char c) {
        return new char[]{c};
    }

    public static Object flatten(byte by) {
        return new byte[]{by};
    }

    public static Object flatten(short s) {
        return new short[]{s};
    }

    public static Object flatten(int n) {
        return new int[]{n};
    }

    public static Object flatten(long l) {
        return new long[]{l};
    }

    public static Object flatten(float f) {
        return new float[]{f};
    }

    public static Object flatten(double d) {
        return new double[]{d};
    }

    public static Object flatten(boolean bl, boolean bl2) {
        return new boolean[]{bl};
    }

    public static Object flatten(char c, boolean bl) {
        return new char[]{c};
    }

    public static Object flatten(byte by, boolean bl) {
        return new byte[]{by};
    }

    public static Object flatten(short s, boolean bl) {
        return new short[]{s};
    }

    public static Object flatten(int n, boolean bl) {
        return new int[]{n};
    }

    public static Object flatten(long l, boolean bl) {
        return new long[]{l};
    }

    public static Object flatten(float f, boolean bl) {
        return new float[]{f};
    }

    public static Object flatten(double d, boolean bl) {
        return new double[]{d};
    }

    private static void checkLengths(Object object, int[] nArray, int n) {
        if (n >= 1) {
            int n2 = nArray[n];
            int n3 = nArray[n - 1];
            for (int i = 0; i < n2; ++i) {
                Object object2 = Array.get(object, i);
                if (object2 == null) {
                    ArrayReflection.emptyDimension();
                }
                if (Array.getLength(object2) != n3) {
                    ArrayReflection.nonRectangular();
                }
                if (n < 2) continue;
                ArrayReflection.checkLengths(object2, nArray, n - 1);
            }
        }
    }

    public static ArrayDescriptor makeArrayDescriptor(Object object) {
        int n;
        Class<?> clazz = object.getClass();
        int n2 = 0;
        int[] nArray = null;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n2;
        }
        if (n2 == 0) {
            nArray = null;
        } else {
            nArray = new int[n2];
            n = n2;
            Object object2 = object;
            while (true) {
                nArray[--n] = Array.getLength(object2);
                if (n <= 0) break;
                if ((object2 = Array.get(object2, 0)) != null) continue;
                ArrayReflection.emptyDimension();
            }
            ArrayReflection.checkLengths(object, nArray, n2 - 1);
        }
        if (clazz.equals(Byte.TYPE)) {
            n = 0;
        } else if (clazz.equals(Short.TYPE)) {
            n = 1;
        } else if (clazz.equals(Integer.TYPE)) {
            n = 2;
        } else if (clazz.equals(Long.TYPE)) {
            n = 3;
        } else if (clazz.equals(Float.TYPE)) {
            n = 4;
        } else if (clazz.equals(Double.TYPE)) {
            n = 5;
        } else {
            throw new IllegalTypeException("Only numerical primitive types are supported");
        }
        return new ArrayDescriptor(n, nArray);
    }

    public ShapedArray makeShapedArray(ShapedArray shapedArray) {
        return shapedArray;
    }

    public ShapedArray makeShapedArray(ShapedVector shapedVector) {
        return shapedVector.asShapedArray();
    }

    public ShapedArray makeShapedArray(Object object) {
        ArrayDescriptor arrayDescriptor = ArrayReflection.makeArrayDescriptor(object);
        Object object2 = ArrayReflection.flatten(object);
        switch (arrayDescriptor.getType()) {
            case 0: {
                return ArrayFactory.wrap((byte[])object2, arrayDescriptor.getShape());
            }
            case 1: {
                return ArrayFactory.wrap((short[])object2, arrayDescriptor.getShape());
            }
            case 2: {
                return ArrayFactory.wrap((int[])object2, arrayDescriptor.getShape());
            }
            case 3: {
                return ArrayFactory.wrap((long[])object2, arrayDescriptor.getShape());
            }
            case 4: {
                return ArrayFactory.wrap((float[])object2, arrayDescriptor.getShape());
            }
            case 5: {
                return ArrayFactory.wrap((double[])object2, arrayDescriptor.getShape());
            }
        }
        throw new IllegalTypeException("Only numerical primitive types are supported");
    }

    private static void emptyDimension() {
        throw new IllegalArgumentException("Arrays with empty dimension(s) are not supported");
    }

    private static void nonRectangular() {
        throw new IllegalArgumentException("Only rectangular arrays are supported");
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        Locale.setDefault(Locale.US);
        int n5 = 7;
        int n6 = 8;
        int n7 = 9;
        int[][][] nArray = new int[n7][n6][];
        for (n4 = 0; n4 < n7; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                nArray[n4][n3] = new int[n5];
            }
        }
        n3 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            for (n2 = 0; n2 < n6; ++n2) {
                for (n = 0; n < n5; ++n) {
                    nArray[n4][n2][n] = n3++;
                }
            }
        }
        String string = nArray.getClass().getName();
        System.out.println("isArray: " + (nArray.getClass().isArray() ? "true" : "false"));
        System.out.format("rank: %d\n", Array.getLength(nArray));
        System.out.println(ArrayReflection.deepComponentType(nArray));
        System.out.println(string);
        System.out.println(string.length());
        ArrayDescriptor arrayDescriptor = ArrayReflection.makeArrayDescriptor(nArray);
        System.out.format("type = %s, rank = %d, dims = {", Traits.nameOf(arrayDescriptor.getType()), arrayDescriptor.getRank());
        for (n2 = 0; n2 < arrayDescriptor.getRank(); ++n2) {
            System.out.format(n2 == 0 ? "%d" : ",%d", arrayDescriptor.getDimension(n2));
        }
        System.out.format("}\n", new Object[0]);
        int[] nArray2 = (int[])ArrayReflection.flatten(nArray);
        n = 0;
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < n5; ++k) {
                    if (nArray[i][j][k] == nArray2[n8++]) continue;
                    ++n;
                }
            }
        }
        System.out.format("# of errors: %d\n", n);
        float[] fArray = (float[])Array.newInstance(Float.TYPE, 1);
        fArray[0] = 3.9f;
        System.out.format("x[0]: %g\n", Float.valueOf(fArray[0]));
        fArray = (float[])ArrayReflection.flatten(new float[]{5.0f});
        System.out.format("x[0]: %g\n", Float.valueOf(fArray[0]));
        long l = 11L;
        Object object = ArrayReflection.flatten(l);
        System.out.format("# of components: %d\n", Array.getLength(object));
        System.out.format("is array: %b\n", object.getClass().isArray());
        System.out.format("type of components: %s\n", object.getClass().getComponentType().toString());
        long[] lArray = (long[])ArrayReflection.flatten(l);
        System.out.format("# of components: %d\n", lArray.length);
        System.out.format("b[0]: %d\n", lArray[0]);
        short[] sArray = new short[]{1, 2, 3, 4};
        short[] sArray2 = (short[])ArrayReflection.flatten(sArray);
        short[] sArray3 = (short[])ArrayReflection.flatten(sArray, true);
        sArray2[2] = 100;
        sArray3[2] = 200;
        System.out.format("c[...] = {%d,%d,%d,%d}\n", sArray[0], sArray[1], sArray[2], sArray[3]);
        System.out.format("d[...] = {%d,%d,%d,%d}\n", sArray2[0], sArray2[1], sArray2[2], sArray2[3]);
        System.out.format("e[...] = {%d,%d,%d,%d}\n", sArray3[0], sArray3[1], sArray3[2], sArray3[3]);
    }
}

