/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FComplexMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected FComplexMatrix1D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        int size = (int)this.size();
        if (size == 0) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix1D.this.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(FComplexMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < size) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public float[] aggregate(final FComplexMatrix1D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        this.checkSize(other);
        int size = (int)this.size();
        if (size == 0) {
            float[] b = new float[]{Float.NaN, Float.NaN};
            return b;
        }
        float[] a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(FComplexMatrix1D.this.getQuick(i), other.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < size) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public FComplexMatrix1D assign(final FComplexFComplexFunction f) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, f.apply(FComplexMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(i, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexProcedure cond, final FComplexFComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    float[] elem;

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            this.elem = FComplexMatrix1D.this.getQuick(i);
                            if (cond.apply(this.elem)) {
                                FComplexMatrix1D.this.setQuick(i, f.apply(this.elem));
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float[] elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, f.apply(elem));
                }
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexProcedure cond, final float[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    float[] elem;

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            this.elem = FComplexMatrix1D.this.getQuick(i);
                            if (cond.apply(this.elem)) {
                                FComplexMatrix1D.this.setQuick(i, value);
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float[] elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, value);
                }
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexRealFunction f) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, f.apply(FComplexMatrix1D.this.getQuick(i)), 0.0f);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(i, f.apply(this.getQuick(i)), 0.0f);
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(FComplexMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final FComplexMatrix1D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, otherLoc.getQuick(i));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, otherLoc.getQuick(i));
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final FComplexMatrix1D y, final FComplexFComplexFComplexFunction f) {
        int size = (int)this.size();
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, f.apply(FComplexMatrix1D.this.getQuick(i), y.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(i, f.apply(this.getQuick(i), y.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final float re, final float im) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, re, im);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(i, re, im);
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assign(final float[] values) {
        int size = (int)this.size();
        if (values.length != 2 * size) {
            throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FComplexMatrix1D.this.setQuick(i, values[2 * i], values[2 * i + 1]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(i, values[2 * i], values[2 * i + 1]);
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assignImaginary(final FloatMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float re = FComplexMatrix1D.this.getQuick(i)[0];
                            float im = other.getQuick(i);
                            FComplexMatrix1D.this.setQuick(i, re, im);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float re = this.getQuick(i)[0];
                float im = other.getQuick(i);
                this.setQuick(i, re, im);
                ++i;
            }
        }
        return this;
    }

    public FComplexMatrix1D assignReal(final FloatMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float re = other.getQuick(i);
                            float im = FComplexMatrix1D.this.getQuick(i)[1];
                            FComplexMatrix1D.this.setQuick(i, re, im);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float re = other.getQuick(i);
                float im = this.getQuick(i)[1];
                this.setQuick(i, re, im);
                ++i;
            }
        }
        return this;
    }

    public int cardinality() {
        int size = (int)this.size();
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        float[] tmp = new float[2];
                        int i = firstIdx;
                        while (i < lastIdx) {
                            tmp = FComplexMatrix1D.this.getQuick(i);
                            if ((double)tmp[0] != 0.0 || (double)tmp[1] != 0.0) {
                                ++cardinality;
                            }
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            float[] tmp = new float[2];
            int i = 0;
            while (i < size) {
                tmp = this.getQuick(i);
                if ((double)tmp[0] != 0.0 || (double)tmp[1] != 0.0) {
                    ++cardinality;
                }
                ++i;
            }
        }
        return cardinality;
    }

    public FComplexMatrix1D copy() {
        FComplexMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public boolean equals(float[] value) {
        return FComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FComplexMatrix1D)) {
            return false;
        }
        return FComplexProperty.DEFAULT.equals(this, (FComplexMatrix1D)obj);
    }

    public float[] get(int index) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    public abstract Object elements();

    public abstract FloatMatrix1D getImaginaryPart();

    public void getNonZeros(IntArrayList indexList, ArrayList<float[]> valueList) {
        indexList.clear();
        valueList.clear();
        int s = (int)this.size();
        int i = 0;
        while (i < s) {
            float[] value = this.getQuick(i);
            if (value[0] != 0.0f || value[1] != 0.0f) {
                indexList.add(i);
                valueList.add(value);
            }
            ++i;
        }
    }

    public abstract float[] getQuick(int var1);

    public abstract FloatMatrix1D getRealPart();

    public FComplexMatrix1D like() {
        int size = (int)this.size();
        return this.like(size);
    }

    public abstract FComplexMatrix1D like(int var1);

    public abstract FComplexMatrix2D like2D(int var1, int var2);

    public abstract FComplexMatrix2D reshape(int var1, int var2);

    public abstract FComplexMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, float re, float im) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        this.setQuick(index, re, im);
    }

    public void set(int index, float[] value) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, float var2, float var3);

    public abstract void setQuick(int var1, float[] var2);

    public void swap(final FComplexMatrix1D other) {
        int size = (int)this.size();
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float[] tmp = FComplexMatrix1D.this.getQuick(i);
                            FComplexMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                float[] tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
                ++i;
            }
        }
    }

    public float[] toArray() {
        int size = (int)this.size();
        float[] values = new float[2 * size];
        this.toArray(values);
        return values;
    }

    public void toArray(final float[] values) {
        int size = (int)this.size();
        if (values.length < 2 * size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float[] tmp = FComplexMatrix1D.this.getQuick(i);
                            values[2 * i] = tmp[0];
                            values[2 * i + 1] = tmp[1];
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                float[] tmp = this.getQuick(i);
                values[2 * i] = tmp[0];
                values[2 * i + 1] = tmp[1];
                ++i;
            }
        }
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer s = new StringBuffer(String.format("ComplexMatrix1D: %d elements\n\n", this.size()));
        float[] elem = new float[2];
        int i = 0;
        while ((long)i < this.size()) {
            elem = this.getQuick(i);
            if (elem[1] == 0.0f) {
                s.append(String.format(String.valueOf(format) + "\n", Float.valueOf(elem[0])));
            } else if (elem[0] == 0.0f) {
                s.append(String.format(String.valueOf(format) + "i\n", Float.valueOf(elem[1])));
            } else if (elem[1] < 0.0f) {
                s.append(String.format(String.valueOf(format) + " - " + format + "i\n", Float.valueOf(elem[0]), Float.valueOf(-elem[1])));
            } else {
                s.append(String.format(String.valueOf(format) + " + " + format + "i\n", Float.valueOf(elem[0]), Float.valueOf(elem[1])));
            }
            ++i;
        }
        return s.toString();
    }

    public FComplexMatrix1D viewFlip() {
        return (FComplexMatrix1D)this.view().vFlip();
    }

    public FComplexMatrix1D viewPart(int index, int width) {
        return (FComplexMatrix1D)this.view().vPart(index, width);
    }

    public FComplexMatrix1D viewSelection(FComplexProcedure condition) {
        int size = (int)this.size();
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < size) {
            if (condition.apply(this.getQuick(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public FComplexMatrix1D viewSelection(int[] indexes) {
        int size = (int)this.size();
        if (indexes == null) {
            indexes = new int[size];
            int i = size - 1;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            offsets[i] = (int)this.index(indexes[i]);
            ++i;
        }
        return this.viewSelectionLike(offsets);
    }

    public FComplexMatrix1D viewStrides(int stride) {
        return (FComplexMatrix1D)this.view().vStrides(stride);
    }

    public float[] zDotProduct(FComplexMatrix1D y) {
        int size = (int)this.size();
        return this.zDotProduct(y, 0, size);
    }

    public float[] zDotProduct(final FComplexMatrix1D y, final int from, int length) {
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        float[] sum = new float[2];
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int k = firstIdx;
                        while (k < lastIdx) {
                            int idx = k + from;
                            float[] tmp = y.getQuick(idx);
                            tmp[1] = -tmp[1];
                            sum = FComplex.plus(sum, FComplex.mult(tmp, FComplexMatrix1D.this.getQuick(idx)));
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum = FComplex.plus(sum, results[j]);
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int k = 0;
            while (k < length) {
                int idx = k + from;
                float[] tmp = y.getQuick(idx);
                tmp[1] = -tmp[1];
                sum = FComplex.plus(sum, FComplex.mult(tmp, this.getQuick(idx)));
                ++k;
            }
        }
        return sum;
    }

    public float[] zDotProduct(FComplexMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int index = 0;
        int s = indexesCopy.size();
        while (index < s && nonZeroIndexElements[index] < from) {
            ++index;
        }
        float[] sum = new float[2];
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            float[] tmp = y.getQuick(i);
            tmp[1] = -tmp[1];
            sum = FComplex.plus(sum, FComplex.mult(tmp, this.getQuick(i)));
            ++index;
        }
        return sum;
    }

    public float[] zSum() {
        float[] sum = new float[2];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int k = firstIdx;
                        while (k < lastIdx) {
                            sum = FComplex.plus(sum, FComplexMatrix1D.this.getQuick(k));
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum[0] = sum[0] + results[j][0];
                    sum[1] = sum[1] + results[j][1];
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int k = 0;
            while (k < this.size) {
                sum = FComplex.plus(sum, this.getQuick(k));
                ++k;
            }
        }
        return sum;
    }

    protected int cardinality(int maxCardinality) {
        int size = (int)this.size();
        int cardinality = 0;
        int i = 0;
        float[] tmp = new float[2];
        while (i++ < size && cardinality < maxCardinality) {
            tmp = this.getQuick(i);
            if ((double)tmp[0] == 0.0 && (double)tmp[1] == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected FComplexMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix1D other) {
        return false;
    }

    protected FComplexMatrix1D view() {
        return (FComplexMatrix1D)this.clone();
    }

    protected abstract FComplexMatrix1D viewSelectionLike(int[] var1);

    protected float[] zDotProduct(FComplexMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, (int)this.size(), nonZeroIndexes);
    }
}

