/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;

public class AudioFileFormat {
    private Type type;
    private int byteLength;
    private AudioFormat format;
    private int frameLength;

    protected AudioFileFormat(Type type, int byteLength, AudioFormat format, int frameLength) {
        this.type = type;
        this.byteLength = byteLength;
        this.format = format;
        this.frameLength = frameLength;
    }

    public AudioFileFormat(Type type, AudioFormat format, int frameLength) {
        this(type, -1, format, frameLength);
    }

    public Type getType() {
        return this.type;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.type.toString() + " (." + this.type.getExtension() + ") file");
        if (this.byteLength != -1) {
            buf.append(", byte length: " + this.byteLength);
        }
        buf.append(", data format: " + this.format);
        if (this.frameLength != -1) {
            buf.append(", frame length: " + this.frameLength);
        }
        return new String(buf);
    }

    public static class Type {
        public static final Type WAVE = new Type("WAVE", "wav");
        public static final Type AU = new Type("AU", "au");
        public static final Type AIFF = new Type("AIFF", "aif");
        public static final Type AIFC = new Type("AIFF-C", "aifc");
        public static final Type SND = new Type("SND", "snd");
        private final String name;
        private final String extension;

        protected Type(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

