/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GeneratorMatrixMatrixMult {
    PrintStream stream;

    public GeneratorMatrixMatrixMult(String string) throws FileNotFoundException {
        this.stream = new PrintStream(string);
    }

    public void createClass() {
        String string = "/*\n * Copyright (c) 2009-2010, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * EJML is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation, either version 3\n * of the License, or (at your option) any later version.\n *\n * EJML is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with EJML.  If not, see <http://www.gnu.org/licenses/>.\n */\n\npackage org.ejml.alg.dense.mult;\n\nimport org.ejml.data.RowD1Matrix64F;\n\n/**\n * <p>\n * This class contains various types of matrix matrix multiplication operations for {@link RowD1Matrix64F}.\n * </p>\n * <p>\n * Two algorithms that are equivalent can often have very different runtime performance.\n * This is because of how modern computers uses fast memory caches to speed up reading/writing to data.\n * Depending on the order in which variables are processed different algorithms can run much faster than others,\n * even if the number of operations is the same.\n * </p>\n *\n * <p>\n * Algorithms that are labeled as 'reorder' are designed to avoid caching jumping issues, some times at the cost\n * of increasing the number of operations.  This is important for large matrices.  The straight forward \n * implementation seems to be faster for small matrices.\n * </p>\n * \n * <p>\n * Algorithms that are labeled as 'aux' use an auxiliary array of length n.  This array is used to create\n * a copy of an out of sequence column vector that is referenced several times.  This reduces the number\n * of cache misses.  If the 'aux' parameter passed in is null then the array is declared internally.\n * </p>\n *\n * <p>\n * Typically the straight forward implementation runs about 30% faster on smaller matrices and\n * about 5 times slower on larger matrices.  This is all computer architecture and matrix shape/size specific.\n * </p>\n * \n * <p>\n * <center>******** IMPORTANT **********</center>\n * This class was auto generated using {@link org.ejml.alg.dense.mult.CodeGeneratorMatrixMatrixMult}\n * If this code needs to be modified, please modify {@link org.ejml.alg.dense.mult.CodeGeneratorMatrixMatrixMult} instead\n * and regenerate the code by running that.\n * </p>\n * \n * @author Peter Abeles\n */\npublic class MatrixMatrixMult {\n";
        this.stream.print(string);
        for (int i = 0; i < 2; ++i) {
            boolean bl = i == 1;
            for (int j = 0; j < 2; ++j) {
                boolean bl2 = j == 1;
                this.printMult_reroder(bl, bl2);
                this.stream.print("\n");
                this.printMult_small(bl, bl2);
                this.stream.print("\n");
                this.printMult_aux(bl, bl2);
                this.stream.print("\n");
                this.printMultTransA_reorder(bl, bl2);
                this.stream.print("\n");
                this.printMultTransA_small(bl, bl2);
                this.stream.print("\n");
                this.printMultTransAB(bl, bl2);
                this.stream.print("\n");
                this.printMultTransAB_aux(bl, bl2);
                this.stream.print("\n");
                this.printMultTransB(bl, bl2);
                this.stream.print("\n");
            }
        }
        this.stream.print("}\n");
    }

    private String makeBoundsCheck(boolean bl, boolean bl2, String string) {
        String string2 = bl ? "a.numRows" : "a.numCols";
        String string3 = bl ? "a.numCols" : "a.numRows";
        String string4 = bl2 ? "b.numRows" : "b.numCols";
        String string5 = bl2 ? "b.numCols" : "b.numRows";
        String string6 = "        if( a == c || b == c )\n            throw new IllegalArgumentException(\"Neither 'a' or 'b' can be the same matrix as 'c'\");\n        else if( " + string2 + " != " + string5 + " ) {\n" + "            throw new MatrixDimensionException(\"The 'a' and 'b' matrices do not have compatible dimensions\");\n" + "        } else if( " + string3 + " != c.numRows || " + string4 + " != c.numCols ) {\n" + "            throw new MatrixDimensionException(\"The results matrix does not have the desired dimensions\");\n" + "        }\n" + "\n";
        if (string != null) {
            string6 = string6 + "        if( aux == null ) aux = new double[ " + string + " ];\n\n";
        }
        return string6;
    }

    private String makeComment(String string, boolean bl) {
        String string2 = bl ? "double, " : "";
        String string3 = "(" + string2 + " org.ejml.data.RowD1Matrix64F, org.ejml.data.RowD1Matrix64F, org.ejml.data.RowD1Matrix64F)";
        String string4 = "    /**\n     * @see org.ejml.ops.CommonOps#" + string + string3 + "\n" + "     */\n";
        return string4;
    }

    private String makeHeader(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl) {
            string = string + "Add";
        }
        if (bl4 && bl5) {
            string = string + "TransAB";
        } else if (bl4) {
            string = string + "TransA";
        } else if (bl5) {
            string = string + "TransB";
        }
        String string3 = this.makeComment(string, bl2) + "    public static void " + string;
        string3 = string2 != null ? string3 + "_" + string2 + "( " : string3 + "( ";
        if (bl2) {
            string3 = string3 + "double alpha , ";
        }
        string3 = bl3 ? string3 + "RowD1Matrix64F a , RowD1Matrix64F b , RowD1Matrix64F c , double []aux )\n" : string3 + "RowD1Matrix64F a , RowD1Matrix64F b , RowD1Matrix64F c )\n";
        string3 = string3 + "    {\n";
        return string3;
    }

    public void printMult_reroder(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", "reorder", bl2, bl, false, false, false);
        String string2 = bl ? "valA = alpha*a.get(indexA++);\n" : "valA = a.get(indexA++);\n";
        String string3 = bl2 ? "plus" : "set";
        String string4 = string + this.makeBoundsCheck(false, false, null) + "        double valA;\n" + "        int indexCbase= 0;\n" + "        int endOfKLoop = b.numRows*b.numCols;\n" + "\n" + "        for( int i = 0; i < a.numRows; i++ ) {\n" + "            int indexA = i*a.numCols;\n" + "\n" + "            // need to assign c.data to a value initially\n" + "            int indexB = 0;\n" + "            int indexC = indexCbase;\n" + "            int end = indexB + b.numCols;\n" + "\n" + "            " + string2 + "\n" + "            while( indexB < end ) {\n" + "                c." + string3 + "(indexC++ , valA*b.get(indexB++));\n" + "            }\n" + "\n" + "            // now add to it\n" + "            while( indexB != endOfKLoop ) { // k loop\n" + "                indexC = indexCbase;\n" + "                end = indexB + b.numCols;\n" + "\n" + "                " + string2 + "\n" + "                while( indexB < end ) { // j loop\n" + "                    c.plus(indexC++ , valA*b.get(indexB++));\n" + "                }\n" + "            }\n" + "            indexCbase += c.numCols;\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMult_small(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", "small", bl2, bl, false, false, false);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "                c." + string2 + "( cIndex++ , alpha*total );\n" : "                c." + string2 + "( cIndex++ , total );\n";
        String string4 = string + this.makeBoundsCheck(false, false, null) + "        int aIndexStart = 0;\n" + "        int cIndex = 0;\n" + "\n" + "        for( int i = 0; i < a.numRows; i++ ) {\n" + "            for( int j = 0; j < b.numCols; j++ ) {\n" + "                double total = 0;\n" + "\n" + "                int indexA = aIndexStart;\n" + "                int indexB = j;\n" + "                int end = indexA + b.numRows;\n" + "                while( indexA < end ) {\n" + "                    total += a.get(indexA++) * b.get(indexB);\n" + "                    indexB += b.numCols;\n" + "                }\n" + "\n" + string3 + "            }\n" + "            aIndexStart += a.numCols;\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMult_aux(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", "aux", bl2, bl, true, false, false);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "                c." + string2 + "( i*c.numCols+j , alpha*total );\n" : "                c." + string2 + "( i*c.numCols+j , total );\n";
        String string4 = string + this.makeBoundsCheck(false, false, "b.numRows") + "        for( int j = 0; j < b.numCols; j++ ) {\n" + "            // create a copy of the column in B to avoid cache issues\n" + "            for( int k = 0; k < b.numRows; k++ ) {\n" + "                aux[k] = b.unsafe_get(k,j);\n" + "            }\n" + "\n" + "            int indexA = 0;\n" + "            for( int i = 0; i < a.numRows; i++ ) {\n" + "                double total = 0;\n" + "                for( int k = 0; k < b.numRows; ) {\n" + "                    total += a.get(indexA++)*aux[k++];\n" + "                }\n" + string3 + "            }\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMultTransA_reorder(boolean bl, boolean bl2) {
        String string;
        String string2;
        String string3;
        String string4 = this.makeHeader("mult", "reorder", bl2, bl, false, true, false);
        String string5 = string3 = bl2 ? "plus" : "set";
        if (bl) {
            string2 = "valA = alpha*a.get(i);\n";
            string = "valA = alpha*a.unsafe_get(k,i);\n";
        } else {
            string2 = "valA = a.get(i);\n";
            string = "valA = a.unsafe_get(k,i);\n";
        }
        String string6 = string4 + this.makeBoundsCheck(true, false, null) + "        double valA;\n" + "\n" + "        for( int i = 0; i < a.numCols; i++ ) {\n" + "            int indexC_start = i*c.numCols;\n" + "\n" + "            // first assign R\n" + "            " + string2 + "            int indexB = 0;\n" + "            int end = indexB+b.numCols;\n" + "            int indexC = indexC_start;\n" + "            while( indexB<end ) {\n" + "                c." + string3 + "( indexC++ , valA*b.get(indexB++));\n" + "            }\n" + "            // now increment it\n" + "            for( int k = 1; k < a.numRows; k++ ) {\n" + "                " + string + "                end = indexB+b.numCols;\n" + "                indexC = indexC_start;\n" + "                // this is the loop for j\n" + "                while( indexB<end ) {\n" + "                    c.plus( indexC++ , valA*b.get(indexB++));\n" + "                }\n" + "            }\n" + "        }\n" + "    }\n";
        this.stream.print(string6);
    }

    public void printMultTransA_small(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", "small", bl2, bl, false, true, false);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "c." + string2 + "( cIndex++ , alpha*total );\n" : "c." + string2 + "( cIndex++ , total );\n";
        String string4 = string + this.makeBoundsCheck(true, false, null) + "        int cIndex = 0;\n" + "\n" + "        for( int i = 0; i < a.numCols; i++ ) {\n" + "            for( int j = 0; j < b.numCols; j++ ) {\n" + "                int indexA = i;\n" + "                int indexB = j;\n" + "                int end = indexB + b.numRows*b.numCols;\n" + "\n" + "                double total = 0;\n" + "\n" + "                // loop for k\n" + "                for(; indexB < end; indexB += b.numCols ) {\n" + "                    total += a.get(indexA) * b.get(indexB);\n" + "                    indexA += a.numCols;\n" + "                }\n" + "\n" + "                " + string3 + "            }\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMultTransB(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", null, bl2, bl, false, false, true);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "c." + string2 + "( cIndex++ , alpha*total );\n" : "c." + string2 + "( cIndex++ , total );\n";
        String string4 = string + this.makeBoundsCheck(false, true, null) + "        int cIndex = 0;\n" + "        int aIndexStart = 0;\n" + "\n" + "        for( int xA = 0; xA < a.numRows; xA++ ) {\n" + "            int end = aIndexStart + b.numCols;\n" + "            int indexB = 0;\n" + "            for( int xB = 0; xB < b.numRows; xB++ ) {\n" + "                int indexA = aIndexStart;\n" + "\n" + "                double total = 0;\n" + "\n" + "                while( indexA<end ) {\n" + "                    total += a.get(indexA++) * b.get(indexB++);\n" + "                }\n" + "\n" + "                " + string3 + "            }\n" + "            aIndexStart += a.numCols;\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMultTransAB(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", null, bl2, bl, false, true, true);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "c." + string2 + "( cIndex++ , alpha*total );\n" : "c." + string2 + "( cIndex++ , total );\n";
        String string4 = string + this.makeBoundsCheck(true, true, null) + "        int cIndex = 0;\n" + "\n" + "        for( int i = 0; i < a.numCols; i++ ) {\n" + "            int indexB = 0;\n" + "            for( int j = 0; j < b.numRows; j++ ) {\n" + "                int indexA = i;\n" + "                int end = indexB + b.numCols;\n" + "\n" + "                double total = 0;\n" + "\n" + "                for( ;indexB<end; ) {\n" + "                    total += a.get(indexA) * b.get(indexB++);\n" + "                    indexA += a.numCols;\n" + "                }\n" + "\n" + "                " + string3 + "            }\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public void printMultTransAB_aux(boolean bl, boolean bl2) {
        String string = this.makeHeader("mult", "aux", bl2, bl, true, true, true);
        String string2 = bl2 ? "plus" : "set";
        String string3 = bl ? "c." + string2 + "( indexC++ , alpha*total );\n" : "c." + string2 + "( indexC++ , total );\n";
        String string4 = string + this.makeBoundsCheck(true, true, "a.numRows") + "        int indexC = 0;\n" + "        for( int i = 0; i < a.numCols; i++ ) {\n" + "            for( int k = 0; k < b.numCols; k++ ) {\n" + "                aux[k] = a.unsafe_get(k,i);\n" + "            }\n" + "\n" + "            for( int j = 0; j < b.numRows; j++ ) {\n" + "                double total = 0;\n" + "\n" + "                for( int k = 0; k < b.numCols; k++ ) {\n" + "                    total += aux[k] * b.unsafe_get(j,k);\n" + "                }\n" + "                " + string3 + "            }\n" + "        }\n" + "    }\n";
        this.stream.print(string4);
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        GeneratorMatrixMatrixMult generatorMatrixMatrixMult = new GeneratorMatrixMatrixMult("MatrixMatrixMult.java");
        generatorMatrixMatrixMult.createClass();
    }
}

