/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double1D;
import mitiv.array.Double6D;
import mitiv.array.DoubleArray;
import mitiv.array.Float7D;
import mitiv.array.Int7D;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short7D;
import mitiv.array.impl.FlatDouble7D;
import mitiv.array.impl.StriddenDouble7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double7D
extends Array7D
implements DoubleArray {
    protected Double7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    protected Double7D(int[] nArray) {
        super(nArray);
    }

    protected Double7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, double var8);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) + d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) + d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) - d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) - d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) * d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) * d);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, doubleFunction.apply(this.get(i, j, k, i2, i3, i4, i5)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, doubleFunction.apply(this.get(i9, i8, i7, i6, k, j, i)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, doubleGenerator.nextDouble());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, doubleGenerator.nextDouble());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            doubleScanner.update(this.get(i, j, k, i2, i3, i4, i5));
                                            continue;
                                        }
                                        doubleScanner.initialize(this.get(i, j, k, i2, i3, i4, i5));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            doubleScanner.update(this.get(i9, i8, i7, i6, k, j, i));
                                            continue;
                                        }
                                        doubleScanner.initialize(this.get(i9, i8, i7, i6, k, j, i));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (!(d2 < d)) continue;
                                        d = d2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (!(d3 < d)) continue;
                                        d = d3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (!(d2 > d)) continue;
                                        d = d2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (!(d3 > d)) continue;
                                        d = d3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d3 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (d3 < d) {
                                            d = d3;
                                        }
                                        if (!(d3 > d2)) continue;
                                        d2 = d3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        double d4 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (d4 < d) {
                                            d = d4;
                                        }
                                        if (!(d4 > d2)) continue;
                                        d2 = d4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        d += this.get(i, j, k, i2, i3, i4, i5);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        d += this.get(i9, i8, i7, i6, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        byArray[++n] = (byte)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(byArray, this.getShape());
    }

    @Override
    public Short7D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        sArray[++n] = (short)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short7D.wrap(sArray, this.getShape());
    }

    @Override
    public Int7D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        nArray[++n] = (int)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int7D.wrap(nArray, this.getShape());
    }

    @Override
    public Long7D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        lArray[++n] = (long)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long7D.wrap(lArray, this.getShape());
    }

    @Override
    public Float7D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        fArray[++n] = (float)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float7D.wrap(fArray, this.getShape());
    }

    @Override
    public Double7D toDouble() {
        return this;
    }

    @Override
    public Double7D copy() {
        return new FlatDouble7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double7D double7D = shapedArray.getType() == 5 ? (Double7D)shapedArray : (Double7D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double7D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, double7D.get(i, j, k, i2, i3, i4, i5));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, double7D.get(i9, i8, i7, i6, k, j, i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        this.set(i5, i4, i3, i2, k, j, i, doubleShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, floatShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double7D create() {
        return new FlatDouble7D(this.getShape());
    }

    public static Double7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatDouble7D(n, n2, n3, n4, n5, n6, n7);
    }

    public static Double7D create(int[] nArray) {
        return new FlatDouble7D(nArray);
    }

    public static Double7D create(Shape shape) {
        return new FlatDouble7D(shape);
    }

    public static Double7D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatDouble7D(dArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Double7D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble7D(dArray, nArray);
    }

    public static Double7D wrap(double[] dArray, Shape shape) {
        return new FlatDouble7D(dArray, shape);
    }

    public static Double7D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return new StriddenDouble7D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    @Override
    public abstract Double6D slice(int var1);

    @Override
    public abstract Double6D slice(int var1, int var2);

    @Override
    public abstract Double7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Double7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Double1D as1D();
}

