/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.Arrays;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.fft.FloatFFT_2D;
import org.jtransforms.fft.FloatFFT_3D;
import org.jtransforms.utils.ConcurrencyUtils;
import org.jtransforms.utils.IOUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class BenchmarkFloatFFT {
    private static int nthread = 16;
    private static int niter = 100;
    private static int nsize = 8;
    private static int threadsBegin2D = 65536;
    private static int threadsBegin3D = 65536;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkFloatFFT() {
    }

    public static void parseArguments(String[] stringArray) {
        if (stringArray.length > 0) {
            int n;
            nthread = Integer.parseInt(stringArray[0]);
            threadsBegin2D = Integer.parseInt(stringArray[1]);
            threadsBegin3D = Integer.parseInt(stringArray[2]);
            niter = Integer.parseInt(stringArray[3]);
            doWarmup = Boolean.parseBoolean(stringArray[4]);
            doScaling = Boolean.parseBoolean(stringArray[5]);
            nsize = Integer.parseInt(stringArray[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatFFT.sizes1D[n] = Integer.parseInt(stringArray[7 + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatFFT.sizes2D[n] = Integer.parseInt(stringArray[7 + nsize + n]);
            }
            for (n = 0; n < nsize; ++n) {
                BenchmarkFloatFFT.sizes3D[n] = Integer.parseInt(stringArray[7 + nsize + nsize + n]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads(nthread);
        ConcurrencyUtils.setThreadsBeginN_2D(threadsBegin2D);
        ConcurrencyUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkComplexForward_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[] fArray;
            System.out.println("Complex forward FFT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(sizes1D[i]);
                fArray = new float[(int)(2L * sizes1D[i])];
                IOUtils.fillMatrix_1D(2L * sizes1D[i], fArray);
                floatFFT_1D.complexForward(fArray);
                IOUtils.fillMatrix_1D(2L * sizes1D[i], fArray);
                floatFFT_1D.complexForward(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_1D floatFFT_1D = new FloatFFT_1D(sizes1D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)(2L * sizes1D[i])];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(2L * sizes1D[i], fArray);
                l = System.nanoTime();
                floatFFT_1D.complexForward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatComplexForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray, dArray2);
    }

    public static void benchmarkRealForward_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[] fArray;
            System.out.println("Real forward FFT 1D of size " + sizes1D[i]);
            if (doWarmup) {
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(sizes1D[i]);
                fArray = new float[(int)(2L * sizes1D[i])];
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                floatFFT_1D.realForwardFull(fArray);
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                floatFFT_1D.realForwardFull(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_1D floatFFT_1D = new FloatFFT_1D(sizes1D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)(2L * sizes1D[i])];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], fArray);
                l = System.nanoTime();
                floatFFT_1D.realForwardFull(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_1D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatRealForwardFFT_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, dArray, dArray2);
    }

    public static void benchmarkComplexForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Complex forward FFT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
                floatLargeArray = new FloatLargeArray(sizes2D[i] * 2L * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], floatLargeArray);
                floatFFT_2D.complexForward(floatLargeArray);
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], floatLargeArray);
                floatFFT_2D.complexForward(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes2D[i] * 2L * sizes2D[i], false);
            double d = Double.MAX_VALUE;
            int n = niter;
            if (sizes2D[i] >= 8192L) {
                n = Math.max(1, niter / 10);
            }
            for (int j = 0; j < n; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], floatLargeArray);
                l = System.nanoTime();
                floatFFT_2D.complexForward(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n2 = i;
            dArray2[n2] = dArray2[n2] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatComplexForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkComplexForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][] fArray;
            System.out.println("Complex forward FFT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
                fArray = new float[(int)sizes2D[i]][2 * (int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], fArray);
                floatFFT_2D.complexForward(fArray);
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], fArray);
                floatFFT_2D.complexForward(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes2D[i]][2 * (int)sizes2D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], 2L * sizes2D[i], fArray);
                l = System.nanoTime();
                floatFFT_2D.complexForward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatComplexForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkRealForward_2D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Real forward FFT 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
                floatLargeArray = new FloatLargeArray(sizes2D[i] * 2L * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                floatFFT_2D.realForwardFull(floatLargeArray);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                floatFFT_2D.realForwardFull(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes2D[i] * 2L * sizes2D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], floatLargeArray);
                l = System.nanoTime();
                floatFFT_2D.realForwardFull(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatRealForwardFFT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkRealForward_2D_input_2D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][] fArray;
            System.out.println("Real forward FFT 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
                fArray = new float[(int)sizes2D[i]][2 * (int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                floatFFT_2D.realForwardFull(fArray);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                floatFFT_2D.realForwardFull(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_2D floatFFT_2D = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes2D[i]][2 * (int)sizes2D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], fArray);
                l = System.nanoTime();
                floatFFT_2D.realForwardFull(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_2D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatRealForwardFFT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, dArray, dArray2);
    }

    public static void benchmarkComplexForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Complex forward FFT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * 2L * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], floatLargeArray);
                floatFFT_3D.complexForward(floatLargeArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], floatLargeArray);
                floatFFT_3D.complexForward(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * 2L * sizes3D[i], false);
            double d = Double.MAX_VALUE;
            int n = niter;
            if (sizes3D[i] >= 1024L) {
                n = Math.max(1, niter / 10);
            }
            for (int j = 0; j < n; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], floatLargeArray);
                l = System.nanoTime();
                floatFFT_3D.complexForward(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n2 = i;
            dArray2[n2] = dArray2[n2] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatComplexForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkComplexForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][][] fArray;
            System.out.println("Complex forward FFT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][2 * (int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], fArray);
                floatFFT_3D.complexForward(fArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], fArray);
                floatFFT_3D.complexForward(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][2 * (int)sizes3D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2L * sizes3D[i], fArray);
                l = System.nanoTime();
                floatFFT_3D.complexForward(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatComplexForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkRealForward_3D_input_1D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray floatLargeArray;
            System.out.println("Real forward FFT 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * 2L * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                floatFFT_3D.realForwardFull(floatLargeArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                floatFFT_3D.realForwardFull(floatLargeArray);
            }
            long l = System.nanoTime();
            FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            floatLargeArray = new FloatLargeArray(sizes3D[i] * sizes3D[i] * 2L * sizes3D[i], false);
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], floatLargeArray);
                l = System.nanoTime();
                floatFFT_3D.realForwardFull(floatLargeArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            floatLargeArray = null;
            floatFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatRealForwardFFT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void benchmarkRealForward_3D_input_3D() {
        double[] dArray = new double[nsize];
        double[] dArray2 = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][][] fArray;
            System.out.println("Real forward FFT 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][2 * (int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                floatFFT_3D.realForwardFull(fArray);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                floatFFT_3D.realForwardFull(fArray);
            }
            long l = System.nanoTime();
            FloatFFT_3D floatFFT_3D = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            dArray2[i] = (double)(System.nanoTime() - l) / 1000000.0;
            fArray = new float[(int)sizes3D[i]][(int)sizes3D[i]][2 * (int)sizes3D[i]];
            double d = Double.MAX_VALUE;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], fArray);
                l = System.nanoTime();
                floatFFT_3D.realForwardFull(fArray);
                l = System.nanoTime() - l;
                if (!((double)l < d)) continue;
                d = l;
            }
            dArray[i] = d / 1000000.0;
            int n = i;
            dArray2[n] = dArray2[n] + dArray[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", dArray[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", dArray2[i]) + " msec");
            fArray = null;
            floatFFT_3D = null;
            System.gc();
            ConcurrencyUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatRealForwardFFT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, dArray, dArray2);
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatFFT.parseArguments(stringArray);
        BenchmarkFloatFFT.benchmarkComplexForward_1D();
        BenchmarkFloatFFT.benchmarkRealForward_1D();
        BenchmarkFloatFFT.benchmarkComplexForward_2D_input_1D();
        BenchmarkFloatFFT.benchmarkComplexForward_2D_input_2D();
        BenchmarkFloatFFT.benchmarkRealForward_2D_input_1D();
        BenchmarkFloatFFT.benchmarkRealForward_2D_input_2D();
        BenchmarkFloatFFT.benchmarkComplexForward_3D_input_1D();
        BenchmarkFloatFFT.benchmarkComplexForward_3D_input_3D();
        BenchmarkFloatFFT.benchmarkRealForward_3D_input_1D();
        BenchmarkFloatFFT.benchmarkRealForward_3D_input_3D();
        System.exit(0);
    }
}

