/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.DefaultDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class MRNSDDoubleIterationMonitor
extends DefaultDoubleIterationMonitor {
    @Override
    protected boolean convergedI(double r) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if (r <= this.rtol) {
            return true;
        }
        if (r > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(r)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    @Override
    protected boolean convergedI(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(r);
    }
}

