/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte1D;
import mitiv.array.ByteArray;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatByte2D;
import mitiv.array.impl.StriddenByte2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte2D
extends Array2D
implements ByteArray {
    protected Byte2D(int n, int n2) {
        super(n, n2);
    }

    protected Byte2D(int[] nArray) {
        super(nArray);
    }

    protected Byte2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2);

    public abstract void set(int var1, int var2, byte var3);

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, by);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, by);
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (byte)(this.get(i, j) + by));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (byte)(this.get(j, i) + by));
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (byte)(this.get(i, j) - by));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (byte)(this.get(j, i) - by));
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, (byte)(this.get(i, j) * by));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (byte)(this.get(j, i) * by));
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, byteFunction.apply(this.get(i, j)));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, byteFunction.apply(this.get(j, i)));
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, byteGenerator.nextByte());
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, byteGenerator.nextByte());
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        byteScanner.update(this.get(i, j));
                        continue;
                    }
                    byteScanner.initialize(this.get(i, j));
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        byteScanner.update(this.get(j, i));
                        continue;
                    }
                    byteScanner.initialize(this.get(j, i));
                    bl = true;
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n2 = this.get(i, j) & 0xFF;
                    if (n2 >= n) continue;
                    n = n2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(j, i) & 0xFF;
                    if (n3 >= n) continue;
                    n = n3;
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n2 = this.get(i, j) & 0xFF;
                    if (n2 <= n) continue;
                    n = n2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(j, i) & 0xFF;
                    if (n3 <= n) continue;
                    n = n3;
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(i, j) & 0xFF;
                    if (n3 < n) {
                        n = n3;
                    }
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n4 = this.get(j, i) & 0xFF;
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    n += this.get(i, j) & 0xFF;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    n += this.get(j, i) & 0xFF;
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        return this;
    }

    @Override
    public Short2D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    sArray[++n] = (short)(this.get(j, i) & 0xFF);
                }
            }
        }
        return Short2D.wrap(sArray, this.getShape());
    }

    @Override
    public Int2D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    nArray[++n] = this.get(j, i) & 0xFF;
                }
            }
        }
        return Int2D.wrap(nArray, this.getShape());
    }

    @Override
    public Long2D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    lArray[++n] = this.get(j, i) & 0xFF;
                }
            }
        }
        return Long2D.wrap(lArray, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    fArray[++n] = this.get(j, i) & 0xFF;
                }
            }
        }
        return Float2D.wrap(fArray, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    dArray[++n] = this.get(j, i) & 0xFF;
                }
            }
        }
        return Double2D.wrap(dArray, this.getShape());
    }

    @Override
    public Byte2D copy() {
        return new FlatByte2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte2D byte2D = shapedArray.getType() == 0 ? (Byte2D)shapedArray : (Byte2D)shapedArray.toByte();
        if (this.getOrder() == 2 && byte2D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, byte2D.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, byte2D.get(j, i));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (byte)doubleShapedVector.get(++n));
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (byte)floatShapedVector.get(++n));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte2D create() {
        return new FlatByte2D(this.getShape());
    }

    public static Byte2D create(int n, int n2) {
        return new FlatByte2D(n, n2);
    }

    public static Byte2D create(int[] nArray) {
        return new FlatByte2D(nArray);
    }

    public static Byte2D create(Shape shape) {
        return new FlatByte2D(shape);
    }

    public static Byte2D wrap(byte[] byArray, int n, int n2) {
        return new FlatByte2D(byArray, n, n2);
    }

    public static Byte2D wrap(byte[] byArray, int[] nArray) {
        return new FlatByte2D(byArray, nArray);
    }

    public static Byte2D wrap(byte[] byArray, Shape shape) {
        return new FlatByte2D(byArray, shape);
    }

    public static Byte2D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        return new StriddenByte2D(byArray, n, n2, n3, n4, n5);
    }

    @Override
    public abstract Byte1D slice(int var1);

    @Override
    public abstract Byte1D slice(int var1, int var2);

    @Override
    public abstract Byte2D view(Range var1, Range var2);

    @Override
    public abstract Byte2D view(int[] var1, int[] var2);

    @Override
    public abstract Byte1D as1D();
}

