package plugins.jmutterer.webcam;

import icy.file.FileUtil;
import icy.file.Saver;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import icy.type.point.Point5D;
import icy.canvas.IcyCanvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

import org.w3c.dom.Document;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarFolder;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarText;
import plugins.jmutterer.imagepassingblock.ImagePassingBlock;

import com.github.sarxos.webcam.Webcam;

public class WebcamSnap extends EzPlug {

	ActionListener startCamlistener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent e) {
			startCam();
		}
	};
	ActionListener stopCamlistener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent e) {
			stopFlag = true;
			camera.close();
			cam.setEnabled(true);
			startButton.setEnabled(true);
		}
	};
	ActionListener liveCamlistener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent e) {
			toggleLive();
		}
	};
	ActionListener saveImglistener = new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent e) {
			File path = outputFolder.getValue();
			int count = path.listFiles().length;
			Saver.save(s, new File(path + File.separator + prefix.getValue()
					+ count + ".tif"));
		}
	};

	EzButton stopButton = new EzButton("Stop Camera", stopCamlistener);
	EzButton startButton = new EzButton("Start Camera", startCamlistener);
	EzButton LiveButton = new EzButton("Toggle Live", liveCamlistener);
	EzButton saveButton = new EzButton("Save Image", saveImglistener);

	EzVarFolder outputFolder = new EzVarFolder("Output folder",
			"/Users/jerome/Desktop/");

	EzVarInteger cam = new EzVarInteger("Camera #", 0, Webcam.getWebcams()
			.size() - 1, 1);
	EzLabel camName = new EzLabel("", Color.BLUE);

	EzVarText prefix = new EzVarText("Prefix", "image_");

	EzVarBoolean customRes = new EzVarBoolean("Use Custom Resolution", false);
	EzVarInteger defaultRes = new EzVarInteger("Default Res. #", 0, Webcam
			.getWebcams().get(0).getViewSizes().length - 1, 1);
	EzLabel defResLabels = new EzLabel("", Color.BLUE);

	EzVarInteger customX = new EzVarInteger("x");
	EzVarInteger customY = new EzVarInteger("y");

	EzVarBoolean processLive = new EzVarBoolean("Process", false);
	EzVarFile protocolName = new EzVarFile("Protocol", FileUtil.getApplicationDirectory()+File.separator+"protocols" + File.separator);

	EzGroup camID = new EzGroup("1. Select Camera", cam, camName);
	EzGroup resolution = new EzGroup("2. Set Image Resolution", defaultRes,
			defResLabels, customRes, customX, customY);
	EzGroup controls = new EzGroup("3. Camera Controls", startButton, LiveButton,
			stopButton);

	
	EzVarText helpText = new EzVarText(	null,5);

	EzGroup process = new EzGroup("4. Live Image Processing", processLive,
			protocolName, helpText);
		
	boolean stopFlag;
	boolean toggleFlag;
	boolean shouldProcess = processLive.getValue();

	Webcam camera;
	BufferedImage image;
	Sequence s;
	Sequence snaps;
	String protocol;
	WorkFlow workFlow;

	public void startCam() {
		cam.setEnabled(false);

		camera = Webcam.getWebcams().get(cam.getValue());
		if (null != camera) {

			if (customRes.getValue() == true) {
				Dimension[] customSizes = camera.getViewSizes();
				customSizes[0].width = customX.getValue();
				customSizes[0].height = customY.getValue();
				camera.setViewSize(customSizes[0]);
			} else {
				Dimension[] sizes = camera.getViewSizes();
				camera.setViewSize(sizes[defaultRes.getValue()]);
			}
		}
		startButton.setEnabled(false);
		execute();
	}

	public void toggleLive() {
		toggleFlag = !toggleFlag;
	}

	@Override
	public void clean() {
		// TODO Auto-generated method stub
	}

	@Override
	protected void execute() {
		camera.open();
		// setupProtocol();
		if (camera.isImageNew()) {
			image = camera.getImage();
		}
		stopFlag = false;
		toggleFlag = true;

		Overlay ov = new Overlay("keylistener") {

			@Override
			public void keyReleased(KeyEvent e, Point5D.Double imagePoint,
					IcyCanvas canvas) {
				if ((e.getKeyCode() == 32) && (image != null)) {
					snaps.addImage(snaps.getSizeT(), image);
					snaps.setT(snaps.getSizeT());
				}
			}
		};
		s.addOverlay(ov);

		ThreadUtil.bgRun(new Runnable() {
			@Override
			public void run() {
				while (!stopFlag) {
					if (toggleFlag) {
						if (camera.isImageNew()) {
							image = camera.getImage();
							if (shouldProcess && protocolName.getValue() != null) {
								
								// System.out.println( "first block: " + firstBlock );
								// System.out.println( "last block: " + lastBlock );

								if ( ! ( firstBlock == null || lastBlock == null ) )
								{

									firstBlock.setInputImage(new Sequence(image));
									workFlow.runWorkFlow(true);
									try {
										Sequence resultSeq = lastBlock
												.getOuputImage();
										ArrayList<ROI> rois = resultSeq.getROIs();
										IcyBufferedImage resultImg = resultSeq
												.getFirstNonNullImage();
										s.setImage(0, 0, resultImg);
										s.removeAllROI();
										for (ROI roi : rois) {
											s.addROI(roi);
										}
									} catch (Exception e) {
										e.printStackTrace();
									}
								}
							} else
								s.setImage(0, 0, image);

							}

								/*
								ImagePassingBlock firstBlock = (ImagePassingBlock) workFlow
										.getBlock(0).getBlock();
								ImagePassingBlock lastBlock = (ImagePassingBlock) workFlow
										.getBlock(workFlow.size() - 1)
										.getBlock();
								firstBlock.setInputImage(new Sequence(image));
								workFlow.runWorkFlow(true);
								try {
									Sequence resultSeq = lastBlock
											.getOuputImage();
									ArrayList<ROI> rois = resultSeq.getROIs();
									IcyBufferedImage resultImg = resultSeq
											.getFirstNonNullImage();
									s.setImage(0, 0, resultImg);
									s.removeAllROI();
									for (ROI roi : rois) {
										s.addROI(roi);
									}
								} catch (Exception e) {

								}
							} else
								s.setImage(0, 0, image);
							*/
						}

						s.dataChanged();
					}
				}
			
		});
	}

	/** input image block */
	ImagePassingBlock firstBlock = null;
	/** output image block to retrieve the result */
	ImagePassingBlock lastBlock = null;
	
	private void setupProtocol() {
		String protocol = protocolName.getValue().getPath();
		Document xml = XMLUtil.loadDocument(protocol);
		workFlow = new WorkFlow();
		BlocksML.getInstance().loadWorkFlow(xml, workFlow);
		
		// reset input output blocks
		firstBlock = null;
		lastBlock = null;
		
		for ( int i = 0 ; i< workFlow.size() ; i++ )
		{
			Block candidateBlock = workFlow.getBlock( i ).getBlock();
			
			if ( !( candidateBlock instanceof ImagePassingBlock ) )
				continue;
			
			if ( firstBlock == null )
			{
				firstBlock = (ImagePassingBlock) candidateBlock;
			}else
			{
				lastBlock = (ImagePassingBlock) candidateBlock;
			}
		}
		
		if ( firstBlock == null || lastBlock == null )
		{
			new AnnounceFrame("The selected protocol is not starting and ending by an ImagePassingBlock");
		}
		/*
		System.out.println( "first block: " + firstBlock );
		System.out.println( "last block: " + lastBlock );
*/
	}

	@Override
	protected void initialize() {
		addEzComponent(camID);
		cam.addVarChangeListener(new EzVarListener<Integer>() {
			@Override
			public void variableChanged(EzVar<Integer> source, Integer newValue) {
				camName.setText(Webcam.getWebcams().get(newValue).getName());
			}
		});
		cam.setValue(0);
		addEzComponent(resolution);
		defaultRes.addVarChangeListener(new EzVarListener<Integer>() {
			@Override
			public void variableChanged(EzVar<Integer> source, Integer newValue) {
				Dimension[] sizes = Webcam.getWebcams().get(cam.getValue())
						.getViewSizes();
				String text = "" + sizes[newValue].width + "x"
						+ sizes[newValue].height;
				defResLabels.setText(text);
				customX.setValue(sizes[newValue].width);
				customY.setValue(sizes[newValue].height);

			}
		});
		
		addEzComponent(controls);
		addEzComponent(process);
		processLive.addVarChangeListener(new EzVarListener<Boolean>() {

			@Override
			public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
				shouldProcess = newValue;
				if (newValue) {
					if (protocolName.getValue() != null) {
						setupProtocol();
					}
					protocolName.setEnabled(false);
				} else if (getActiveSequence() != null) {
					getActiveSequence().removeAllROI();
					protocolName.setEnabled(true);
				}

			}
		});
		helpText.setValue("Processing protocols should\n" +
			" start and end with an \n"+
			"'ImagePassing' Block");
		s = new Sequence("Webcam Image");
		snaps = new Sequence("Snapshots");
		addSequence(s);
		addSequence(snaps);
		getUI().setActionPanelVisible(false);
		//getUI().setParametersIOVisible(false);
		getUI().setProgressBarVisible(true);
		snaps.getViewers().get(0).setSize(new Dimension(200, 200));
		snaps.getViewers()
				.get(0)
				.setLocation(getUI().getBounds().x,
						getUI().getBoundsExternal().height + 100);
		s.getViewers().get(0).setLocation(getUI().getBounds().width + 50, 0);

	}
}
