/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.Double27Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2DProcedure;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DoubleMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix3D() {
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DoubleMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DoubleMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DoubleMatrix3D.this.getQuick(firstSlice, 0, 0);
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DoubleMatrix3D.this.columns) {
                                    elem = DoubleMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.getQuick(0, 0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            return Double.NaN;
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix3D.this.getQuick(sliceElements[firstIdx], rowElements[firstIdx], columnElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DoubleMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(sliceElements[0], rowElements[0], columnElements[0]));
            int i = 1;
            while (i < size) {
                double elem = this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public double aggregate(final DoubleMatrix3D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DoubleMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DoubleMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DoubleMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public DoubleMatrix3D assign(final DoubleFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, function.apply(DoubleMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure cond, final DoubleFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    double elem = DoubleMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        DoubleMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        double elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, f.apply(elem));
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleProcedure cond, final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    double elem = DoubleMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        DoubleMatrix3D.this.setQuick(s, r, c, value);
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        double elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, value);
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, value);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, value);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[] values) {
        if (values.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstSlice * DoubleMatrix3D.this.rows * DoubleMatrix3D.this.columns;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, values[idx++]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, values[idx++]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final double[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            double[][] currentSlice = values[s];
                            if (currentSlice.length != DoubleMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DoubleMatrix3D.this.rows());
                            }
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                double[] currentRow = currentSlice[r];
                                if (currentRow.length != DoubleMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DoubleMatrix3D.this.columns());
                                }
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, currentRow[c]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                double[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                int r = 0;
                while (r < this.rows) {
                    double[] currentRow = currentSlice[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, currentRow[c]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final DoubleMatrix3D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, source.getQuick(s, r, c));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, source.getQuick(s, r, c));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleMatrix3D y, final DoubleDoubleFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    DoubleMatrix3D.this.setQuick(s, r, c, function.apply(DoubleMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(final DoubleMatrix3D y, final DoubleDoubleFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DoubleMatrix3D.this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(DoubleMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    if (DoubleMatrix3D.this.getQuick(s, r, c) != 0.0) {
                                        ++cardinality;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        if (this.getQuick(s, r, c) != 0.0) {
                            ++cardinality;
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public DoubleMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(double value) {
        return DoubleProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix3D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix3D)obj);
    }

    public double get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    public double[] getMaxLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        double maxValue = DoubleMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DoubleMatrix3D.this.columns) {
                                    double elem = DoubleMatrix3D.this.getQuick(s, r, c);
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        sliceLocation = s;
                                        rowLocation = r;
                                        columnLocation = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new double[]{maxValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                sliceLocation = (int)results[0][1];
                rowLocation = (int)results[0][2];
                columnLocation = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        sliceLocation = (int)results[j][1];
                        rowLocation = (int)results[j][2];
                        columnLocation = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0, 0);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        double elem = this.getQuick(s, r, c);
                        if (maxValue < elem) {
                            maxValue = elem;
                            sliceLocation = s;
                            rowLocation = r;
                            columnLocation = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new double[]{maxValue, sliceLocation, rowLocation, columnLocation};
    }

    public double[] getMinLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        double minValue = DoubleMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DoubleMatrix3D.this.columns) {
                                    double elem = DoubleMatrix3D.this.getQuick(s, r, c);
                                    if (minValue > elem) {
                                        minValue = elem;
                                        sliceLocation = s;
                                        rowLocation = r;
                                        columnLocation = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new double[]{minValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                sliceLocation = (int)results[0][1];
                rowLocation = (int)results[0][2];
                columnLocation = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        sliceLocation = (int)results[j][1];
                        rowLocation = (int)results[j][2];
                        columnLocation = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0, 0);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        double elem = this.getQuick(s, r, c);
                        if (minValue > elem) {
                            minValue = elem;
                            sliceLocation = s;
                            rowLocation = r;
                            columnLocation = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new double[]{minValue, sliceLocation, rowLocation, columnLocation};
    }

    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double value = this.getQuick(s, r, c);
                    if (value < 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double value = this.getQuick(s, r, c);
                    if (value != 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double value = this.getQuick(s, r, c);
                    if (value > 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public abstract double getQuick(int var1, int var2, int var3);

    public DoubleMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract DoubleMatrix3D like(int var1, int var2, int var3);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void normalize() {
        double min = this.getMinLocation()[0];
        if (min < 0.0) {
            this.assign(DoubleFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0 / sumScaleFactor;
            this.assign(DoubleFunctions.mult(sumScaleFactor));
        }
    }

    public void set(int slice, int row, int column, double value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, double var4);

    public double[][][] toArray() {
        final double[][][] values = new double[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            double[][] currentSlice = values[s];
                            int r = 0;
                            while (r < DoubleMatrix3D.this.rows) {
                                double[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < DoubleMatrix3D.this.columns) {
                                    currentRow[c] = DoubleMatrix3D.this.getQuick(s, r, c);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                double[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    double[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.getQuick(s, r, c);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public abstract DoubleMatrix1D vectorize();

    public DoubleMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewColumnFlip() {
        return (DoubleMatrix3D)this.view().vColumnFlip();
    }

    public DoubleMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (DoubleMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public DoubleMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (DoubleMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public DoubleMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewRowFlip() {
        return (DoubleMatrix3D)this.view().vRowFlip();
    }

    public DoubleMatrix3D viewSelection(DoubleMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.slices) {
            if (condition.apply(this.viewSlice(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    public DoubleMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = 0;
            while (i < this.slices) {
                sliceIndexes[i] = i;
                ++i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = 0;
            while (i < this.rows) {
                rowIndexes[i] = i;
                ++i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = 0;
            while (i < this.columns) {
                columnIndexes[i] = i;
                ++i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < sliceIndexes.length) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public DoubleMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public DoubleMatrix3D viewSliceFlip() {
        return (DoubleMatrix3D)this.view().vSliceFlip();
    }

    public DoubleMatrix3D viewSorted(int row, int column) {
        return DoubleSorting.mergeSort.sort(this, row, column);
    }

    public DoubleMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (DoubleMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    public void zAssign27Neighbors(DoubleMatrix3D B, Double27Function function) {
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int r = this.rows - 1;
        int c = this.columns - 1;
        int k = 1;
        while (k < this.slices - 1) {
            int i = 1;
            while (i < r) {
                double a000 = this.getQuick(k - 1, i - 1, 0);
                double a001 = this.getQuick(k - 1, i - 1, 1);
                double a010 = this.getQuick(k - 1, i, 0);
                double a011 = this.getQuick(k - 1, i, 1);
                double a020 = this.getQuick(k - 1, i + 1, 0);
                double a021 = this.getQuick(k - 1, i + 1, 1);
                double a100 = this.getQuick(k - 1, i - 1, 0);
                double a101 = this.getQuick(k, i - 1, 1);
                double a110 = this.getQuick(k, i, 0);
                double a111 = this.getQuick(k, i, 1);
                double a120 = this.getQuick(k, i + 1, 0);
                double a121 = this.getQuick(k, i + 1, 1);
                double a200 = this.getQuick(k + 1, i - 1, 0);
                double a201 = this.getQuick(k + 1, i - 1, 1);
                double a210 = this.getQuick(k + 1, i, 0);
                double a211 = this.getQuick(k + 1, i, 1);
                double a220 = this.getQuick(k + 1, i + 1, 0);
                double a221 = this.getQuick(k + 1, i + 1, 1);
                int j = 1;
                while (j < c) {
                    double a002 = this.getQuick(k - 1, i - 1, j + 1);
                    double a012 = this.getQuick(k - 1, i, j + 1);
                    double a022 = this.getQuick(k - 1, i + 1, j + 1);
                    double a102 = this.getQuick(k, i - 1, j + 1);
                    double a112 = this.getQuick(k, i, j + 1);
                    double a122 = this.getQuick(k, i + 1, j + 1);
                    double a202 = this.getQuick(k + 1, i - 1, j + 1);
                    double a212 = this.getQuick(k + 1, i, j + 1);
                    double a222 = this.getQuick(k + 1, i + 1, j + 1);
                    B.setQuick(k, i, j, function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222));
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        return false;
    }

    protected abstract DoubleMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected DoubleMatrix3D view() {
        return (DoubleMatrix3D)this.clone();
    }

    protected abstract DoubleMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);
}

