/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.FloatScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.random.FloatGenerator;

public class StriddenFloat1D
extends Float1D {
    final int order;
    final float[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenFloat1D(float[] fArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = fArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.order = Float1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenFloat1D(float[] fArray, int n, int n2, int n3) {
        super(n3);
        this.data = fArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Float1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Float1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final float get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, float f) {
        this.data[this.offset + this.stride1 * n] = f;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = f;
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = floatGenerator.nextFloat();
        }
    }

    @Override
    public void increment(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] + f;
        }
    }

    @Override
    public void decrement(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] - f;
        }
    }

    @Override
    public void scale(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] * f;
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = floatFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                floatScanner.update(this.data[n]);
                continue;
            }
            floatScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        float[] fArray = new float[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, fArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                fArray[++n] = this.data[n2];
            }
        }
        return fArray;
    }

    @Override
    public float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public FloatScalar slice(int n) {
        return new FloatScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public FloatScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new FloatScalar(this.data, n3);
    }

    @Override
    public Float1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenFloat1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Float1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedFloat1D(this.data, nArray2);
    }

    @Override
    public Float1D as1D() {
        return this;
    }
}

