/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Pressure;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPressureEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsPressure implements Enumeration
{
    YOTTAPASCAL("YPa"),
    ZETTAPASCAL("ZPa"),
    EXAPASCAL("EPa"),
    PETAPASCAL("PPa"),
    TERAPASCAL("TPa"),
    GIGAPASCAL("GPa"),
    MEGAPASCAL("MPa"),
    KILOPASCAL("kPa"),
    HECTOPASCAL("hPa"),
    DECAPASCAL("daPa"),
    PASCAL("Pa"),
    DECIPASCAL("dPa"),
    CENTIPASCAL("cPa"),
    MILLIPASCAL("mPa"),
    MICROPASCAL("\u00b5Pa"),
    NANOPASCAL("nPa"),
    PICOPASCAL("pPa"),
    FEMTOPASCAL("fPa"),
    ATTOPASCAL("aPa"),
    ZEPTOPASCAL("zPa"),
    YOCTOPASCAL("yPa"),
    BAR("bar"),
    MEGABAR("Mbar"),
    KILOBAR("kbar"),
    DECIBAR("dbar"),
    CENTIBAR("cbar"),
    MILLIBAR("mbar"),
    ATMOSPHERE("atm"),
    PSI("psi"),
    TORR("Torr"),
    MILLITORR("mTorr"),
    MMHG("mm Hg");

    public static final UnitsPressure Pascal;
    private final String value;

    private UnitsPressure(String value) {
        this.value = value;
    }

    public static UnitsPressure fromString(String value) throws EnumerationException {
        if ("YPa".equals(value)) {
            return YOTTAPASCAL;
        }
        if ("ZPa".equals(value)) {
            return ZETTAPASCAL;
        }
        if ("EPa".equals(value)) {
            return EXAPASCAL;
        }
        if ("PPa".equals(value)) {
            return PETAPASCAL;
        }
        if ("TPa".equals(value)) {
            return TERAPASCAL;
        }
        if ("GPa".equals(value)) {
            return GIGAPASCAL;
        }
        if ("MPa".equals(value)) {
            return MEGAPASCAL;
        }
        if ("kPa".equals(value)) {
            return KILOPASCAL;
        }
        if ("hPa".equals(value)) {
            return HECTOPASCAL;
        }
        if ("daPa".equals(value)) {
            return DECAPASCAL;
        }
        if ("Pa".equals(value)) {
            return PASCAL;
        }
        if ("dPa".equals(value)) {
            return DECIPASCAL;
        }
        if ("cPa".equals(value)) {
            return CENTIPASCAL;
        }
        if ("mPa".equals(value)) {
            return MILLIPASCAL;
        }
        if ("\u00b5Pa".equals(value)) {
            return MICROPASCAL;
        }
        if ("nPa".equals(value)) {
            return NANOPASCAL;
        }
        if ("pPa".equals(value)) {
            return PICOPASCAL;
        }
        if ("fPa".equals(value)) {
            return FEMTOPASCAL;
        }
        if ("aPa".equals(value)) {
            return ATTOPASCAL;
        }
        if ("zPa".equals(value)) {
            return ZEPTOPASCAL;
        }
        if ("yPa".equals(value)) {
            return YOCTOPASCAL;
        }
        if ("bar".equals(value)) {
            return BAR;
        }
        if ("Mbar".equals(value)) {
            return MEGABAR;
        }
        if ("kbar".equals(value)) {
            return KILOBAR;
        }
        if ("dbar".equals(value)) {
            return DECIBAR;
        }
        if ("cbar".equals(value)) {
            return CENTIBAR;
        }
        if ("mbar".equals(value)) {
            return MILLIBAR;
        }
        if ("atm".equals(value)) {
            return ATMOSPHERE;
        }
        if ("psi".equals(value)) {
            return PSI;
        }
        if ("Torr".equals(value)) {
            return TORR;
        }
        if ("mTorr".equals(value)) {
            return MILLITORR;
        }
        if ("mm Hg".equals(value)) {
            return MMHG;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsPressure.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> Pressure create(T newValue, UnitsPressure newUnit) {
        Pressure theQuantity = null;
        try {
            theQuantity = UnitsPressureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    public static <T extends Number> Pressure create(T newValue, UnitsPressure newUnit) {
        Pressure theQuantity = null;
        try {
            theQuantity = UnitsPressureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    static {
        Pascal = PASCAL;
    }
}

