/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.ConcurrencyUtils;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DoubleProperty DEFAULT = new DoubleProperty(1.0E-9);
    public static final DoubleProperty ZERO = new DoubleProperty(0.0);
    public static final DoubleProperty TWELVE = new DoubleProperty(1.0E-12);
    protected double tolerance;

    private DoubleProperty() {
        this(1.0E-9);
    }

    public DoubleProperty(double newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        StringBuffer buf = new StringBuffer(length);
        int k = 0;
        while (k < length) {
            buf.append(' ');
            ++k;
        }
        return buf.toString();
    }

    public void checkRectangular(DoubleMatrix2D A) {
        if (A.rows() < A.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(A));
        }
    }

    public void checkSquare(DoubleMatrix2D A) {
        if (A.rows() != A.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(A));
        }
    }

    public void checkDense(DoubleMatrix2D A) {
        if (!(A instanceof DenseDoubleMatrix2D) && !(A instanceof DenseColumnDoubleMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkDense(DoubleMatrix1D A) {
        if (!(A instanceof DenseDoubleMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkSparse(DoubleMatrix1D A) {
        if (!(A instanceof SparseDoubleMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public void checkSparse(DoubleMatrix2D A) {
        if (!(A instanceof SparseCCDoubleMatrix2D) && !(A instanceof SparseRCDoubleMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public double density(DoubleMatrix2D A) {
        return (double)A.cardinality() / (double)A.size();
    }

    public boolean equals(final DoubleMatrix1D A, final double value) {
        if (A == null) {
            return false;
        }
        int size = (int)A.size();
        final double epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            double x = A.getQuick(i);
                            double diff = Math.abs(value - x);
                            if (diff != diff && (value != value && x != x || value == x)) {
                                diff = 0.0;
                            }
                            if (!(diff <= epsilon)) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int i = 0;
        while (i < size) {
            double x = A.getQuick(i);
            double diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0;
            }
            if (!(diff <= epsilon)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final DoubleMatrix1D A, final DoubleMatrix1D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int size = (int)A.size();
        if ((long)size != B.size()) {
            return false;
        }
        final double epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            double x = A.getQuick(i);
                            double value = B.getQuick(i);
                            double diff = Math.abs(value - x);
                            if (diff != diff && (value != value && x != x || value == x)) {
                                diff = 0.0;
                            }
                            if (!(diff <= epsilon)) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int i = 0;
        while (i < size) {
            double x = A.getQuick(i);
            double value = B.getQuick(i);
            double diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0;
            }
            if (!(diff <= epsilon)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final DoubleMatrix2D A, final double value) {
        if (A == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < columns) {
                                double x = A.getQuick(r, c);
                                double diff = Math.abs(value - x);
                                if (diff != diff && (value != value && x != x || value == x)) {
                                    diff = 0.0;
                                }
                                if (!(diff <= epsilon)) {
                                    return false;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < columns) {
                double x = A.getQuick(r, c);
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (!(diff <= epsilon)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(final DoubleMatrix2D A, final DoubleMatrix2D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < columns) {
                                double x = A.getQuick(r, c);
                                double value = B.getQuick(r, c);
                                double diff = Math.abs(value - x);
                                if (diff != diff && (value != value && x != x || value == x)) {
                                    diff = 0.0;
                                }
                                if (!(diff <= epsilon)) {
                                    return false;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < columns) {
                double x = A.getQuick(r, c);
                double value = B.getQuick(r, c);
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (!(diff <= epsilon)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(final DoubleMatrix3D A, final double value) {
        if (A == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < rows) {
                                int c = 0;
                                while (c < columns) {
                                    double x = A.getQuick(s, r, c);
                                    double diff = Math.abs(value - x);
                                    if (diff != diff && (value != value && x != x || value == x)) {
                                        diff = 0.0;
                                    }
                                    if (!(diff <= epsilon)) {
                                        return false;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int s = 0;
        while (s < slices) {
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < columns) {
                    double x = A.getQuick(s, r, c);
                    double diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0;
                    }
                    if (!(diff <= epsilon)) {
                        return false;
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return true;
    }

    public boolean equals(final DoubleMatrix3D A, final DoubleMatrix3D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        boolean result = false;
        final double epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < rows) {
                                int c = 0;
                                while (c < columns) {
                                    double x = A.getQuick(s, r, c);
                                    double value = B.getQuick(s, r, c);
                                    double diff = Math.abs(value - x);
                                    if (diff != diff && (value != value && x != x || value == x)) {
                                        diff = 0.0;
                                    }
                                    if (!(diff <= epsilon)) {
                                        return false;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int s = 0;
        while (s < slices) {
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < columns) {
                    double x = A.getQuick(s, r, c);
                    double value = B.getQuick(s, r, c);
                    double diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0;
                    }
                    if (!(diff <= epsilon)) {
                        return false;
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return true;
    }

    public void generateNonSingular(DoubleMatrix2D A) {
        int min;
        this.checkSquare(A);
        DoubleFunctions F = DoubleFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            A.setQuick(i, i, 0.0);
        }
        i = min;
        while (--i >= 0) {
            double rowSum = A.viewRow(i).aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
            double colSum = A.viewColumn(i).aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
            A.setQuick(i, i, Math.max(rowSum, colSum) + (double)i + 1.0);
        }
    }

    protected static String get(ObjectArrayList list, int index) {
        return (String)list.get(index);
    }

    public boolean isDiagonal(DoubleMatrix2D A) {
        double epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(DoubleMatrix2D A) {
        int min;
        DoubleFunctions F = DoubleFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            double diag = Math.abs(A.getQuick(i, i));
            if (!((diag += diag) <= A.viewColumn(i).aggregate(DoubleFunctions.plus, DoubleFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(DoubleMatrix2D A) {
        int min;
        DoubleFunctions F = DoubleFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            double diag = Math.abs(A.getQuick(i, i));
            if (!((diag += diag) <= A.viewRow(i).aggregate(DoubleFunctions.plus, DoubleFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(DoubleMatrix2D A) {
        double epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double v = A.getQuick(row, column);
                if (!(row == column ? !(Math.abs(1.0 - v) < epsilon) : !(Math.abs(v) <= epsilon))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(DoubleMatrix2D A) {
        double epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(DoubleMatrix2D A) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) >= 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(DoubleMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A.zMult(A, null, 1.0, 0.0, false, true), DoubleFactory2D.dense.identity(A.rows()));
    }

    public boolean isPositive(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) > 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(DoubleMatrix2D A) {
        return !(Math.abs(DenseDoubleAlgebra.DEFAULT.det(A)) >= this.tolerance());
    }

    public boolean isSkewSymmetric(DoubleMatrix2D A) {
        int rows;
        this.checkSquare(A);
        double epsilon = this.tolerance();
        int row = rows = A.rows();
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (Math.abs(A.getQuick(row, column) + A.getQuick(column, row)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(DoubleMatrix2D A) {
        return A.rows() == A.columns();
    }

    public boolean isStrictlyLowerTriangular(DoubleMatrix2D A) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(DoubleMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (Math.abs(A.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(DoubleMatrix2D A) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(DoubleMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A, A.viewDice());
    }

    public boolean isTriangular(DoubleMatrix2D A) {
        return this.isLowerTriangular(A) || this.isUpperTriangular(A);
    }

    public boolean isTridiagonal(DoubleMatrix2D A) {
        double epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(DoubleMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (Math.abs(1.0 - A.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(DoubleMatrix2D A) {
        double epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(DoubleMatrix2D A) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(DoubleMatrix2D A) {
        return this.equals(A, 0.0);
    }

    public int lowerBandwidth(DoubleMatrix2D A) {
        int rows;
        this.checkSquare(A);
        double epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A.getQuick(j, i)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(DoubleMatrix2D A) {
        int rows;
        this.checkSquare(A);
        double epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(A.getQuick(j, i)) <= epsilon)) {
                    return k + 1;
                }
                if (Math.abs(A.getQuick(i, j)) <= epsilon) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public void setTolerance(double newTolerance) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public String toString(DoubleMatrix2D A) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("density");
        try {
            values.add(String.valueOf(this.density(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonal");
        try {
            values.add(String.valueOf(this.isDiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonallyDominantByRow");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByRow(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonallyDominantByColumn");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByColumn(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isIdentity");
        try {
            values.add(String.valueOf(this.isIdentity(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isLowerBidiagonal");
        try {
            values.add(String.valueOf(this.isLowerBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isLowerTriangular");
        try {
            values.add(String.valueOf(this.isLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isNonNegative");
        try {
            values.add(String.valueOf(this.isNonNegative(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isOrthogonal");
        try {
            values.add(String.valueOf(this.isOrthogonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isPositive");
        try {
            values.add(String.valueOf(this.isPositive(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSingular");
        try {
            values.add(String.valueOf(this.isSingular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSkewSymmetric");
        try {
            values.add(String.valueOf(this.isSkewSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSquare");
        try {
            values.add(String.valueOf(this.isSquare(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyLowerTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyUpperTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSymmetric");
        try {
            values.add(String.valueOf(this.isSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isTriangular");
        try {
            values.add(String.valueOf(this.isTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isTridiagonal");
        try {
            values.add(String.valueOf(this.isTridiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUnitTriangular");
        try {
            values.add(String.valueOf(this.isUnitTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUpperBidiagonal");
        try {
            values.add(String.valueOf(this.isUpperBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUpperTriangular");
        try {
            values.add(String.valueOf(this.isUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isZero");
        try {
            values.add(String.valueOf(this.isZero(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("lowerBandwidth");
        try {
            values.add(String.valueOf(this.lowerBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("semiBandwidth");
        try {
            values.add(String.valueOf(this.semiBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("upperBandwidth");
        try {
            values.add(String.valueOf(this.upperBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return DoubleProperty.get(names, a).compareTo(DoubleProperty.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        int i = 0;
        while (i < names.size()) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.get(i2);
            buf.append(name);
            buf.append(DoubleProperty.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i2));
            if (i2 < names.size() - 1) {
                buf.append('\n');
            }
            ++i2;
        }
        return buf.toString();
    }

    public int upperBandwidth(DoubleMatrix2D A) {
        int rows;
        this.checkSquare(A);
        double epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A.getQuick(i, j)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }
}

