/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.net.URL;

public class ImageArea
extends Canvas {
    private Image image = null;
    private Insets insetsBorder = new Insets(6, 6, 6, 6);

    public ImageArea(Image image) {
        this.image = image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setInsets(int nLeft, int nTop, int nRight, int nBottom) {
        this.insetsBorder.left = nLeft;
        this.insetsBorder.top = nTop;
        this.insetsBorder.right = nRight;
        this.insetsBorder.bottom = nBottom;
    }

    public void paint(Graphics g2) {
        Dimension dim = this.getSize();
        dim.width -= this.insetsBorder.left + this.insetsBorder.right;
        dim.height -= this.insetsBorder.top + this.insetsBorder.bottom;
        g2.drawImage(this.image, this.insetsBorder.left, this.insetsBorder.top, dim.width, dim.height, this);
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.image == null ? new Dimension(0, 0) : new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        dim.width += this.insetsBorder.left + this.insetsBorder.right;
        dim.height += this.insetsBorder.top + this.insetsBorder.bottom;
        return dim;
    }

    public static Image loadImage(String strFileName) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (strFileName == null) {
            return null;
        }
        if (!strFileName.startsWith("/jmapps/images/")) {
            strFileName = "/jmapps/images/" + strFileName;
        }
        try {
            Class<?> classObject = Class.forName("jmapps.ui.ImageArea");
            URL url = classObject.getResource(strFileName);
            if (url != null) {
                Object objImageProducer = url.getContent();
                if (objImageProducer instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)objImageProducer;
                    image = toolkit.createImage(imageProducer);
                } else if (objImageProducer instanceof BufferedInputStream) {
                    BufferedInputStream streamImage = (BufferedInputStream)objImageProducer;
                    byte[] arrImageBytes = new byte[streamImage.available()];
                    streamImage.read(arrImageBytes);
                    image = toolkit.createImage(arrImageBytes);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static Image loadImage(String strFileName, Component component, boolean boolWait) {
        Image image = ImageArea.loadImage(strFileName);
        if (image != null && boolWait) {
            MediaTracker trackerMedia = new MediaTracker(component);
            trackerMedia.addImage(image, 1001);
            try {
                trackerMedia.waitForID(1001);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return image;
    }
}

